/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPlatformBranchesRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<ListPlatformBranchesRequest.Builder, ListPlatformBranchesRequest> {
    private static final SdkField<List<SearchFilter>> FILTERS_FIELD = SdkField
            .<List<SearchFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListPlatformBranchesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(ListPlatformBranchesRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPlatformBranchesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RECORDS_FIELD, NEXT_TOKEN_FIELD));

    private final List<SearchFilter> filters;

    private final Integer maxRecords;

    private final String nextToken;

    private ListPlatformBranchesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical
     * conjunction (AND) of the separate <code>SearchFilter</code> terms.
     * </p>
     * <p>
     * The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most operators
     * take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Attribute = BranchName</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> |
     * <code>contains</code> | <code>in</code> | <code>not_in</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>Attribute = LifecycleState</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> | <code>retired</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>Attribute = PlatformName</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> |
     * <code>contains</code> | <code>in</code> | <code>not_in</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>Attribute = TierType</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Operator</code>: <code>=</code> | <code>!=</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Array size: limited to 10 <code>SearchFilter</code> objects.
     * </p>
     * <p>
     * Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical
     *         conjunction (AND) of the separate <code>SearchFilter</code> terms.</p>
     *         <p>
     *         The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most
     *         operators take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple
     *         values.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Attribute = BranchName</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> |
     *         <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Attribute = LifecycleState</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
     *         <code>retired</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Attribute = PlatformName</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> |
     *         <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Attribute = TierType</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Operator</code>: <code>=</code> | <code>!=</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         Array size: limited to 10 <code>SearchFilter</code> objects.
     *         </p>
     *         <p>
     *         Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.
     */
    public final List<SearchFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of platform branch values returned in one call.
     * </p>
     * 
     * @return The maximum number of platform branch values returned in one call.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * For a paginated request. Specify a token from a previous response page to retrieve the next response page. All
     * other parameter values must be identical to the ones specified in the initial request.
     * </p>
     * <p>
     * If no <code>NextToken</code> is specified, the first page is retrieved.
     * </p>
     * 
     * @return For a paginated request. Specify a token from a previous response page to retrieve the next response
     *         page. All other parameter values must be identical to the ones specified in the initial request.</p>
     *         <p>
     *         If no <code>NextToken</code> is specified, the first page is retrieved.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformBranchesRequest)) {
            return false;
        }
        ListPlatformBranchesRequest other = (ListPlatformBranchesRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPlatformBranchesRequest").add("Filters", hasFilters() ? filters() : null)
                .add("MaxRecords", maxRecords()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPlatformBranchesRequest, T> g) {
        return obj -> g.apply((ListPlatformBranchesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPlatformBranchesRequest> {
        /**
         * <p>
         * Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical
         * conjunction (AND) of the separate <code>SearchFilter</code> terms.
         * </p>
         * <p>
         * The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most
         * operators take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple
         * values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Attribute = BranchName</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> |
         * <code>contains</code> | <code>in</code> | <code>not_in</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Attribute = LifecycleState</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
         * <code>retired</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Attribute = PlatformName</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> |
         * <code>contains</code> | <code>in</code> | <code>not_in</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Attribute = TierType</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Operator</code>: <code>=</code> | <code>!=</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * Array size: limited to 10 <code>SearchFilter</code> objects.
         * </p>
         * <p>
         * Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.
         * </p>
         * 
         * @param filters
         *        Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical
         *        conjunction (AND) of the separate <code>SearchFilter</code> terms.</p>
         *        <p>
         *        The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most
         *        operators take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple
         *        values.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Attribute = BranchName</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> |
         *        <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Attribute = LifecycleState</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
         *        <code>retired</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Attribute = PlatformName</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> |
         *        <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Attribute = TierType</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Operator</code>: <code>=</code> | <code>!=</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        Array size: limited to 10 <code>SearchFilter</code> objects.
         *        </p>
         *        <p>
         *        Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<SearchFilter> filters);

        /**
         * <p>
         * Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical
         * conjunction (AND) of the separate <code>SearchFilter</code> terms.
         * </p>
         * <p>
         * The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most
         * operators take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple
         * values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Attribute = BranchName</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> |
         * <code>contains</code> | <code>in</code> | <code>not_in</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Attribute = LifecycleState</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
         * <code>retired</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Attribute = PlatformName</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> |
         * <code>contains</code> | <code>in</code> | <code>not_in</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Attribute = TierType</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Operator</code>: <code>=</code> | <code>!=</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * Array size: limited to 10 <code>SearchFilter</code> objects.
         * </p>
         * <p>
         * Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.
         * </p>
         * 
         * @param filters
         *        Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical
         *        conjunction (AND) of the separate <code>SearchFilter</code> terms.</p>
         *        <p>
         *        The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most
         *        operators take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple
         *        values.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Attribute = BranchName</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> |
         *        <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Attribute = LifecycleState</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
         *        <code>retired</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Attribute = PlatformName</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> |
         *        <code>ends_with</code> | <code>contains</code> | <code>in</code> | <code>not_in</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Attribute = TierType</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Operator</code>: <code>=</code> | <code>!=</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        Array size: limited to 10 <code>SearchFilter</code> objects.
         *        </p>
         *        <p>
         *        Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SearchFilter... filters);

        /**
         * <p>
         * Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical
         * conjunction (AND) of the separate <code>SearchFilter</code> terms.
         * </p>
         * <p>
         * The following list shows valid attribute values for each of the <code>SearchFilter</code> terms. Most
         * operators take a single value. The <code>in</code> and <code>not_in</code> operators can take multiple
         * values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Attribute = BranchName</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> |
         * <code>contains</code> | <code>in</code> | <code>not_in</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Attribute = LifecycleState</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>in</code> | <code>not_in</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Values</code>: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
         * <code>retired</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Attribute = PlatformName</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Operator</code>: <code>=</code> | <code>!=</code> | <code>begins_with</code> | <code>ends_with</code> |
         * <code>contains</code> | <code>in</code> | <code>not_in</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Attribute = TierType</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Operator</code>: <code>=</code> | <code>!=</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Values</code>: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * Array size: limited to 10 <code>SearchFilter</code> objects.
         * </p>
         * <p>
         * Within each <code>SearchFilter</code> item, the <code>Values</code> array is limited to 10 items.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<SearchFilter>.Builder} avoiding the
         * need to create one manually via {@link List<SearchFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SearchFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<SearchFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<SearchFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<SearchFilter>)
         */
        Builder filters(Consumer<SearchFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of platform branch values returned in one call.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of platform branch values returned in one call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * For a paginated request. Specify a token from a previous response page to retrieve the next response page.
         * All other parameter values must be identical to the ones specified in the initial request.
         * </p>
         * <p>
         * If no <code>NextToken</code> is specified, the first page is retrieved.
         * </p>
         * 
         * @param nextToken
         *        For a paginated request. Specify a token from a previous response page to retrieve the next response
         *        page. All other parameter values must be identical to the ones specified in the initial request.</p>
         *        <p>
         *        If no <code>NextToken</code> is specified, the first page is retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private List<SearchFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformBranchesRequest model) {
            super(model);
            filters(model.filters);
            maxRecords(model.maxRecords);
            nextToken(model.nextToken);
        }

        public final List<SearchFilter.Builder> getFilters() {
            List<SearchFilter.Builder> result = SearchFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<SearchFilter.BuilderImpl> filters) {
            this.filters = SearchFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<SearchFilter> filters) {
            this.filters = SearchFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SearchFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SearchFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> SearchFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPlatformBranchesRequest build() {
            return new ListPlatformBranchesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
