/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountAttributesResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<DescribeAccountAttributesResponse.Builder, DescribeAccountAttributesResponse> {
    private static final SdkField<ResourceQuotas> RESOURCE_QUOTAS_FIELD = SdkField
            .<ResourceQuotas> builder(MarshallingType.SDK_POJO).memberName("ResourceQuotas")
            .getter(getter(DescribeAccountAttributesResponse::resourceQuotas)).setter(setter(Builder::resourceQuotas))
            .constructor(ResourceQuotas::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuotas").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_QUOTAS_FIELD));

    private final ResourceQuotas resourceQuotas;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceQuotas = builder.resourceQuotas;
    }

    /**
     * <p>
     * The Elastic Beanstalk resource quotas associated with the calling AWS account.
     * </p>
     * 
     * @return The Elastic Beanstalk resource quotas associated with the calling AWS account.
     */
    public final ResourceQuotas resourceQuotas() {
        return resourceQuotas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceQuotas());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse) obj;
        return Objects.equals(resourceQuotas(), other.resourceQuotas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountAttributesResponse").add("ResourceQuotas", resourceQuotas()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceQuotas":
            return Optional.ofNullable(clazz.cast(resourceQuotas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountAttributesResponse, T> g) {
        return obj -> g.apply((DescribeAccountAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        /**
         * <p>
         * The Elastic Beanstalk resource quotas associated with the calling AWS account.
         * </p>
         * 
         * @param resourceQuotas
         *        The Elastic Beanstalk resource quotas associated with the calling AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceQuotas(ResourceQuotas resourceQuotas);

        /**
         * <p>
         * The Elastic Beanstalk resource quotas associated with the calling AWS account.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceQuotas.Builder} avoiding the need
         * to create one manually via {@link ResourceQuotas#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceQuotas.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceQuotas(ResourceQuotas)}.
         * 
         * @param resourceQuotas
         *        a consumer that will call methods on {@link ResourceQuotas.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceQuotas(ResourceQuotas)
         */
        default Builder resourceQuotas(Consumer<ResourceQuotas.Builder> resourceQuotas) {
            return resourceQuotas(ResourceQuotas.builder().applyMutation(resourceQuotas).build());
        }
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private ResourceQuotas resourceQuotas;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            super(model);
            resourceQuotas(model.resourceQuotas);
        }

        public final ResourceQuotas.Builder getResourceQuotas() {
            return resourceQuotas != null ? resourceQuotas.toBuilder() : null;
        }

        public final void setResourceQuotas(ResourceQuotas.BuilderImpl resourceQuotas) {
            this.resourceQuotas = resourceQuotas != null ? resourceQuotas.build() : null;
        }

        @Override
        public final Builder resourceQuotas(ResourceQuotas resourceQuotas) {
            this.resourceQuotas = resourceQuotas;
            return this;
        }

        @Override
        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
