/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result message containing a list of application descriptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationsResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<DescribeApplicationsResponse.Builder, DescribeApplicationsResponse> {
    private static final SdkField<List<ApplicationDescription>> APPLICATIONS_FIELD = SdkField
            .<List<ApplicationDescription>> builder(MarshallingType.LIST)
            .memberName("Applications")
            .getter(getter(DescribeApplicationsResponse::applications))
            .setter(setter(Builder::applications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATIONS_FIELD));

    private final List<ApplicationDescription> applications;

    private DescribeApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applications = builder.applications;
    }

    /**
     * For responses, this returns true if the service returned a value for the Applications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplications() {
        return applications != null && !(applications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This parameter contains a list of <a>ApplicationDescription</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplications} method.
     * </p>
     * 
     * @return This parameter contains a list of <a>ApplicationDescription</a>.
     */
    public final List<ApplicationDescription> applications() {
        return applications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplications() ? applications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationsResponse)) {
            return false;
        }
        DescribeApplicationsResponse other = (DescribeApplicationsResponse) obj;
        return hasApplications() == other.hasApplications() && Objects.equals(applications(), other.applications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicationsResponse").add("Applications", hasApplications() ? applications() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Applications":
            return Optional.ofNullable(clazz.cast(applications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationsResponse, T> g) {
        return obj -> g.apply((DescribeApplicationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicationsResponse> {
        /**
         * <p>
         * This parameter contains a list of <a>ApplicationDescription</a>.
         * </p>
         * 
         * @param applications
         *        This parameter contains a list of <a>ApplicationDescription</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Collection<ApplicationDescription> applications);

        /**
         * <p>
         * This parameter contains a list of <a>ApplicationDescription</a>.
         * </p>
         * 
         * @param applications
         *        This parameter contains a list of <a>ApplicationDescription</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(ApplicationDescription... applications);

        /**
         * <p>
         * This parameter contains a list of <a>ApplicationDescription</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ApplicationDescription>.Builder}
         * avoiding the need to create one manually via {@link List<ApplicationDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApplicationDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #applications(List<ApplicationDescription>)}.
         * 
         * @param applications
         *        a consumer that will call methods on {@link List<ApplicationDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applications(List<ApplicationDescription>)
         */
        Builder applications(Consumer<ApplicationDescription.Builder>... applications);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<ApplicationDescription> applications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationsResponse model) {
            super(model);
            applications(model.applications);
        }

        public final List<ApplicationDescription.Builder> getApplications() {
            List<ApplicationDescription.Builder> result = ApplicationDescriptionListCopier.copyToBuilder(this.applications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplications(Collection<ApplicationDescription.BuilderImpl> applications) {
            this.applications = ApplicationDescriptionListCopier.copyFromBuilder(applications);
        }

        @Override
        public final Builder applications(Collection<ApplicationDescription> applications) {
            this.applications = ApplicationDescriptionListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(ApplicationDescription... applications) {
            applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<ApplicationDescription.Builder>... applications) {
            applications(Stream.of(applications).map(c -> ApplicationDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeApplicationsResponse build() {
            return new DescribeApplicationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
