/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.MaxAgeRule;
import software.amazon.awssdk.services.elasticbeanstalk.model.MaxCountRule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationVersionLifecycleConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationVersionLifecycleConfig> {
    private static final SdkField<MaxCountRule> MAX_COUNT_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaxCountRule").getter(ApplicationVersionLifecycleConfig.getter(ApplicationVersionLifecycleConfig::maxCountRule)).setter(ApplicationVersionLifecycleConfig.setter(Builder::maxCountRule)).constructor(MaxCountRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCountRule").build()}).build();
    private static final SdkField<MaxAgeRule> MAX_AGE_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaxAgeRule").getter(ApplicationVersionLifecycleConfig.getter(ApplicationVersionLifecycleConfig::maxAgeRule)).setter(ApplicationVersionLifecycleConfig.setter(Builder::maxAgeRule)).constructor(MaxAgeRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAgeRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_COUNT_RULE_FIELD, MAX_AGE_RULE_FIELD));
    private static final long serialVersionUID = 1L;
    private final MaxCountRule maxCountRule;
    private final MaxAgeRule maxAgeRule;

    private ApplicationVersionLifecycleConfig(BuilderImpl builder) {
        this.maxCountRule = builder.maxCountRule;
        this.maxAgeRule = builder.maxAgeRule;
    }

    public final MaxCountRule maxCountRule() {
        return this.maxCountRule;
    }

    public final MaxAgeRule maxAgeRule() {
        return this.maxAgeRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCountRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAgeRule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationVersionLifecycleConfig)) {
            return false;
        }
        ApplicationVersionLifecycleConfig other = (ApplicationVersionLifecycleConfig)obj;
        return Objects.equals(this.maxCountRule(), other.maxCountRule()) && Objects.equals(this.maxAgeRule(), other.maxAgeRule());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationVersionLifecycleConfig").add("MaxCountRule", (Object)this.maxCountRule()).add("MaxAgeRule", (Object)this.maxAgeRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxCountRule": {
                return Optional.ofNullable(clazz.cast(this.maxCountRule()));
            }
            case "MaxAgeRule": {
                return Optional.ofNullable(clazz.cast(this.maxAgeRule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationVersionLifecycleConfig, T> g) {
        return obj -> g.apply((ApplicationVersionLifecycleConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MaxCountRule maxCountRule;
        private MaxAgeRule maxAgeRule;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationVersionLifecycleConfig model) {
            this.maxCountRule(model.maxCountRule);
            this.maxAgeRule(model.maxAgeRule);
        }

        public final MaxCountRule.Builder getMaxCountRule() {
            return this.maxCountRule != null ? this.maxCountRule.toBuilder() : null;
        }

        public final void setMaxCountRule(MaxCountRule.BuilderImpl maxCountRule) {
            this.maxCountRule = maxCountRule != null ? maxCountRule.build() : null;
        }

        @Override
        public final Builder maxCountRule(MaxCountRule maxCountRule) {
            this.maxCountRule = maxCountRule;
            return this;
        }

        public final MaxAgeRule.Builder getMaxAgeRule() {
            return this.maxAgeRule != null ? this.maxAgeRule.toBuilder() : null;
        }

        public final void setMaxAgeRule(MaxAgeRule.BuilderImpl maxAgeRule) {
            this.maxAgeRule = maxAgeRule != null ? maxAgeRule.build() : null;
        }

        @Override
        public final Builder maxAgeRule(MaxAgeRule maxAgeRule) {
            this.maxAgeRule = maxAgeRule;
            return this;
        }

        public ApplicationVersionLifecycleConfig build() {
            return new ApplicationVersionLifecycleConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationVersionLifecycleConfig> {
        public Builder maxCountRule(MaxCountRule var1);

        default public Builder maxCountRule(Consumer<MaxCountRule.Builder> maxCountRule) {
            return this.maxCountRule((MaxCountRule)((MaxCountRule.Builder)MaxCountRule.builder().applyMutation(maxCountRule)).build());
        }

        public Builder maxAgeRule(MaxAgeRule var1);

        default public Builder maxAgeRule(Consumer<MaxAgeRule.Builder> maxAgeRule) {
            return this.maxAgeRule((MaxAgeRule)((MaxAgeRule.Builder)MaxAgeRule.builder().applyMutation(maxAgeRule)).build());
        }
    }
}

