/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed health information about the Amazon EC2 instances in an AWS Elastic Beanstalk environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstancesHealthResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<DescribeInstancesHealthResponse.Builder, DescribeInstancesHealthResponse> {
    private static final SdkField<List<SingleInstanceHealth>> INSTANCE_HEALTH_LIST_FIELD = SdkField
            .<List<SingleInstanceHealth>> builder(MarshallingType.LIST)
            .memberName("InstanceHealthList")
            .getter(getter(DescribeInstancesHealthResponse::instanceHealthList))
            .setter(setter(Builder::instanceHealthList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceHealthList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SingleInstanceHealth> builder(MarshallingType.SDK_POJO)
                                            .constructor(SingleInstanceHealth::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> REFRESHED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RefreshedAt").getter(getter(DescribeInstancesHealthResponse::refreshedAt))
            .setter(setter(Builder::refreshedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshedAt").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeInstancesHealthResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_HEALTH_LIST_FIELD,
            REFRESHED_AT_FIELD, NEXT_TOKEN_FIELD));

    private final List<SingleInstanceHealth> instanceHealthList;

    private final Instant refreshedAt;

    private final String nextToken;

    private DescribeInstancesHealthResponse(BuilderImpl builder) {
        super(builder);
        this.instanceHealthList = builder.instanceHealthList;
        this.refreshedAt = builder.refreshedAt;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceHealthList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceHealthList() {
        return instanceHealthList != null && !(instanceHealthList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Detailed health information about each instance.
     * </p>
     * <p>
     * The output differs slightly between Linux and Windows environments. There is a difference in the members that are
     * supported under the <code>&lt;CPUUtilization&gt;</code> type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceHealthList} method.
     * </p>
     * 
     * @return Detailed health information about each instance.</p>
     *         <p>
     *         The output differs slightly between Linux and Windows environments. There is a difference in the members
     *         that are supported under the <code>&lt;CPUUtilization&gt;</code> type.
     */
    public final List<SingleInstanceHealth> instanceHealthList() {
        return instanceHealthList;
    }

    /**
     * <p>
     * The date and time that the health information was retrieved.
     * </p>
     * 
     * @return The date and time that the health information was retrieved.
     */
    public final Instant refreshedAt() {
        return refreshedAt;
    }

    /**
     * <p>
     * Pagination token for the next page of results, if available.
     * </p>
     * 
     * @return Pagination token for the next page of results, if available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceHealthList() ? instanceHealthList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(refreshedAt());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesHealthResponse)) {
            return false;
        }
        DescribeInstancesHealthResponse other = (DescribeInstancesHealthResponse) obj;
        return hasInstanceHealthList() == other.hasInstanceHealthList()
                && Objects.equals(instanceHealthList(), other.instanceHealthList())
                && Objects.equals(refreshedAt(), other.refreshedAt()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstancesHealthResponse")
                .add("InstanceHealthList", hasInstanceHealthList() ? instanceHealthList() : null)
                .add("RefreshedAt", refreshedAt()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceHealthList":
            return Optional.ofNullable(clazz.cast(instanceHealthList()));
        case "RefreshedAt":
            return Optional.ofNullable(clazz.cast(refreshedAt()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancesHealthResponse, T> g) {
        return obj -> g.apply((DescribeInstancesHealthResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstancesHealthResponse> {
        /**
         * <p>
         * Detailed health information about each instance.
         * </p>
         * <p>
         * The output differs slightly between Linux and Windows environments. There is a difference in the members that
         * are supported under the <code>&lt;CPUUtilization&gt;</code> type.
         * </p>
         * 
         * @param instanceHealthList
         *        Detailed health information about each instance.</p>
         *        <p>
         *        The output differs slightly between Linux and Windows environments. There is a difference in the
         *        members that are supported under the <code>&lt;CPUUtilization&gt;</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceHealthList(Collection<SingleInstanceHealth> instanceHealthList);

        /**
         * <p>
         * Detailed health information about each instance.
         * </p>
         * <p>
         * The output differs slightly between Linux and Windows environments. There is a difference in the members that
         * are supported under the <code>&lt;CPUUtilization&gt;</code> type.
         * </p>
         * 
         * @param instanceHealthList
         *        Detailed health information about each instance.</p>
         *        <p>
         *        The output differs slightly between Linux and Windows environments. There is a difference in the
         *        members that are supported under the <code>&lt;CPUUtilization&gt;</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceHealthList(SingleInstanceHealth... instanceHealthList);

        /**
         * <p>
         * Detailed health information about each instance.
         * </p>
         * <p>
         * The output differs slightly between Linux and Windows environments. There is a difference in the members that
         * are supported under the <code>&lt;CPUUtilization&gt;</code> type.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<SingleInstanceHealth>.Builder}
         * avoiding the need to create one manually via {@link List<SingleInstanceHealth>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SingleInstanceHealth>.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceHealthList(List<SingleInstanceHealth>)}.
         * 
         * @param instanceHealthList
         *        a consumer that will call methods on {@link List<SingleInstanceHealth>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceHealthList(List<SingleInstanceHealth>)
         */
        Builder instanceHealthList(Consumer<SingleInstanceHealth.Builder>... instanceHealthList);

        /**
         * <p>
         * The date and time that the health information was retrieved.
         * </p>
         * 
         * @param refreshedAt
         *        The date and time that the health information was retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshedAt(Instant refreshedAt);

        /**
         * <p>
         * Pagination token for the next page of results, if available.
         * </p>
         * 
         * @param nextToken
         *        Pagination token for the next page of results, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<SingleInstanceHealth> instanceHealthList = DefaultSdkAutoConstructList.getInstance();

        private Instant refreshedAt;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesHealthResponse model) {
            super(model);
            instanceHealthList(model.instanceHealthList);
            refreshedAt(model.refreshedAt);
            nextToken(model.nextToken);
        }

        public final List<SingleInstanceHealth.Builder> getInstanceHealthList() {
            List<SingleInstanceHealth.Builder> result = InstanceHealthListCopier.copyToBuilder(this.instanceHealthList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceHealthList(Collection<SingleInstanceHealth.BuilderImpl> instanceHealthList) {
            this.instanceHealthList = InstanceHealthListCopier.copyFromBuilder(instanceHealthList);
        }

        @Override
        public final Builder instanceHealthList(Collection<SingleInstanceHealth> instanceHealthList) {
            this.instanceHealthList = InstanceHealthListCopier.copy(instanceHealthList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceHealthList(SingleInstanceHealth... instanceHealthList) {
            instanceHealthList(Arrays.asList(instanceHealthList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceHealthList(Consumer<SingleInstanceHealth.Builder>... instanceHealthList) {
            instanceHealthList(Stream.of(instanceHealthList).map(c -> SingleInstanceHealth.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getRefreshedAt() {
            return refreshedAt;
        }

        public final void setRefreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
        }

        @Override
        public final Builder refreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeInstancesHealthResponse build() {
            return new DescribeInstancesHealthResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
