/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result message containing a description of the requested environment info.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveEnvironmentInfoResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<RetrieveEnvironmentInfoResponse.Builder, RetrieveEnvironmentInfoResponse> {
    private static final SdkField<List<EnvironmentInfoDescription>> ENVIRONMENT_INFO_FIELD = SdkField
            .<List<EnvironmentInfoDescription>> builder(MarshallingType.LIST)
            .memberName("EnvironmentInfo")
            .getter(getter(RetrieveEnvironmentInfoResponse::environmentInfo))
            .setter(setter(Builder::environmentInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentInfoDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentInfoDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_INFO_FIELD));

    private final List<EnvironmentInfoDescription> environmentInfo;

    private RetrieveEnvironmentInfoResponse(BuilderImpl builder) {
        super(builder);
        this.environmentInfo = builder.environmentInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentInfo property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentInfo() {
        return environmentInfo != null && !(environmentInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <a>EnvironmentInfoDescription</a> of the environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentInfo} method.
     * </p>
     * 
     * @return The <a>EnvironmentInfoDescription</a> of the environment.
     */
    public final List<EnvironmentInfoDescription> environmentInfo() {
        return environmentInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentInfo() ? environmentInfo() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveEnvironmentInfoResponse)) {
            return false;
        }
        RetrieveEnvironmentInfoResponse other = (RetrieveEnvironmentInfoResponse) obj;
        return hasEnvironmentInfo() == other.hasEnvironmentInfo() && Objects.equals(environmentInfo(), other.environmentInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrieveEnvironmentInfoResponse")
                .add("EnvironmentInfo", hasEnvironmentInfo() ? environmentInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentInfo":
            return Optional.ofNullable(clazz.cast(environmentInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveEnvironmentInfoResponse, T> g) {
        return obj -> g.apply((RetrieveEnvironmentInfoResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RetrieveEnvironmentInfoResponse> {
        /**
         * <p>
         * The <a>EnvironmentInfoDescription</a> of the environment.
         * </p>
         * 
         * @param environmentInfo
         *        The <a>EnvironmentInfoDescription</a> of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentInfo(Collection<EnvironmentInfoDescription> environmentInfo);

        /**
         * <p>
         * The <a>EnvironmentInfoDescription</a> of the environment.
         * </p>
         * 
         * @param environmentInfo
         *        The <a>EnvironmentInfoDescription</a> of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentInfo(EnvironmentInfoDescription... environmentInfo);

        /**
         * <p>
         * The <a>EnvironmentInfoDescription</a> of the environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EnvironmentInfoDescription>.Builder}
         * avoiding the need to create one manually via {@link List<EnvironmentInfoDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnvironmentInfoDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #environmentInfo(List<EnvironmentInfoDescription>)}.
         * 
         * @param environmentInfo
         *        a consumer that will call methods on {@link List<EnvironmentInfoDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentInfo(List<EnvironmentInfoDescription>)
         */
        Builder environmentInfo(Consumer<EnvironmentInfoDescription.Builder>... environmentInfo);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<EnvironmentInfoDescription> environmentInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveEnvironmentInfoResponse model) {
            super(model);
            environmentInfo(model.environmentInfo);
        }

        public final List<EnvironmentInfoDescription.Builder> getEnvironmentInfo() {
            List<EnvironmentInfoDescription.Builder> result = EnvironmentInfoDescriptionListCopier
                    .copyToBuilder(this.environmentInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentInfo(Collection<EnvironmentInfoDescription.BuilderImpl> environmentInfo) {
            this.environmentInfo = EnvironmentInfoDescriptionListCopier.copyFromBuilder(environmentInfo);
        }

        @Override
        public final Builder environmentInfo(Collection<EnvironmentInfoDescription> environmentInfo) {
            this.environmentInfo = EnvironmentInfoDescriptionListCopier.copy(environmentInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentInfo(EnvironmentInfoDescription... environmentInfo) {
            environmentInfo(Arrays.asList(environmentInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentInfo(Consumer<EnvironmentInfoDescription.Builder>... environmentInfo) {
            environmentInfo(Stream.of(environmentInfo).map(c -> EnvironmentInfoDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RetrieveEnvironmentInfoResponse build() {
            return new RetrieveEnvironmentInfoResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
