/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the AWS resources in use by this environment. This data is not live data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentResourcesDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentResourcesDescription.Builder, EnvironmentResourcesDescription> {
    private static final SdkField<LoadBalancerDescription> LOAD_BALANCER_FIELD = SdkField
            .<LoadBalancerDescription> builder(MarshallingType.SDK_POJO).memberName("LoadBalancer")
            .getter(getter(EnvironmentResourcesDescription::loadBalancer)).setter(setter(Builder::loadBalancer))
            .constructor(LoadBalancerDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_FIELD));

    private static final long serialVersionUID = 1L;

    private final LoadBalancerDescription loadBalancer;

    private EnvironmentResourcesDescription(BuilderImpl builder) {
        this.loadBalancer = builder.loadBalancer;
    }

    /**
     * <p>
     * Describes the LoadBalancer.
     * </p>
     * 
     * @return Describes the LoadBalancer.
     */
    public final LoadBalancerDescription loadBalancer() {
        return loadBalancer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentResourcesDescription)) {
            return false;
        }
        EnvironmentResourcesDescription other = (EnvironmentResourcesDescription) obj;
        return Objects.equals(loadBalancer(), other.loadBalancer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentResourcesDescription").add("LoadBalancer", loadBalancer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancer":
            return Optional.ofNullable(clazz.cast(loadBalancer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentResourcesDescription, T> g) {
        return obj -> g.apply((EnvironmentResourcesDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentResourcesDescription> {
        /**
         * <p>
         * Describes the LoadBalancer.
         * </p>
         * 
         * @param loadBalancer
         *        Describes the LoadBalancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancer(LoadBalancerDescription loadBalancer);

        /**
         * <p>
         * Describes the LoadBalancer.
         * </p>
         * This is a convenience that creates an instance of the {@link LoadBalancerDescription.Builder} avoiding the
         * need to create one manually via {@link LoadBalancerDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoadBalancerDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #loadBalancer(LoadBalancerDescription)}.
         * 
         * @param loadBalancer
         *        a consumer that will call methods on {@link LoadBalancerDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancer(LoadBalancerDescription)
         */
        default Builder loadBalancer(Consumer<LoadBalancerDescription.Builder> loadBalancer) {
            return loadBalancer(LoadBalancerDescription.builder().applyMutation(loadBalancer).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LoadBalancerDescription loadBalancer;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentResourcesDescription model) {
            loadBalancer(model.loadBalancer);
        }

        public final LoadBalancerDescription.Builder getLoadBalancer() {
            return loadBalancer != null ? loadBalancer.toBuilder() : null;
        }

        public final void setLoadBalancer(LoadBalancerDescription.BuilderImpl loadBalancer) {
            this.loadBalancer = loadBalancer != null ? loadBalancer.build() : null;
        }

        @Override
        @Transient
        public final Builder loadBalancer(LoadBalancerDescription loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        @Override
        public EnvironmentResourcesDescription build() {
            return new EnvironmentResourcesDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
