/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result message wrapping a single description of an application version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationVersionResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<UpdateApplicationVersionResponse.Builder, UpdateApplicationVersionResponse> {
    private static final SdkField<ApplicationVersionDescription> APPLICATION_VERSION_FIELD = SdkField
            .<ApplicationVersionDescription> builder(MarshallingType.SDK_POJO).memberName("ApplicationVersion")
            .getter(getter(UpdateApplicationVersionResponse::applicationVersion)).setter(setter(Builder::applicationVersion))
            .constructor(ApplicationVersionDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_VERSION_FIELD));

    private final ApplicationVersionDescription applicationVersion;

    private UpdateApplicationVersionResponse(BuilderImpl builder) {
        super(builder);
        this.applicationVersion = builder.applicationVersion;
    }

    /**
     * <p>
     * The <a>ApplicationVersionDescription</a> of the application version.
     * </p>
     * 
     * @return The <a>ApplicationVersionDescription</a> of the application version.
     */
    public final ApplicationVersionDescription applicationVersion() {
        return applicationVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationVersionResponse)) {
            return false;
        }
        UpdateApplicationVersionResponse other = (UpdateApplicationVersionResponse) obj;
        return Objects.equals(applicationVersion(), other.applicationVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationVersionResponse").add("ApplicationVersion", applicationVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationVersion":
            return Optional.ofNullable(clazz.cast(applicationVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationVersionResponse, T> g) {
        return obj -> g.apply((UpdateApplicationVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApplicationVersionResponse> {
        /**
         * <p>
         * The <a>ApplicationVersionDescription</a> of the application version.
         * </p>
         * 
         * @param applicationVersion
         *        The <a>ApplicationVersionDescription</a> of the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersion(ApplicationVersionDescription applicationVersion);

        /**
         * <p>
         * The <a>ApplicationVersionDescription</a> of the application version.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationVersionDescription.Builder} avoiding
         * the need to create one manually via {@link ApplicationVersionDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationVersionDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #applicationVersion(ApplicationVersionDescription)}.
         * 
         * @param applicationVersion
         *        a consumer that will call methods on {@link ApplicationVersionDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationVersion(ApplicationVersionDescription)
         */
        default Builder applicationVersion(Consumer<ApplicationVersionDescription.Builder> applicationVersion) {
            return applicationVersion(ApplicationVersionDescription.builder().applyMutation(applicationVersion).build());
        }
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private ApplicationVersionDescription applicationVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationVersionResponse model) {
            super(model);
            applicationVersion(model.applicationVersion);
        }

        public final ApplicationVersionDescription.Builder getApplicationVersion() {
            return applicationVersion != null ? applicationVersion.toBuilder() : null;
        }

        public final void setApplicationVersion(ApplicationVersionDescription.BuilderImpl applicationVersion) {
            this.applicationVersion = applicationVersion != null ? applicationVersion.build() : null;
        }

        @Override
        @Transient
        public final Builder applicationVersion(ApplicationVersionDescription applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        @Override
        public UpdateApplicationVersionResponse build() {
            return new UpdateApplicationVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
