/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of an application version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationVersionDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationVersionDescription.Builder, ApplicationVersionDescription> {
    private static final SdkField<String> APPLICATION_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationVersionArn").getter(getter(ApplicationVersionDescription::applicationVersionArn))
            .setter(setter(Builder::applicationVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionArn").build())
            .build();

    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(ApplicationVersionDescription::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ApplicationVersionDescription::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionLabel").getter(getter(ApplicationVersionDescription::versionLabel))
            .setter(setter(Builder::versionLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()).build();

    private static final SdkField<SourceBuildInformation> SOURCE_BUILD_INFORMATION_FIELD = SdkField
            .<SourceBuildInformation> builder(MarshallingType.SDK_POJO).memberName("SourceBuildInformation")
            .getter(getter(ApplicationVersionDescription::sourceBuildInformation))
            .setter(setter(Builder::sourceBuildInformation)).constructor(SourceBuildInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBuildInformation").build())
            .build();

    private static final SdkField<String> BUILD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BuildArn").getter(getter(ApplicationVersionDescription::buildArn)).setter(setter(Builder::buildArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildArn").build()).build();

    private static final SdkField<S3Location> SOURCE_BUNDLE_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("SourceBundle").getter(getter(ApplicationVersionDescription::sourceBundle))
            .setter(setter(Builder::sourceBundle)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBundle").build()).build();

    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateCreated").getter(getter(ApplicationVersionDescription::dateCreated))
            .setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()).build();

    private static final SdkField<Instant> DATE_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateUpdated").getter(getter(ApplicationVersionDescription::dateUpdated))
            .setter(setter(Builder::dateUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateUpdated").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ApplicationVersionDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_VERSION_ARN_FIELD,
            APPLICATION_NAME_FIELD, DESCRIPTION_FIELD, VERSION_LABEL_FIELD, SOURCE_BUILD_INFORMATION_FIELD, BUILD_ARN_FIELD,
            SOURCE_BUNDLE_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationVersionArn;

    private final String applicationName;

    private final String description;

    private final String versionLabel;

    private final SourceBuildInformation sourceBuildInformation;

    private final String buildArn;

    private final S3Location sourceBundle;

    private final Instant dateCreated;

    private final Instant dateUpdated;

    private final String status;

    private ApplicationVersionDescription(BuilderImpl builder) {
        this.applicationVersionArn = builder.applicationVersionArn;
        this.applicationName = builder.applicationName;
        this.description = builder.description;
        this.versionLabel = builder.versionLabel;
        this.sourceBuildInformation = builder.sourceBuildInformation;
        this.buildArn = builder.buildArn;
        this.sourceBundle = builder.sourceBundle;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application version.
     */
    public final String applicationVersionArn() {
        return applicationVersionArn;
    }

    /**
     * <p>
     * The name of the application to which the application version belongs.
     * </p>
     * 
     * @return The name of the application to which the application version belongs.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The description of the application version.
     * </p>
     * 
     * @return The description of the application version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique identifier for the application version.
     * </p>
     * 
     * @return A unique identifier for the application version.
     */
    public final String versionLabel() {
        return versionLabel;
    }

    /**
     * <p>
     * If the version's source code was retrieved from AWS CodeCommit, the location of the source code for the
     * application version.
     * </p>
     * 
     * @return If the version's source code was retrieved from AWS CodeCommit, the location of the source code for the
     *         application version.
     */
    public final SourceBuildInformation sourceBuildInformation() {
        return sourceBuildInformation;
    }

    /**
     * <p>
     * Reference to the artifact from the AWS CodeBuild build.
     * </p>
     * 
     * @return Reference to the artifact from the AWS CodeBuild build.
     */
    public final String buildArn() {
        return buildArn;
    }

    /**
     * <p>
     * The storage location of the application version's source bundle in Amazon S3.
     * </p>
     * 
     * @return The storage location of the application version's source bundle in Amazon S3.
     */
    public final S3Location sourceBundle() {
        return sourceBundle;
    }

    /**
     * <p>
     * The creation date of the application version.
     * </p>
     * 
     * @return The creation date of the application version.
     */
    public final Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The last modified date of the application version.
     * </p>
     * 
     * @return The last modified date of the application version.
     */
    public final Instant dateUpdated() {
        return dateUpdated;
    }

    /**
     * <p>
     * The processing status of the application version. Reflects the state of the application version during its
     * creation. Many of the values are only applicable if you specified <code>True</code> for the <code>Process</code>
     * parameter of the <code>CreateApplicationVersion</code> action. The following list describes the possible values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Unprocessed</code> – Application version wasn't pre-processed or validated. Elastic Beanstalk will validate
     * configuration files during deployment of the application version to an environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Processing</code> – Elastic Beanstalk is currently processing the application version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Building</code> – Application version is currently undergoing an AWS CodeBuild build.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Processed</code> – Elastic Beanstalk was successfully pre-processed and validated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> – Either the AWS CodeBuild build failed or configuration files didn't pass validation. This
     * application version isn't usable.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The processing status of the application version. Reflects the state of the application version during
     *         its creation. Many of the values are only applicable if you specified <code>True</code> for the
     *         <code>Process</code> parameter of the <code>CreateApplicationVersion</code> action. The following list
     *         describes the possible values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Unprocessed</code> – Application version wasn't pre-processed or validated. Elastic Beanstalk will
     *         validate configuration files during deployment of the application version to an environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Processing</code> – Elastic Beanstalk is currently processing the application version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Building</code> – Application version is currently undergoing an AWS CodeBuild build.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Processed</code> – Elastic Beanstalk was successfully pre-processed and validated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> – Either the AWS CodeBuild build failed or configuration files didn't pass
     *         validation. This application version isn't usable.
     *         </p>
     *         </li>
     * @see ApplicationVersionStatus
     */
    public final ApplicationVersionStatus status() {
        return ApplicationVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The processing status of the application version. Reflects the state of the application version during its
     * creation. Many of the values are only applicable if you specified <code>True</code> for the <code>Process</code>
     * parameter of the <code>CreateApplicationVersion</code> action. The following list describes the possible values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Unprocessed</code> – Application version wasn't pre-processed or validated. Elastic Beanstalk will validate
     * configuration files during deployment of the application version to an environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Processing</code> – Elastic Beanstalk is currently processing the application version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Building</code> – Application version is currently undergoing an AWS CodeBuild build.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Processed</code> – Elastic Beanstalk was successfully pre-processed and validated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> – Either the AWS CodeBuild build failed or configuration files didn't pass validation. This
     * application version isn't usable.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The processing status of the application version. Reflects the state of the application version during
     *         its creation. Many of the values are only applicable if you specified <code>True</code> for the
     *         <code>Process</code> parameter of the <code>CreateApplicationVersion</code> action. The following list
     *         describes the possible values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Unprocessed</code> – Application version wasn't pre-processed or validated. Elastic Beanstalk will
     *         validate configuration files during deployment of the application version to an environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Processing</code> – Elastic Beanstalk is currently processing the application version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Building</code> – Application version is currently undergoing an AWS CodeBuild build.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Processed</code> – Elastic Beanstalk was successfully pre-processed and validated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> – Either the AWS CodeBuild build failed or configuration files didn't pass
     *         validation. This application version isn't usable.
     *         </p>
     *         </li>
     * @see ApplicationVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBuildInformation());
        hashCode = 31 * hashCode + Objects.hashCode(buildArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBundle());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationVersionDescription)) {
            return false;
        }
        ApplicationVersionDescription other = (ApplicationVersionDescription) obj;
        return Objects.equals(applicationVersionArn(), other.applicationVersionArn())
                && Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(description(), other.description()) && Objects.equals(versionLabel(), other.versionLabel())
                && Objects.equals(sourceBuildInformation(), other.sourceBuildInformation())
                && Objects.equals(buildArn(), other.buildArn()) && Objects.equals(sourceBundle(), other.sourceBundle())
                && Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(dateUpdated(), other.dateUpdated())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationVersionDescription").add("ApplicationVersionArn", applicationVersionArn())
                .add("ApplicationName", applicationName()).add("Description", description()).add("VersionLabel", versionLabel())
                .add("SourceBuildInformation", sourceBuildInformation()).add("BuildArn", buildArn())
                .add("SourceBundle", sourceBundle()).add("DateCreated", dateCreated()).add("DateUpdated", dateUpdated())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationVersionArn":
            return Optional.ofNullable(clazz.cast(applicationVersionArn()));
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "VersionLabel":
            return Optional.ofNullable(clazz.cast(versionLabel()));
        case "SourceBuildInformation":
            return Optional.ofNullable(clazz.cast(sourceBuildInformation()));
        case "BuildArn":
            return Optional.ofNullable(clazz.cast(buildArn()));
        case "SourceBundle":
            return Optional.ofNullable(clazz.cast(sourceBundle()));
        case "DateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "DateUpdated":
            return Optional.ofNullable(clazz.cast(dateUpdated()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationVersionDescription, T> g) {
        return obj -> g.apply((ApplicationVersionDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationVersionDescription> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application version.
         * </p>
         * 
         * @param applicationVersionArn
         *        The Amazon Resource Name (ARN) of the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionArn(String applicationVersionArn);

        /**
         * <p>
         * The name of the application to which the application version belongs.
         * </p>
         * 
         * @param applicationName
         *        The name of the application to which the application version belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The description of the application version.
         * </p>
         * 
         * @param description
         *        The description of the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique identifier for the application version.
         * </p>
         * 
         * @param versionLabel
         *        A unique identifier for the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionLabel(String versionLabel);

        /**
         * <p>
         * If the version's source code was retrieved from AWS CodeCommit, the location of the source code for the
         * application version.
         * </p>
         * 
         * @param sourceBuildInformation
         *        If the version's source code was retrieved from AWS CodeCommit, the location of the source code for
         *        the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBuildInformation(SourceBuildInformation sourceBuildInformation);

        /**
         * <p>
         * If the version's source code was retrieved from AWS CodeCommit, the location of the source code for the
         * application version.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceBuildInformation.Builder} avoiding the
         * need to create one manually via {@link SourceBuildInformation#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceBuildInformation.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceBuildInformation(SourceBuildInformation)}.
         * 
         * @param sourceBuildInformation
         *        a consumer that will call methods on {@link SourceBuildInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceBuildInformation(SourceBuildInformation)
         */
        default Builder sourceBuildInformation(Consumer<SourceBuildInformation.Builder> sourceBuildInformation) {
            return sourceBuildInformation(SourceBuildInformation.builder().applyMutation(sourceBuildInformation).build());
        }

        /**
         * <p>
         * Reference to the artifact from the AWS CodeBuild build.
         * </p>
         * 
         * @param buildArn
         *        Reference to the artifact from the AWS CodeBuild build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildArn(String buildArn);

        /**
         * <p>
         * The storage location of the application version's source bundle in Amazon S3.
         * </p>
         * 
         * @param sourceBundle
         *        The storage location of the application version's source bundle in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBundle(S3Location sourceBundle);

        /**
         * <p>
         * The storage location of the application version's source bundle in Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Location.Builder} avoiding the need to create
         * one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #sourceBundle(S3Location)}.
         * 
         * @param sourceBundle
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceBundle(S3Location)
         */
        default Builder sourceBundle(Consumer<S3Location.Builder> sourceBundle) {
            return sourceBundle(S3Location.builder().applyMutation(sourceBundle).build());
        }

        /**
         * <p>
         * The creation date of the application version.
         * </p>
         * 
         * @param dateCreated
         *        The creation date of the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * The last modified date of the application version.
         * </p>
         * 
         * @param dateUpdated
         *        The last modified date of the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateUpdated(Instant dateUpdated);

        /**
         * <p>
         * The processing status of the application version. Reflects the state of the application version during its
         * creation. Many of the values are only applicable if you specified <code>True</code> for the
         * <code>Process</code> parameter of the <code>CreateApplicationVersion</code> action. The following list
         * describes the possible values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Unprocessed</code> – Application version wasn't pre-processed or validated. Elastic Beanstalk will
         * validate configuration files during deployment of the application version to an environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Processing</code> – Elastic Beanstalk is currently processing the application version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Building</code> – Application version is currently undergoing an AWS CodeBuild build.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Processed</code> – Elastic Beanstalk was successfully pre-processed and validated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> – Either the AWS CodeBuild build failed or configuration files didn't pass validation.
         * This application version isn't usable.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The processing status of the application version. Reflects the state of the application version during
         *        its creation. Many of the values are only applicable if you specified <code>True</code> for the
         *        <code>Process</code> parameter of the <code>CreateApplicationVersion</code> action. The following list
         *        describes the possible values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Unprocessed</code> – Application version wasn't pre-processed or validated. Elastic Beanstalk
         *        will validate configuration files during deployment of the application version to an environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Processing</code> – Elastic Beanstalk is currently processing the application version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Building</code> – Application version is currently undergoing an AWS CodeBuild build.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Processed</code> – Elastic Beanstalk was successfully pre-processed and validated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> – Either the AWS CodeBuild build failed or configuration files didn't pass
         *        validation. This application version isn't usable.
         *        </p>
         *        </li>
         * @see ApplicationVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The processing status of the application version. Reflects the state of the application version during its
         * creation. Many of the values are only applicable if you specified <code>True</code> for the
         * <code>Process</code> parameter of the <code>CreateApplicationVersion</code> action. The following list
         * describes the possible values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Unprocessed</code> – Application version wasn't pre-processed or validated. Elastic Beanstalk will
         * validate configuration files during deployment of the application version to an environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Processing</code> – Elastic Beanstalk is currently processing the application version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Building</code> – Application version is currently undergoing an AWS CodeBuild build.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Processed</code> – Elastic Beanstalk was successfully pre-processed and validated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> – Either the AWS CodeBuild build failed or configuration files didn't pass validation.
         * This application version isn't usable.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The processing status of the application version. Reflects the state of the application version during
         *        its creation. Many of the values are only applicable if you specified <code>True</code> for the
         *        <code>Process</code> parameter of the <code>CreateApplicationVersion</code> action. The following list
         *        describes the possible values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Unprocessed</code> – Application version wasn't pre-processed or validated. Elastic Beanstalk
         *        will validate configuration files during deployment of the application version to an environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Processing</code> – Elastic Beanstalk is currently processing the application version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Building</code> – Application version is currently undergoing an AWS CodeBuild build.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Processed</code> – Elastic Beanstalk was successfully pre-processed and validated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> – Either the AWS CodeBuild build failed or configuration files didn't pass
         *        validation. This application version isn't usable.
         *        </p>
         *        </li>
         * @see ApplicationVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationVersionStatus
         */
        Builder status(ApplicationVersionStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String applicationVersionArn;

        private String applicationName;

        private String description;

        private String versionLabel;

        private SourceBuildInformation sourceBuildInformation;

        private String buildArn;

        private S3Location sourceBundle;

        private Instant dateCreated;

        private Instant dateUpdated;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationVersionDescription model) {
            applicationVersionArn(model.applicationVersionArn);
            applicationName(model.applicationName);
            description(model.description);
            versionLabel(model.versionLabel);
            sourceBuildInformation(model.sourceBuildInformation);
            buildArn(model.buildArn);
            sourceBundle(model.sourceBundle);
            dateCreated(model.dateCreated);
            dateUpdated(model.dateUpdated);
            status(model.status);
        }

        public final String getApplicationVersionArn() {
            return applicationVersionArn;
        }

        public final void setApplicationVersionArn(String applicationVersionArn) {
            this.applicationVersionArn = applicationVersionArn;
        }

        @Override
        @Transient
        public final Builder applicationVersionArn(String applicationVersionArn) {
            this.applicationVersionArn = applicationVersionArn;
            return this;
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVersionLabel() {
            return versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        @Transient
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final SourceBuildInformation.Builder getSourceBuildInformation() {
            return sourceBuildInformation != null ? sourceBuildInformation.toBuilder() : null;
        }

        public final void setSourceBuildInformation(SourceBuildInformation.BuilderImpl sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation != null ? sourceBuildInformation.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceBuildInformation(SourceBuildInformation sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation;
            return this;
        }

        public final String getBuildArn() {
            return buildArn;
        }

        public final void setBuildArn(String buildArn) {
            this.buildArn = buildArn;
        }

        @Override
        @Transient
        public final Builder buildArn(String buildArn) {
            this.buildArn = buildArn;
            return this;
        }

        public final S3Location.Builder getSourceBundle() {
            return sourceBundle != null ? sourceBundle.toBuilder() : null;
        }

        public final void setSourceBundle(S3Location.BuilderImpl sourceBundle) {
            this.sourceBundle = sourceBundle != null ? sourceBundle.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceBundle(S3Location sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        @Transient
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateUpdated() {
            return dateUpdated;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        @Override
        @Transient
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ApplicationVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ApplicationVersionDescription build() {
            return new ApplicationVersionDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
