/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<CreateEnvironmentRequest.Builder, CreateEnvironmentRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(CreateEnvironmentRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentName").getter(getter(CreateEnvironmentRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(CreateEnvironmentRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateEnvironmentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CNAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CNAMEPrefix").getter(getter(CreateEnvironmentRequest::cnamePrefix)).setter(setter(Builder::cnamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CNAMEPrefix").build()).build();

    private static final SdkField<EnvironmentTier> TIER_FIELD = SdkField.<EnvironmentTier> builder(MarshallingType.SDK_POJO)
            .memberName("Tier").getter(getter(CreateEnvironmentRequest::tier)).setter(setter(Builder::tier))
            .constructor(EnvironmentTier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateEnvironmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionLabel").getter(getter(CreateEnvironmentRequest::versionLabel))
            .setter(setter(Builder::versionLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(CreateEnvironmentRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SolutionStackName").getter(getter(CreateEnvironmentRequest::solutionStackName))
            .setter(setter(Builder::solutionStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()).build();

    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformArn").getter(getter(CreateEnvironmentRequest::platformArn)).setter(setter(Builder::platformArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()).build();

    private static final SdkField<List<ConfigurationOptionSetting>> OPTION_SETTINGS_FIELD = SdkField
            .<List<ConfigurationOptionSetting>> builder(MarshallingType.LIST)
            .memberName("OptionSettings")
            .getter(getter(CreateEnvironmentRequest::optionSettings))
            .setter(setter(Builder::optionSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationOptionSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationOptionSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OptionSpecification>> OPTIONS_TO_REMOVE_FIELD = SdkField
            .<List<OptionSpecification>> builder(MarshallingType.LIST)
            .memberName("OptionsToRemove")
            .getter(getter(CreateEnvironmentRequest::optionsToRemove))
            .setter(setter(Builder::optionsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OptionSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptionSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPERATIONS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationsRole").getter(getter(CreateEnvironmentRequest::operationsRole))
            .setter(setter(Builder::operationsRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationsRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            ENVIRONMENT_NAME_FIELD, GROUP_NAME_FIELD, DESCRIPTION_FIELD, CNAME_PREFIX_FIELD, TIER_FIELD, TAGS_FIELD,
            VERSION_LABEL_FIELD, TEMPLATE_NAME_FIELD, SOLUTION_STACK_NAME_FIELD, PLATFORM_ARN_FIELD, OPTION_SETTINGS_FIELD,
            OPTIONS_TO_REMOVE_FIELD, OPERATIONS_ROLE_FIELD));

    private final String applicationName;

    private final String environmentName;

    private final String groupName;

    private final String description;

    private final String cnamePrefix;

    private final EnvironmentTier tier;

    private final List<Tag> tags;

    private final String versionLabel;

    private final String templateName;

    private final String solutionStackName;

    private final String platformArn;

    private final List<ConfigurationOptionSetting> optionSettings;

    private final List<OptionSpecification> optionsToRemove;

    private final String operationsRole;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.environmentName = builder.environmentName;
        this.groupName = builder.groupName;
        this.description = builder.description;
        this.cnamePrefix = builder.cnamePrefix;
        this.tier = builder.tier;
        this.tags = builder.tags;
        this.versionLabel = builder.versionLabel;
        this.templateName = builder.templateName;
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.optionSettings = builder.optionSettings;
        this.optionsToRemove = builder.optionsToRemove;
        this.operationsRole = builder.operationsRole;
    }

    /**
     * <p>
     * The name of the application that is associated with this environment.
     * </p>
     * 
     * @return The name of the application that is associated with this environment.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * A unique name for the environment.
     * </p>
     * <p>
     * Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and hyphens.
     * It can't start or end with a hyphen. This name must be unique within a region in your account. If the specified
     * name already exists in the region, Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.
     * </p>
     * <p>
     * If you don't specify the <code>CNAMEPrefix</code> parameter, the environment name becomes part of the CNAME, and
     * therefore part of the visible URL for your application.
     * </p>
     * 
     * @return A unique name for the environment.</p>
     *         <p>
     *         Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and
     *         hyphens. It can't start or end with a hyphen. This name must be unique within a region in your account.
     *         If the specified name already exists in the region, Elastic Beanstalk returns an
     *         <code>InvalidParameterValue</code> error.
     *         </p>
     *         <p>
     *         If you don't specify the <code>CNAMEPrefix</code> parameter, the environment name becomes part of the
     *         CNAME, and therefore part of the visible URL for your application.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The name of the group to which the target environment belongs. Specify a group name only if the environment's
     * name is specified in an environment manifest and not with the environment name parameter. See <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest
     * (env.yaml)</a> for details.
     * </p>
     * 
     * @return The name of the group to which the target environment belongs. Specify a group name only if the
     *         environment's name is specified in an environment manifest and not with the environment name parameter.
     *         See <a
     *         href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment
     *         Manifest (env.yaml)</a> for details.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * Your description for this environment.
     * </p>
     * 
     * @return Your description for this environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * If specified, the environment attempts to use this value as the prefix for the CNAME in your Elastic Beanstalk
     * environment URL. If not specified, the CNAME is generated automatically by appending a random alphanumeric string
     * to the environment name.
     * </p>
     * 
     * @return If specified, the environment attempts to use this value as the prefix for the CNAME in your Elastic
     *         Beanstalk environment URL. If not specified, the CNAME is generated automatically by appending a random
     *         alphanumeric string to the environment name.
     */
    public final String cnamePrefix() {
        return cnamePrefix;
    }

    /**
     * <p>
     * Specifies the tier to use in creating this environment. The environment tier that you choose determines whether
     * Elastic Beanstalk provisions resources to support a web application that handles HTTP(S) requests or a web
     * application that handles background-processing tasks.
     * </p>
     * 
     * @return Specifies the tier to use in creating this environment. The environment tier that you choose determines
     *         whether Elastic Beanstalk provisions resources to support a web application that handles HTTP(S) requests
     *         or a web application that handles background-processing tasks.
     */
    public final EnvironmentTier tier() {
        return tier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the tags applied to resources in the environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies the tags applied to resources in the environment.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the application version to deploy.
     * </p>
     * <p>
     * Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.
     * </p>
     * 
     * @return The name of the application version to deploy.</p>
     *         <p>
     *         Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.
     */
    public final String versionLabel() {
        return versionLabel;
    }

    /**
     * <p>
     * The name of the Elastic Beanstalk configuration template to use with the environment.
     * </p>
     * <note>
     * <p>
     * If you specify <code>TemplateName</code>, then don't specify <code>SolutionStackName</code>.
     * </p>
     * </note>
     * 
     * @return The name of the Elastic Beanstalk configuration template to use with the environment.</p> <note>
     *         <p>
     *         If you specify <code>TemplateName</code>, then don't specify <code>SolutionStackName</code>.
     *         </p>
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If specified,
     * Elastic Beanstalk sets the configuration values to the default values associated with the specified solution
     * stack. For a list of current solution stacks, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic Beanstalk
     * Supported Platforms</a> in the <i>AWS Elastic Beanstalk Platforms</i> guide.
     * </p>
     * <note>
     * <p>
     * If you specify <code>SolutionStackName</code>, don't specify <code>PlatformArn</code> or
     * <code>TemplateName</code>.
     * </p>
     * </note>
     * 
     * @return The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If
     *         specified, Elastic Beanstalk sets the configuration values to the default values associated with the
     *         specified solution stack. For a list of current solution stacks, see <a
     *         href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic
     *         Beanstalk Supported Platforms</a> in the <i>AWS Elastic Beanstalk Platforms</i> guide.</p> <note>
     *         <p>
     *         If you specify <code>SolutionStackName</code>, don't specify <code>PlatformArn</code> or
     *         <code>TemplateName</code>.
     *         </p>
     */
    public final String solutionStackName() {
        return solutionStackName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom platform to use with the environment. For more information, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms</a> in the
     * <i>AWS Elastic Beanstalk Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * If you specify <code>PlatformArn</code>, don't specify <code>SolutionStackName</code>.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the custom platform to use with the environment. For more information,
     *         see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom
     *         Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
     *         <p>
     *         If you specify <code>PlatformArn</code>, don't specify <code>SolutionStackName</code>.
     *         </p>
     */
    public final String platformArn() {
        return platformArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionSettings() {
        return optionSettings != null && !(optionSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the
     * configuration set for the new environment. These override the values obtained from the solution stack or the
     * configuration template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionSettings} method.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in
     *         the configuration set for the new environment. These override the values obtained from the solution stack
     *         or the configuration template.
     */
    public final List<ConfigurationOptionSetting> optionSettings() {
        return optionSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionsToRemove property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionsToRemove() {
        return optionsToRemove != null && !(optionsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of custom user-defined configuration options to remove from the configuration set for this new
     * environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionsToRemove} method.
     * </p>
     * 
     * @return A list of custom user-defined configuration options to remove from the configuration set for this new
     *         environment.
     */
    public final List<OptionSpecification> optionsToRemove() {
        return optionsToRemove;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role. If
     * specified, Elastic Beanstalk uses the operations role for permissions to downstream services during this call and
     * during subsequent calls acting on this environment. To specify an operations role, you must have the
     * <code>iam:PassRole</code> permission for the role. For more information, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the
     * <i>AWS Elastic Beanstalk Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role.
     *         If specified, Elastic Beanstalk uses the operations role for permissions to downstream services during
     *         this call and during subsequent calls acting on this environment. To specify an operations role, you must
     *         have the <code>iam:PassRole</code> permission for the role. For more information, see <a
     *         href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations
     *         roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.
     */
    public final String operationsRole() {
        return operationsRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(cnamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(tier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionSettings() ? optionSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionsToRemove() ? optionsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operationsRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(environmentName(), other.environmentName()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(description(), other.description()) && Objects.equals(cnamePrefix(), other.cnamePrefix())
                && Objects.equals(tier(), other.tier()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(versionLabel(), other.versionLabel()) && Objects.equals(templateName(), other.templateName())
                && Objects.equals(solutionStackName(), other.solutionStackName())
                && Objects.equals(platformArn(), other.platformArn()) && hasOptionSettings() == other.hasOptionSettings()
                && Objects.equals(optionSettings(), other.optionSettings()) && hasOptionsToRemove() == other.hasOptionsToRemove()
                && Objects.equals(optionsToRemove(), other.optionsToRemove())
                && Objects.equals(operationsRole(), other.operationsRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentRequest").add("ApplicationName", applicationName())
                .add("EnvironmentName", environmentName()).add("GroupName", groupName()).add("Description", description())
                .add("CNAMEPrefix", cnamePrefix()).add("Tier", tier()).add("Tags", hasTags() ? tags() : null)
                .add("VersionLabel", versionLabel()).add("TemplateName", templateName())
                .add("SolutionStackName", solutionStackName()).add("PlatformArn", platformArn())
                .add("OptionSettings", hasOptionSettings() ? optionSettings() : null)
                .add("OptionsToRemove", hasOptionsToRemove() ? optionsToRemove() : null).add("OperationsRole", operationsRole())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CNAMEPrefix":
            return Optional.ofNullable(clazz.cast(cnamePrefix()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tier()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VersionLabel":
            return Optional.ofNullable(clazz.cast(versionLabel()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "SolutionStackName":
            return Optional.ofNullable(clazz.cast(solutionStackName()));
        case "PlatformArn":
            return Optional.ofNullable(clazz.cast(platformArn()));
        case "OptionSettings":
            return Optional.ofNullable(clazz.cast(optionSettings()));
        case "OptionsToRemove":
            return Optional.ofNullable(clazz.cast(optionsToRemove()));
        case "OperationsRole":
            return Optional.ofNullable(clazz.cast(operationsRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentRequest> {
        /**
         * <p>
         * The name of the application that is associated with this environment.
         * </p>
         * 
         * @param applicationName
         *        The name of the application that is associated with this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * A unique name for the environment.
         * </p>
         * <p>
         * Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and
         * hyphens. It can't start or end with a hyphen. This name must be unique within a region in your account. If
         * the specified name already exists in the region, Elastic Beanstalk returns an
         * <code>InvalidParameterValue</code> error.
         * </p>
         * <p>
         * If you don't specify the <code>CNAMEPrefix</code> parameter, the environment name becomes part of the CNAME,
         * and therefore part of the visible URL for your application.
         * </p>
         * 
         * @param environmentName
         *        A unique name for the environment.</p>
         *        <p>
         *        Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and
         *        hyphens. It can't start or end with a hyphen. This name must be unique within a region in your
         *        account. If the specified name already exists in the region, Elastic Beanstalk returns an
         *        <code>InvalidParameterValue</code> error.
         *        </p>
         *        <p>
         *        If you don't specify the <code>CNAMEPrefix</code> parameter, the environment name becomes part of the
         *        CNAME, and therefore part of the visible URL for your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The name of the group to which the target environment belongs. Specify a group name only if the environment's
         * name is specified in an environment manifest and not with the environment name parameter. See <a
         * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment
         * Manifest (env.yaml)</a> for details.
         * </p>
         * 
         * @param groupName
         *        The name of the group to which the target environment belongs. Specify a group name only if the
         *        environment's name is specified in an environment manifest and not with the environment name
         *        parameter. See <a
         *        href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html"
         *        >Environment Manifest (env.yaml)</a> for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * Your description for this environment.
         * </p>
         * 
         * @param description
         *        Your description for this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If specified, the environment attempts to use this value as the prefix for the CNAME in your Elastic
         * Beanstalk environment URL. If not specified, the CNAME is generated automatically by appending a random
         * alphanumeric string to the environment name.
         * </p>
         * 
         * @param cnamePrefix
         *        If specified, the environment attempts to use this value as the prefix for the CNAME in your Elastic
         *        Beanstalk environment URL. If not specified, the CNAME is generated automatically by appending a
         *        random alphanumeric string to the environment name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cnamePrefix(String cnamePrefix);

        /**
         * <p>
         * Specifies the tier to use in creating this environment. The environment tier that you choose determines
         * whether Elastic Beanstalk provisions resources to support a web application that handles HTTP(S) requests or
         * a web application that handles background-processing tasks.
         * </p>
         * 
         * @param tier
         *        Specifies the tier to use in creating this environment. The environment tier that you choose
         *        determines whether Elastic Beanstalk provisions resources to support a web application that handles
         *        HTTP(S) requests or a web application that handles background-processing tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tier(EnvironmentTier tier);

        /**
         * <p>
         * Specifies the tier to use in creating this environment. The environment tier that you choose determines
         * whether Elastic Beanstalk provisions resources to support a web application that handles HTTP(S) requests or
         * a web application that handles background-processing tasks.
         * </p>
         * This is a convenience that creates an instance of the {@link EnvironmentTier.Builder} avoiding the need to
         * create one manually via {@link EnvironmentTier#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnvironmentTier.Builder#build()} is called immediately and its
         * result is passed to {@link #tier(EnvironmentTier)}.
         * 
         * @param tier
         *        a consumer that will call methods on {@link EnvironmentTier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tier(EnvironmentTier)
         */
        default Builder tier(Consumer<EnvironmentTier.Builder> tier) {
            return tier(EnvironmentTier.builder().applyMutation(tier).build());
        }

        /**
         * <p>
         * Specifies the tags applied to resources in the environment.
         * </p>
         * 
         * @param tags
         *        Specifies the tags applied to resources in the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Specifies the tags applied to resources in the environment.
         * </p>
         * 
         * @param tags
         *        Specifies the tags applied to resources in the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Specifies the tags applied to resources in the environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The name of the application version to deploy.
         * </p>
         * <p>
         * Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.
         * </p>
         * 
         * @param versionLabel
         *        The name of the application version to deploy.</p>
         *        <p>
         *        Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionLabel(String versionLabel);

        /**
         * <p>
         * The name of the Elastic Beanstalk configuration template to use with the environment.
         * </p>
         * <note>
         * <p>
         * If you specify <code>TemplateName</code>, then don't specify <code>SolutionStackName</code>.
         * </p>
         * </note>
         * 
         * @param templateName
         *        The name of the Elastic Beanstalk configuration template to use with the environment.</p> <note>
         *        <p>
         *        If you specify <code>TemplateName</code>, then don't specify <code>SolutionStackName</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If specified,
         * Elastic Beanstalk sets the configuration values to the default values associated with the specified solution
         * stack. For a list of current solution stacks, see <a
         * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic
         * Beanstalk Supported Platforms</a> in the <i>AWS Elastic Beanstalk Platforms</i> guide.
         * </p>
         * <note>
         * <p>
         * If you specify <code>SolutionStackName</code>, don't specify <code>PlatformArn</code> or
         * <code>TemplateName</code>.
         * </p>
         * </note>
         * 
         * @param solutionStackName
         *        The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If
         *        specified, Elastic Beanstalk sets the configuration values to the default values associated with the
         *        specified solution stack. For a list of current solution stacks, see <a
         *        href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic
         *        Beanstalk Supported Platforms</a> in the <i>AWS Elastic Beanstalk Platforms</i> guide.</p> <note>
         *        <p>
         *        If you specify <code>SolutionStackName</code>, don't specify <code>PlatformArn</code> or
         *        <code>TemplateName</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionStackName(String solutionStackName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom platform to use with the environment. For more information, see
         * <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms</a>
         * in the <i>AWS Elastic Beanstalk Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * If you specify <code>PlatformArn</code>, don't specify <code>SolutionStackName</code>.
         * </p>
         * </note>
         * 
         * @param platformArn
         *        The Amazon Resource Name (ARN) of the custom platform to use with the environment. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom
         *        Platforms</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.</p> <note>
         *        <p>
         *        If you specify <code>PlatformArn</code>, don't specify <code>SolutionStackName</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformArn(String platformArn);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the
         * configuration set for the new environment. These override the values obtained from the solution stack or the
         * configuration template.
         * </p>
         * 
         * @param optionSettings
         *        If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in
         *        the configuration set for the new environment. These override the values obtained from the solution
         *        stack or the configuration template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the
         * configuration set for the new environment. These override the values obtained from the solution stack or the
         * configuration template.
         * </p>
         * 
         * @param optionSettings
         *        If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in
         *        the configuration set for the new environment. These override the values obtained from the solution
         *        stack or the configuration template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(ConfigurationOptionSetting... optionSettings);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the
         * configuration set for the new environment. These override the values obtained from the solution stack or the
         * configuration template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationOptionSetting>.Builder}
         * avoiding the need to create one manually via {@link List<ConfigurationOptionSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationOptionSetting>.Builder#build()} is called
         * immediately and its result is passed to {@link #optionSettings(List<ConfigurationOptionSetting>)}.
         * 
         * @param optionSettings
         *        a consumer that will call methods on {@link List<ConfigurationOptionSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionSettings(List<ConfigurationOptionSetting>)
         */
        Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder>... optionSettings);

        /**
         * <p>
         * A list of custom user-defined configuration options to remove from the configuration set for this new
         * environment.
         * </p>
         * 
         * @param optionsToRemove
         *        A list of custom user-defined configuration options to remove from the configuration set for this new
         *        environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsToRemove(Collection<OptionSpecification> optionsToRemove);

        /**
         * <p>
         * A list of custom user-defined configuration options to remove from the configuration set for this new
         * environment.
         * </p>
         * 
         * @param optionsToRemove
         *        A list of custom user-defined configuration options to remove from the configuration set for this new
         *        environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsToRemove(OptionSpecification... optionsToRemove);

        /**
         * <p>
         * A list of custom user-defined configuration options to remove from the configuration set for this new
         * environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OptionSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<OptionSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OptionSpecification>.Builder#build()} is called immediately
         * and its result is passed to {@link #optionsToRemove(List<OptionSpecification>)}.
         * 
         * @param optionsToRemove
         *        a consumer that will call methods on {@link List<OptionSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionsToRemove(List<OptionSpecification>)
         */
        Builder optionsToRemove(Consumer<OptionSpecification.Builder>... optionsToRemove);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role. If
         * specified, Elastic Beanstalk uses the operations role for permissions to downstream services during this call
         * and during subsequent calls acting on this environment. To specify an operations role, you must have the
         * <code>iam:PassRole</code> permission for the role. For more information, see <a
         * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in
         * the <i>AWS Elastic Beanstalk Developer Guide</i>.
         * </p>
         * 
         * @param operationsRole
         *        The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations
         *        role. If specified, Elastic Beanstalk uses the operations role for permissions to downstream services
         *        during this call and during subsequent calls acting on this environment. To specify an operations
         *        role, you must have the <code>iam:PassRole</code> permission for the role. For more information, see
         *        <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations
         *        roles</a> in the <i>AWS Elastic Beanstalk Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationsRole(String operationsRole);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String environmentName;

        private String groupName;

        private String description;

        private String cnamePrefix;

        private EnvironmentTier tier;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String versionLabel;

        private String templateName;

        private String solutionStackName;

        private String platformArn;

        private List<ConfigurationOptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();

        private List<OptionSpecification> optionsToRemove = DefaultSdkAutoConstructList.getInstance();

        private String operationsRole;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            applicationName(model.applicationName);
            environmentName(model.environmentName);
            groupName(model.groupName);
            description(model.description);
            cnamePrefix(model.cnamePrefix);
            tier(model.tier);
            tags(model.tags);
            versionLabel(model.versionLabel);
            templateName(model.templateName);
            solutionStackName(model.solutionStackName);
            platformArn(model.platformArn);
            optionSettings(model.optionSettings);
            optionsToRemove(model.optionsToRemove);
            operationsRole(model.operationsRole);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        @Transient
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        @Transient
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCnamePrefix() {
            return cnamePrefix;
        }

        public final void setCnamePrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
        }

        @Override
        @Transient
        public final Builder cnamePrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
            return this;
        }

        public final EnvironmentTier.Builder getTier() {
            return tier != null ? tier.toBuilder() : null;
        }

        public final void setTier(EnvironmentTier.BuilderImpl tier) {
            this.tier = tier != null ? tier.build() : null;
        }

        @Override
        @Transient
        public final Builder tier(EnvironmentTier tier) {
            this.tier = tier;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVersionLabel() {
            return versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        @Transient
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        @Transient
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getSolutionStackName() {
            return solutionStackName;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        @Override
        @Transient
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final String getPlatformArn() {
            return platformArn;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        @Override
        @Transient
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final List<ConfigurationOptionSetting.Builder> getOptionSettings() {
            List<ConfigurationOptionSetting.Builder> result = ConfigurationOptionSettingsListCopier
                    .copyToBuilder(this.optionSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copyFromBuilder(optionSettings);
        }

        @Override
        @Transient
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting... optionSettings) {
            optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder>... optionSettings) {
            optionSettings(Stream.of(optionSettings).map(c -> ConfigurationOptionSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OptionSpecification.Builder> getOptionsToRemove() {
            List<OptionSpecification.Builder> result = OptionsSpecifierListCopier.copyToBuilder(this.optionsToRemove);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionsToRemove(Collection<OptionSpecification.BuilderImpl> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copyFromBuilder(optionsToRemove);
        }

        @Override
        @Transient
        public final Builder optionsToRemove(Collection<OptionSpecification> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copy(optionsToRemove);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder optionsToRemove(OptionSpecification... optionsToRemove) {
            optionsToRemove(Arrays.asList(optionsToRemove));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder optionsToRemove(Consumer<OptionSpecification.Builder>... optionsToRemove) {
            optionsToRemove(Stream.of(optionsToRemove).map(c -> OptionSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOperationsRole() {
            return operationsRole;
        }

        public final void setOperationsRole(String operationsRole) {
            this.operationsRole = operationsRole;
        }

        @Override
        @Transient
        public final Builder operationsRole(String operationsRole) {
            this.operationsRole = operationsRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
