/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information retrieved from the Amazon EC2 instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentInfoDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentInfoDescription.Builder, EnvironmentInfoDescription> {
    private static final SdkField<String> INFO_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InfoType").getter(getter(EnvironmentInfoDescription::infoTypeAsString))
            .setter(setter(Builder::infoType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfoType").build()).build();

    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2InstanceId").getter(getter(EnvironmentInfoDescription::ec2InstanceId))
            .setter(setter(Builder::ec2InstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()).build();

    private static final SdkField<Instant> SAMPLE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SampleTimestamp").getter(getter(EnvironmentInfoDescription::sampleTimestamp))
            .setter(setter(Builder::sampleTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTimestamp").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(EnvironmentInfoDescription::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFO_TYPE_FIELD,
            EC2_INSTANCE_ID_FIELD, SAMPLE_TIMESTAMP_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String infoType;

    private final String ec2InstanceId;

    private final Instant sampleTimestamp;

    private final String message;

    private EnvironmentInfoDescription(BuilderImpl builder) {
        this.infoType = builder.infoType;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.sampleTimestamp = builder.sampleTimestamp;
        this.message = builder.message;
    }

    /**
     * <p>
     * The type of information retrieved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #infoType} will
     * return {@link EnvironmentInfoType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #infoTypeAsString}.
     * </p>
     * 
     * @return The type of information retrieved.
     * @see EnvironmentInfoType
     */
    public final EnvironmentInfoType infoType() {
        return EnvironmentInfoType.fromValue(infoType);
    }

    /**
     * <p>
     * The type of information retrieved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #infoType} will
     * return {@link EnvironmentInfoType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #infoTypeAsString}.
     * </p>
     * 
     * @return The type of information retrieved.
     * @see EnvironmentInfoType
     */
    public final String infoTypeAsString() {
        return infoType;
    }

    /**
     * <p>
     * The Amazon EC2 Instance ID for this information.
     * </p>
     * 
     * @return The Amazon EC2 Instance ID for this information.
     */
    public final String ec2InstanceId() {
        return ec2InstanceId;
    }

    /**
     * <p>
     * The time stamp when this information was retrieved.
     * </p>
     * 
     * @return The time stamp when this information was retrieved.
     */
    public final Instant sampleTimestamp() {
        return sampleTimestamp;
    }

    /**
     * <p>
     * The retrieved information. Currently contains a presigned Amazon S3 URL. The files are deleted after 15 minutes.
     * </p>
     * <p>
     * Anyone in possession of this URL can access the files before they are deleted. Make the URL available only to
     * trusted parties.
     * </p>
     * 
     * @return The retrieved information. Currently contains a presigned Amazon S3 URL. The files are deleted after 15
     *         minutes.</p>
     *         <p>
     *         Anyone in possession of this URL can access the files before they are deleted. Make the URL available
     *         only to trusted parties.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(infoTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(sampleTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentInfoDescription)) {
            return false;
        }
        EnvironmentInfoDescription other = (EnvironmentInfoDescription) obj;
        return Objects.equals(infoTypeAsString(), other.infoTypeAsString())
                && Objects.equals(ec2InstanceId(), other.ec2InstanceId())
                && Objects.equals(sampleTimestamp(), other.sampleTimestamp()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentInfoDescription").add("InfoType", infoTypeAsString())
                .add("Ec2InstanceId", ec2InstanceId()).add("SampleTimestamp", sampleTimestamp()).add("Message", message())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InfoType":
            return Optional.ofNullable(clazz.cast(infoTypeAsString()));
        case "Ec2InstanceId":
            return Optional.ofNullable(clazz.cast(ec2InstanceId()));
        case "SampleTimestamp":
            return Optional.ofNullable(clazz.cast(sampleTimestamp()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentInfoDescription, T> g) {
        return obj -> g.apply((EnvironmentInfoDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentInfoDescription> {
        /**
         * <p>
         * The type of information retrieved.
         * </p>
         * 
         * @param infoType
         *        The type of information retrieved.
         * @see EnvironmentInfoType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentInfoType
         */
        Builder infoType(String infoType);

        /**
         * <p>
         * The type of information retrieved.
         * </p>
         * 
         * @param infoType
         *        The type of information retrieved.
         * @see EnvironmentInfoType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentInfoType
         */
        Builder infoType(EnvironmentInfoType infoType);

        /**
         * <p>
         * The Amazon EC2 Instance ID for this information.
         * </p>
         * 
         * @param ec2InstanceId
         *        The Amazon EC2 Instance ID for this information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceId(String ec2InstanceId);

        /**
         * <p>
         * The time stamp when this information was retrieved.
         * </p>
         * 
         * @param sampleTimestamp
         *        The time stamp when this information was retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleTimestamp(Instant sampleTimestamp);

        /**
         * <p>
         * The retrieved information. Currently contains a presigned Amazon S3 URL. The files are deleted after 15
         * minutes.
         * </p>
         * <p>
         * Anyone in possession of this URL can access the files before they are deleted. Make the URL available only to
         * trusted parties.
         * </p>
         * 
         * @param message
         *        The retrieved information. Currently contains a presigned Amazon S3 URL. The files are deleted after
         *        15 minutes.</p>
         *        <p>
         *        Anyone in possession of this URL can access the files before they are deleted. Make the URL available
         *        only to trusted parties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String infoType;

        private String ec2InstanceId;

        private Instant sampleTimestamp;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentInfoDescription model) {
            infoType(model.infoType);
            ec2InstanceId(model.ec2InstanceId);
            sampleTimestamp(model.sampleTimestamp);
            message(model.message);
        }

        public final String getInfoType() {
            return infoType;
        }

        public final void setInfoType(String infoType) {
            this.infoType = infoType;
        }

        @Override
        @Transient
        public final Builder infoType(String infoType) {
            this.infoType = infoType;
            return this;
        }

        @Override
        @Transient
        public final Builder infoType(EnvironmentInfoType infoType) {
            this.infoType(infoType == null ? null : infoType.toString());
            return this;
        }

        public final String getEc2InstanceId() {
            return ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        @Transient
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final Instant getSampleTimestamp() {
            return sampleTimestamp;
        }

        public final void setSampleTimestamp(Instant sampleTimestamp) {
            this.sampleTimestamp = sampleTimestamp;
        }

        @Override
        @Transient
        public final Builder sampleTimestamp(Instant sampleTimestamp) {
            this.sampleTimestamp = sampleTimestamp;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public EnvironmentInfoDescription build() {
            return new EnvironmentInfoDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
