/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result message containing a single description of an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<UpdateApplicationResponse.Builder, UpdateApplicationResponse> {
    private static final SdkField<ApplicationDescription> APPLICATION_FIELD = SdkField
            .<ApplicationDescription> builder(MarshallingType.SDK_POJO).memberName("Application")
            .getter(getter(UpdateApplicationResponse::application)).setter(setter(Builder::application))
            .constructor(ApplicationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Application").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD));

    private final ApplicationDescription application;

    private UpdateApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
    }

    /**
     * <p>
     * The <a>ApplicationDescription</a> of the application.
     * </p>
     * 
     * @return The <a>ApplicationDescription</a> of the application.
     */
    public final ApplicationDescription application() {
        return application;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(application());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationResponse)) {
            return false;
        }
        UpdateApplicationResponse other = (UpdateApplicationResponse) obj;
        return Objects.equals(application(), other.application());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationResponse").add("Application", application()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Application":
            return Optional.ofNullable(clazz.cast(application()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationResponse, T> g) {
        return obj -> g.apply((UpdateApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApplicationResponse> {
        /**
         * <p>
         * The <a>ApplicationDescription</a> of the application.
         * </p>
         * 
         * @param application
         *        The <a>ApplicationDescription</a> of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(ApplicationDescription application);

        /**
         * <p>
         * The <a>ApplicationDescription</a> of the application.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationDescription.Builder} avoiding the
         * need to create one manually via {@link ApplicationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #application(ApplicationDescription)}.
         * 
         * @param application
         *        a consumer that will call methods on {@link ApplicationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #application(ApplicationDescription)
         */
        default Builder application(Consumer<ApplicationDescription.Builder> application) {
            return application(ApplicationDescription.builder().applyMutation(application).build());
        }
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private ApplicationDescription application;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationResponse model) {
            super(model);
            application(model.application);
        }

        public final ApplicationDescription.Builder getApplication() {
            return application != null ? application.toBuilder() : null;
        }

        public final void setApplication(ApplicationDescription.BuilderImpl application) {
            this.application = application != null ? application.build() : null;
        }

        @Override
        @Transient
        public final Builder application(ApplicationDescription application) {
            this.application = application;
            return this;
        }

        @Override
        public UpdateApplicationResponse build() {
            return new UpdateApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
