/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationMetrics;
import software.amazon.awssdk.services.elasticbeanstalk.model.CausesCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.Deployment;
import software.amazon.awssdk.services.elasticbeanstalk.model.SystemStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SingleInstanceHealth
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SingleInstanceHealth> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(SingleInstanceHealth.getter(SingleInstanceHealth::instanceId)).setter(SingleInstanceHealth.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthStatus").getter(SingleInstanceHealth.getter(SingleInstanceHealth::healthStatus)).setter(SingleInstanceHealth.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()}).build();
    private static final SdkField<String> COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Color").getter(SingleInstanceHealth.getter(SingleInstanceHealth::color)).setter(SingleInstanceHealth.setter(Builder::color)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()}).build();
    private static final SdkField<List<String>> CAUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Causes").getter(SingleInstanceHealth.getter(SingleInstanceHealth::causes)).setter(SingleInstanceHealth.setter(Builder::causes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Causes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAUNCHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LaunchedAt").getter(SingleInstanceHealth.getter(SingleInstanceHealth::launchedAt)).setter(SingleInstanceHealth.setter(Builder::launchedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchedAt").build()}).build();
    private static final SdkField<ApplicationMetrics> APPLICATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationMetrics").getter(SingleInstanceHealth.getter(SingleInstanceHealth::applicationMetrics)).setter(SingleInstanceHealth.setter(Builder::applicationMetrics)).constructor(ApplicationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationMetrics").build()}).build();
    private static final SdkField<SystemStatus> SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("System").getter(SingleInstanceHealth.getter(SingleInstanceHealth::system)).setter(SingleInstanceHealth.setter(Builder::system)).constructor(SystemStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("System").build()}).build();
    private static final SdkField<Deployment> DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Deployment").getter(SingleInstanceHealth.getter(SingleInstanceHealth::deployment)).setter(SingleInstanceHealth.setter(Builder::deployment)).constructor(Deployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deployment").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(SingleInstanceHealth.getter(SingleInstanceHealth::availabilityZone)).setter(SingleInstanceHealth.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(SingleInstanceHealth.getter(SingleInstanceHealth::instanceType)).setter(SingleInstanceHealth.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, HEALTH_STATUS_FIELD, COLOR_FIELD, CAUSES_FIELD, LAUNCHED_AT_FIELD, APPLICATION_METRICS_FIELD, SYSTEM_FIELD, DEPLOYMENT_FIELD, AVAILABILITY_ZONE_FIELD, INSTANCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String healthStatus;
    private final String color;
    private final List<String> causes;
    private final Instant launchedAt;
    private final ApplicationMetrics applicationMetrics;
    private final SystemStatus system;
    private final Deployment deployment;
    private final String availabilityZone;
    private final String instanceType;

    private SingleInstanceHealth(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.healthStatus = builder.healthStatus;
        this.color = builder.color;
        this.causes = builder.causes;
        this.launchedAt = builder.launchedAt;
        this.applicationMetrics = builder.applicationMetrics;
        this.system = builder.system;
        this.deployment = builder.deployment;
        this.availabilityZone = builder.availabilityZone;
        this.instanceType = builder.instanceType;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String healthStatus() {
        return this.healthStatus;
    }

    public final String color() {
        return this.color;
    }

    public final boolean hasCauses() {
        return this.causes != null && !(this.causes instanceof SdkAutoConstructList);
    }

    public final List<String> causes() {
        return this.causes;
    }

    public final Instant launchedAt() {
        return this.launchedAt;
    }

    public final ApplicationMetrics applicationMetrics() {
        return this.applicationMetrics;
    }

    public final SystemStatus system() {
        return this.system;
    }

    public final Deployment deployment() {
        return this.deployment;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.color());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCauses() ? this.causes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launchedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.system());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleInstanceHealth)) {
            return false;
        }
        SingleInstanceHealth other = (SingleInstanceHealth)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.healthStatus(), other.healthStatus()) && Objects.equals(this.color(), other.color()) && this.hasCauses() == other.hasCauses() && Objects.equals(this.causes(), other.causes()) && Objects.equals(this.launchedAt(), other.launchedAt()) && Objects.equals(this.applicationMetrics(), other.applicationMetrics()) && Objects.equals(this.system(), other.system()) && Objects.equals(this.deployment(), other.deployment()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.instanceType(), other.instanceType());
    }

    public final String toString() {
        return ToString.builder((String)"SingleInstanceHealth").add("InstanceId", (Object)this.instanceId()).add("HealthStatus", (Object)this.healthStatus()).add("Color", (Object)this.color()).add("Causes", this.hasCauses() ? this.causes() : null).add("LaunchedAt", (Object)this.launchedAt()).add("ApplicationMetrics", (Object)this.applicationMetrics()).add("System", (Object)this.system()).add("Deployment", (Object)this.deployment()).add("AvailabilityZone", (Object)this.availabilityZone()).add("InstanceType", (Object)this.instanceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "HealthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatus()));
            }
            case "Color": {
                return Optional.ofNullable(clazz.cast(this.color()));
            }
            case "Causes": {
                return Optional.ofNullable(clazz.cast(this.causes()));
            }
            case "LaunchedAt": {
                return Optional.ofNullable(clazz.cast(this.launchedAt()));
            }
            case "ApplicationMetrics": {
                return Optional.ofNullable(clazz.cast(this.applicationMetrics()));
            }
            case "System": {
                return Optional.ofNullable(clazz.cast(this.system()));
            }
            case "Deployment": {
                return Optional.ofNullable(clazz.cast(this.deployment()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SingleInstanceHealth, T> g) {
        return obj -> g.apply((SingleInstanceHealth)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String healthStatus;
        private String color;
        private List<String> causes = DefaultSdkAutoConstructList.getInstance();
        private Instant launchedAt;
        private ApplicationMetrics applicationMetrics;
        private SystemStatus system;
        private Deployment deployment;
        private String availabilityZone;
        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(SingleInstanceHealth model) {
            this.instanceId(model.instanceId);
            this.healthStatus(model.healthStatus);
            this.color(model.color);
            this.causes(model.causes);
            this.launchedAt(model.launchedAt);
            this.applicationMetrics(model.applicationMetrics);
            this.system(model.system);
            this.deployment(model.deployment);
            this.availabilityZone(model.availabilityZone);
            this.instanceType(model.instanceType);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        @Transient
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final String getColor() {
            return this.color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        @Transient
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final Collection<String> getCauses() {
            if (this.causes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.causes;
        }

        public final void setCauses(Collection<String> causes) {
            this.causes = CausesCopier.copy(causes);
        }

        @Override
        @Transient
        public final Builder causes(Collection<String> causes) {
            this.causes = CausesCopier.copy(causes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder causes(String ... causes) {
            this.causes(Arrays.asList(causes));
            return this;
        }

        public final Instant getLaunchedAt() {
            return this.launchedAt;
        }

        public final void setLaunchedAt(Instant launchedAt) {
            this.launchedAt = launchedAt;
        }

        @Override
        @Transient
        public final Builder launchedAt(Instant launchedAt) {
            this.launchedAt = launchedAt;
            return this;
        }

        public final ApplicationMetrics.Builder getApplicationMetrics() {
            return this.applicationMetrics != null ? this.applicationMetrics.toBuilder() : null;
        }

        public final void setApplicationMetrics(ApplicationMetrics.BuilderImpl applicationMetrics) {
            this.applicationMetrics = applicationMetrics != null ? applicationMetrics.build() : null;
        }

        @Override
        @Transient
        public final Builder applicationMetrics(ApplicationMetrics applicationMetrics) {
            this.applicationMetrics = applicationMetrics;
            return this;
        }

        public final SystemStatus.Builder getSystem() {
            return this.system != null ? this.system.toBuilder() : null;
        }

        public final void setSystem(SystemStatus.BuilderImpl system) {
            this.system = system != null ? system.build() : null;
        }

        @Override
        @Transient
        public final Builder system(SystemStatus system) {
            this.system = system;
            return this;
        }

        public final Deployment.Builder getDeployment() {
            return this.deployment != null ? this.deployment.toBuilder() : null;
        }

        public final void setDeployment(Deployment.BuilderImpl deployment) {
            this.deployment = deployment != null ? deployment.build() : null;
        }

        @Override
        @Transient
        public final Builder deployment(Deployment deployment) {
            this.deployment = deployment;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public SingleInstanceHealth build() {
            return new SingleInstanceHealth(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SingleInstanceHealth> {
        public Builder instanceId(String var1);

        public Builder healthStatus(String var1);

        public Builder color(String var1);

        public Builder causes(Collection<String> var1);

        public Builder causes(String ... var1);

        public Builder launchedAt(Instant var1);

        public Builder applicationMetrics(ApplicationMetrics var1);

        default public Builder applicationMetrics(Consumer<ApplicationMetrics.Builder> applicationMetrics) {
            return this.applicationMetrics((ApplicationMetrics)((ApplicationMetrics.Builder)ApplicationMetrics.builder().applyMutation(applicationMetrics)).build());
        }

        public Builder system(SystemStatus var1);

        default public Builder system(Consumer<SystemStatus.Builder> system) {
            return this.system((SystemStatus)((SystemStatus.Builder)SystemStatus.builder().applyMutation(system)).build());
        }

        public Builder deployment(Deployment var1);

        default public Builder deployment(Consumer<Deployment.Builder> deployment) {
            return this.deployment((Deployment)((Deployment.Builder)Deployment.builder().applyMutation(deployment)).build());
        }

        public Builder availabilityZone(String var1);

        public Builder instanceType(String var1);
    }
}

