/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AvailableSolutionStackDetailsListCopier {
    static List<SolutionStackDescription> copy(
            Collection<? extends SolutionStackDescription> availableSolutionStackDetailsListParam) {
        List<SolutionStackDescription> list;
        if (availableSolutionStackDetailsListParam == null
                || availableSolutionStackDetailsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SolutionStackDescription> modifiableList = new ArrayList<>();
            availableSolutionStackDetailsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SolutionStackDescription> copyFromBuilder(
            Collection<? extends SolutionStackDescription.Builder> availableSolutionStackDetailsListParam) {
        List<SolutionStackDescription> list;
        if (availableSolutionStackDetailsListParam == null
                || availableSolutionStackDetailsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SolutionStackDescription> modifiableList = new ArrayList<>();
            availableSolutionStackDetailsListParam.forEach(entry -> {
                SolutionStackDescription member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SolutionStackDescription.Builder> copyToBuilder(
            Collection<? extends SolutionStackDescription> availableSolutionStackDetailsListParam) {
        List<SolutionStackDescription.Builder> list;
        if (availableSolutionStackDetailsListParam == null
                || availableSolutionStackDetailsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SolutionStackDescription.Builder> modifiableList = new ArrayList<>();
            availableSolutionStackDetailsListParam.forEach(entry -> {
                SolutionStackDescription.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
