/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to delete an application version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteApplicationVersionRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<DeleteApplicationVersionRequest.Builder, DeleteApplicationVersionRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(DeleteApplicationVersionRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionLabel").getter(getter(DeleteApplicationVersionRequest::versionLabel))
            .setter(setter(Builder::versionLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()).build();

    private static final SdkField<Boolean> DELETE_SOURCE_BUNDLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteSourceBundle").getter(getter(DeleteApplicationVersionRequest::deleteSourceBundle))
            .setter(setter(Builder::deleteSourceBundle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteSourceBundle").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            VERSION_LABEL_FIELD, DELETE_SOURCE_BUNDLE_FIELD));

    private final String applicationName;

    private final String versionLabel;

    private final Boolean deleteSourceBundle;

    private DeleteApplicationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.deleteSourceBundle = builder.deleteSourceBundle;
    }

    /**
     * <p>
     * The name of the application to which the version belongs.
     * </p>
     * 
     * @return The name of the application to which the version belongs.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The label of the version to delete.
     * </p>
     * 
     * @return The label of the version to delete.
     */
    public final String versionLabel() {
        return versionLabel;
    }

    /**
     * <p>
     * Set to <code>true</code> to delete the source bundle from your storage bucket. Otherwise, the application version
     * is deleted only from Elastic Beanstalk and the source bundle remains in Amazon S3.
     * </p>
     * 
     * @return Set to <code>true</code> to delete the source bundle from your storage bucket. Otherwise, the application
     *         version is deleted only from Elastic Beanstalk and the source bundle remains in Amazon S3.
     */
    public final Boolean deleteSourceBundle() {
        return deleteSourceBundle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(deleteSourceBundle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationVersionRequest)) {
            return false;
        }
        DeleteApplicationVersionRequest other = (DeleteApplicationVersionRequest) obj;
        return Objects.equals(applicationName(), other.applicationName()) && Objects.equals(versionLabel(), other.versionLabel())
                && Objects.equals(deleteSourceBundle(), other.deleteSourceBundle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteApplicationVersionRequest").add("ApplicationName", applicationName())
                .add("VersionLabel", versionLabel()).add("DeleteSourceBundle", deleteSourceBundle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "VersionLabel":
            return Optional.ofNullable(clazz.cast(versionLabel()));
        case "DeleteSourceBundle":
            return Optional.ofNullable(clazz.cast(deleteSourceBundle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationVersionRequest, T> g) {
        return obj -> g.apply((DeleteApplicationVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteApplicationVersionRequest> {
        /**
         * <p>
         * The name of the application to which the version belongs.
         * </p>
         * 
         * @param applicationName
         *        The name of the application to which the version belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The label of the version to delete.
         * </p>
         * 
         * @param versionLabel
         *        The label of the version to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionLabel(String versionLabel);

        /**
         * <p>
         * Set to <code>true</code> to delete the source bundle from your storage bucket. Otherwise, the application
         * version is deleted only from Elastic Beanstalk and the source bundle remains in Amazon S3.
         * </p>
         * 
         * @param deleteSourceBundle
         *        Set to <code>true</code> to delete the source bundle from your storage bucket. Otherwise, the
         *        application version is deleted only from Elastic Beanstalk and the source bundle remains in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteSourceBundle(Boolean deleteSourceBundle);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String versionLabel;

        private Boolean deleteSourceBundle;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationVersionRequest model) {
            super(model);
            applicationName(model.applicationName);
            versionLabel(model.versionLabel);
            deleteSourceBundle(model.deleteSourceBundle);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getVersionLabel() {
            return versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        @Transient
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final Boolean getDeleteSourceBundle() {
            return deleteSourceBundle;
        }

        public final void setDeleteSourceBundle(Boolean deleteSourceBundle) {
            this.deleteSourceBundle = deleteSourceBundle;
        }

        @Override
        @Transient
        public final Builder deleteSourceBundle(Boolean deleteSourceBundle) {
            this.deleteSourceBundle = deleteSourceBundle;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationVersionRequest build() {
            return new DeleteApplicationVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
