/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result message containing a list of environment descriptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEnvironmentsResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<DescribeEnvironmentsResponse.Builder, DescribeEnvironmentsResponse> {
    private static final SdkField<List<EnvironmentDescription>> ENVIRONMENTS_FIELD = SdkField
            .<List<EnvironmentDescription>> builder(MarshallingType.LIST)
            .memberName("Environments")
            .getter(getter(DescribeEnvironmentsResponse::environments))
            .setter(setter(Builder::environments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeEnvironmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EnvironmentDescription> environments;

    private final String nextToken;

    private DescribeEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.environments = builder.environments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironments() {
        return environments != null && !(environments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns an <a>EnvironmentDescription</a> list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironments} method.
     * </p>
     * 
     * @return Returns an <a>EnvironmentDescription</a> list.
     */
    public final List<EnvironmentDescription> environments() {
        return environments;
    }

    /**
     * <p>
     * In a paginated request, the token that you can pass in a subsequent request to get the next response page.
     * </p>
     * 
     * @return In a paginated request, the token that you can pass in a subsequent request to get the next response
     *         page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironments() ? environments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsResponse)) {
            return false;
        }
        DescribeEnvironmentsResponse other = (DescribeEnvironmentsResponse) obj;
        return hasEnvironments() == other.hasEnvironments() && Objects.equals(environments(), other.environments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEnvironmentsResponse").add("Environments", hasEnvironments() ? environments() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Environments":
            return Optional.ofNullable(clazz.cast(environments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentsResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEnvironmentsResponse> {
        /**
         * <p>
         * Returns an <a>EnvironmentDescription</a> list.
         * </p>
         * 
         * @param environments
         *        Returns an <a>EnvironmentDescription</a> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environments(Collection<EnvironmentDescription> environments);

        /**
         * <p>
         * Returns an <a>EnvironmentDescription</a> list.
         * </p>
         * 
         * @param environments
         *        Returns an <a>EnvironmentDescription</a> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environments(EnvironmentDescription... environments);

        /**
         * <p>
         * Returns an <a>EnvironmentDescription</a> list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EnvironmentDescription>.Builder} avoiding
         * the need to create one manually via {@link List<EnvironmentDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnvironmentDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #environments(List<EnvironmentDescription>)}.
         * 
         * @param environments
         *        a consumer that will call methods on {@link List<EnvironmentDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environments(List<EnvironmentDescription>)
         */
        Builder environments(Consumer<EnvironmentDescription.Builder>... environments);

        /**
         * <p>
         * In a paginated request, the token that you can pass in a subsequent request to get the next response page.
         * </p>
         * 
         * @param nextToken
         *        In a paginated request, the token that you can pass in a subsequent request to get the next response
         *        page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<EnvironmentDescription> environments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentsResponse model) {
            super(model);
            environments(model.environments);
            nextToken(model.nextToken);
        }

        public final List<EnvironmentDescription.Builder> getEnvironments() {
            List<EnvironmentDescription.Builder> result = EnvironmentDescriptionsListCopier.copyToBuilder(this.environments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironments(Collection<EnvironmentDescription.BuilderImpl> environments) {
            this.environments = EnvironmentDescriptionsListCopier.copyFromBuilder(environments);
        }

        @Override
        @Transient
        public final Builder environments(Collection<EnvironmentDescription> environments) {
            this.environments = EnvironmentDescriptionsListCopier.copy(environments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environments(EnvironmentDescription... environments) {
            environments(Arrays.asList(environments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environments(Consumer<EnvironmentDescription.Builder>... environments) {
            environments(Stream.of(environments).map(c -> EnvironmentDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeEnvironmentsResponse build() {
            return new DescribeEnvironmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
