/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result message containing the options for the specified solution stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigurationTemplateRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<UpdateConfigurationTemplateRequest.Builder, UpdateConfigurationTemplateRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(UpdateConfigurationTemplateRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(UpdateConfigurationTemplateRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateConfigurationTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<ConfigurationOptionSetting>> OPTION_SETTINGS_FIELD = SdkField
            .<List<ConfigurationOptionSetting>> builder(MarshallingType.LIST)
            .memberName("OptionSettings")
            .getter(getter(UpdateConfigurationTemplateRequest::optionSettings))
            .setter(setter(Builder::optionSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationOptionSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationOptionSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OptionSpecification>> OPTIONS_TO_REMOVE_FIELD = SdkField
            .<List<OptionSpecification>> builder(MarshallingType.LIST)
            .memberName("OptionsToRemove")
            .getter(getter(UpdateConfigurationTemplateRequest::optionsToRemove))
            .setter(setter(Builder::optionsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OptionSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptionSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            TEMPLATE_NAME_FIELD, DESCRIPTION_FIELD, OPTION_SETTINGS_FIELD, OPTIONS_TO_REMOVE_FIELD));

    private final String applicationName;

    private final String templateName;

    private final String description;

    private final List<ConfigurationOptionSetting> optionSettings;

    private final List<OptionSpecification> optionsToRemove;

    private UpdateConfigurationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.optionSettings = builder.optionSettings;
        this.optionsToRemove = builder.optionsToRemove;
    }

    /**
     * <p>
     * The name of the application associated with the configuration template to update.
     * </p>
     * <p>
     * If no application is found with this name, <code>UpdateConfigurationTemplate</code> returns an
     * <code>InvalidParameterValue</code> error.
     * </p>
     * 
     * @return The name of the application associated with the configuration template to update.</p>
     *         <p>
     *         If no application is found with this name, <code>UpdateConfigurationTemplate</code> returns an
     *         <code>InvalidParameterValue</code> error.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The name of the configuration template to update.
     * </p>
     * <p>
     * If no configuration template is found with this name, <code>UpdateConfigurationTemplate</code> returns an
     * <code>InvalidParameterValue</code> error.
     * </p>
     * 
     * @return The name of the configuration template to update.</p>
     *         <p>
     *         If no configuration template is found with this name, <code>UpdateConfigurationTemplate</code> returns an
     *         <code>InvalidParameterValue</code> error.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * A new description for the configuration.
     * </p>
     * 
     * @return A new description for the configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionSettings() {
        return optionSettings != null && !(optionSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of configuration option settings to update with the new specified option value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionSettings} method.
     * </p>
     * 
     * @return A list of configuration option settings to update with the new specified option value.
     */
    public final List<ConfigurationOptionSetting> optionSettings() {
        return optionSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionsToRemove property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionsToRemove() {
        return optionsToRemove != null && !(optionsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of configuration options to remove from the configuration set.
     * </p>
     * <p>
     * Constraint: You can remove only <code>UserDefined</code> configuration options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionsToRemove} method.
     * </p>
     * 
     * @return A list of configuration options to remove from the configuration set.</p>
     *         <p>
     *         Constraint: You can remove only <code>UserDefined</code> configuration options.
     */
    public final List<OptionSpecification> optionsToRemove() {
        return optionsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionSettings() ? optionSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionsToRemove() ? optionsToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationTemplateRequest)) {
            return false;
        }
        UpdateConfigurationTemplateRequest other = (UpdateConfigurationTemplateRequest) obj;
        return Objects.equals(applicationName(), other.applicationName()) && Objects.equals(templateName(), other.templateName())
                && Objects.equals(description(), other.description()) && hasOptionSettings() == other.hasOptionSettings()
                && Objects.equals(optionSettings(), other.optionSettings()) && hasOptionsToRemove() == other.hasOptionsToRemove()
                && Objects.equals(optionsToRemove(), other.optionsToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfigurationTemplateRequest").add("ApplicationName", applicationName())
                .add("TemplateName", templateName()).add("Description", description())
                .add("OptionSettings", hasOptionSettings() ? optionSettings() : null)
                .add("OptionsToRemove", hasOptionsToRemove() ? optionsToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "OptionSettings":
            return Optional.ofNullable(clazz.cast(optionSettings()));
        case "OptionsToRemove":
            return Optional.ofNullable(clazz.cast(optionsToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationTemplateRequest, T> g) {
        return obj -> g.apply((UpdateConfigurationTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConfigurationTemplateRequest> {
        /**
         * <p>
         * The name of the application associated with the configuration template to update.
         * </p>
         * <p>
         * If no application is found with this name, <code>UpdateConfigurationTemplate</code> returns an
         * <code>InvalidParameterValue</code> error.
         * </p>
         * 
         * @param applicationName
         *        The name of the application associated with the configuration template to update.</p>
         *        <p>
         *        If no application is found with this name, <code>UpdateConfigurationTemplate</code> returns an
         *        <code>InvalidParameterValue</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The name of the configuration template to update.
         * </p>
         * <p>
         * If no configuration template is found with this name, <code>UpdateConfigurationTemplate</code> returns an
         * <code>InvalidParameterValue</code> error.
         * </p>
         * 
         * @param templateName
         *        The name of the configuration template to update.</p>
         *        <p>
         *        If no configuration template is found with this name, <code>UpdateConfigurationTemplate</code> returns
         *        an <code>InvalidParameterValue</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * A new description for the configuration.
         * </p>
         * 
         * @param description
         *        A new description for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of configuration option settings to update with the new specified option value.
         * </p>
         * 
         * @param optionSettings
         *        A list of configuration option settings to update with the new specified option value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings);

        /**
         * <p>
         * A list of configuration option settings to update with the new specified option value.
         * </p>
         * 
         * @param optionSettings
         *        A list of configuration option settings to update with the new specified option value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(ConfigurationOptionSetting... optionSettings);

        /**
         * <p>
         * A list of configuration option settings to update with the new specified option value.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationOptionSetting>.Builder}
         * avoiding the need to create one manually via {@link List<ConfigurationOptionSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationOptionSetting>.Builder#build()} is called
         * immediately and its result is passed to {@link #optionSettings(List<ConfigurationOptionSetting>)}.
         * 
         * @param optionSettings
         *        a consumer that will call methods on {@link List<ConfigurationOptionSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionSettings(List<ConfigurationOptionSetting>)
         */
        Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder>... optionSettings);

        /**
         * <p>
         * A list of configuration options to remove from the configuration set.
         * </p>
         * <p>
         * Constraint: You can remove only <code>UserDefined</code> configuration options.
         * </p>
         * 
         * @param optionsToRemove
         *        A list of configuration options to remove from the configuration set.</p>
         *        <p>
         *        Constraint: You can remove only <code>UserDefined</code> configuration options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsToRemove(Collection<OptionSpecification> optionsToRemove);

        /**
         * <p>
         * A list of configuration options to remove from the configuration set.
         * </p>
         * <p>
         * Constraint: You can remove only <code>UserDefined</code> configuration options.
         * </p>
         * 
         * @param optionsToRemove
         *        A list of configuration options to remove from the configuration set.</p>
         *        <p>
         *        Constraint: You can remove only <code>UserDefined</code> configuration options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsToRemove(OptionSpecification... optionsToRemove);

        /**
         * <p>
         * A list of configuration options to remove from the configuration set.
         * </p>
         * <p>
         * Constraint: You can remove only <code>UserDefined</code> configuration options.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OptionSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<OptionSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OptionSpecification>.Builder#build()} is called immediately
         * and its result is passed to {@link #optionsToRemove(List<OptionSpecification>)}.
         * 
         * @param optionsToRemove
         *        a consumer that will call methods on {@link List<OptionSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionsToRemove(List<OptionSpecification>)
         */
        Builder optionsToRemove(Consumer<OptionSpecification.Builder>... optionsToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String templateName;

        private String description;

        private List<ConfigurationOptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();

        private List<OptionSpecification> optionsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationTemplateRequest model) {
            super(model);
            applicationName(model.applicationName);
            templateName(model.templateName);
            description(model.description);
            optionSettings(model.optionSettings);
            optionsToRemove(model.optionsToRemove);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        @Transient
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ConfigurationOptionSetting.Builder> getOptionSettings() {
            List<ConfigurationOptionSetting.Builder> result = ConfigurationOptionSettingsListCopier
                    .copyToBuilder(this.optionSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copyFromBuilder(optionSettings);
        }

        @Override
        @Transient
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting... optionSettings) {
            optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder>... optionSettings) {
            optionSettings(Stream.of(optionSettings).map(c -> ConfigurationOptionSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OptionSpecification.Builder> getOptionsToRemove() {
            List<OptionSpecification.Builder> result = OptionsSpecifierListCopier.copyToBuilder(this.optionsToRemove);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionsToRemove(Collection<OptionSpecification.BuilderImpl> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copyFromBuilder(optionsToRemove);
        }

        @Override
        @Transient
        public final Builder optionsToRemove(Collection<OptionSpecification> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copy(optionsToRemove);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder optionsToRemove(OptionSpecification... optionsToRemove) {
            optionsToRemove(Arrays.asList(optionsToRemove));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder optionsToRemove(Consumer<OptionSpecification.Builder>... optionsToRemove) {
            optionsToRemove(Stream.of(optionsToRemove).map(c -> OptionSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationTemplateRequest build() {
            return new UpdateConfigurationTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
