/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to describe one or more applications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationsRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<DescribeApplicationsRequest.Builder, DescribeApplicationsRequest> {
    private static final SdkField<List<String>> APPLICATION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ApplicationNames")
            .getter(getter(DescribeApplicationsRequest::applicationNames))
            .setter(setter(Builder::applicationNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAMES_FIELD));

    private final List<String> applicationNames;

    private DescribeApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationNames = builder.applicationNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicationNames() {
        return applicationNames != null && !(applicationNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include those with the specified
     * names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationNames} method.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include those with the
     *         specified names.
     */
    public final List<String> applicationNames() {
        return applicationNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationNames() ? applicationNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationsRequest)) {
            return false;
        }
        DescribeApplicationsRequest other = (DescribeApplicationsRequest) obj;
        return hasApplicationNames() == other.hasApplicationNames()
                && Objects.equals(applicationNames(), other.applicationNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicationsRequest")
                .add("ApplicationNames", hasApplicationNames() ? applicationNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationNames":
            return Optional.ofNullable(clazz.cast(applicationNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationsRequest, T> g) {
        return obj -> g.apply((DescribeApplicationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicationsRequest> {
        /**
         * <p>
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include those with the
         * specified names.
         * </p>
         * 
         * @param applicationNames
         *        If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include those with the
         *        specified names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationNames(Collection<String> applicationNames);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include those with the
         * specified names.
         * </p>
         * 
         * @param applicationNames
         *        If specified, AWS Elastic Beanstalk restricts the returned descriptions to only include those with the
         *        specified names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationNames(String... applicationNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private List<String> applicationNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationsRequest model) {
            super(model);
            applicationNames(model.applicationNames);
        }

        public final Collection<String> getApplicationNames() {
            if (applicationNames instanceof SdkAutoConstructList) {
                return null;
            }
            return applicationNames;
        }

        public final void setApplicationNames(Collection<String> applicationNames) {
            this.applicationNames = ApplicationNamesListCopier.copy(applicationNames);
        }

        @Override
        public final Builder applicationNames(Collection<String> applicationNames) {
            this.applicationNames = ApplicationNamesListCopier.copy(applicationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationNames(String... applicationNames) {
            applicationNames(Arrays.asList(applicationNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeApplicationsRequest build() {
            return new DescribeApplicationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
