/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescriptionListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeApplicationsResponse> {
    private static final SdkField<List<ApplicationDescription>> APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Applications").getter(DescribeApplicationsResponse.getter(DescribeApplicationsResponse::applications)).setter(DescribeApplicationsResponse.setter(Builder::applications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATIONS_FIELD));
    private final List<ApplicationDescription> applications;

    private DescribeApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applications = builder.applications;
    }

    public final boolean hasApplications() {
        return this.applications != null && !(this.applications instanceof SdkAutoConstructList);
    }

    public final List<ApplicationDescription> applications() {
        return this.applications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplications() ? this.applications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationsResponse)) {
            return false;
        }
        DescribeApplicationsResponse other = (DescribeApplicationsResponse)((Object)obj);
        return this.hasApplications() == other.hasApplications() && Objects.equals(this.applications(), other.applications());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeApplicationsResponse").add("Applications", this.hasApplications() ? this.applications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Applications": {
                return Optional.ofNullable(clazz.cast(this.applications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationsResponse, T> g) {
        return obj -> g.apply((DescribeApplicationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<ApplicationDescription> applications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationsResponse model) {
            super(model);
            this.applications(model.applications);
        }

        public final List<ApplicationDescription.Builder> getApplications() {
            List<ApplicationDescription.Builder> result = ApplicationDescriptionListCopier.copyToBuilder(this.applications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplications(Collection<ApplicationDescription.BuilderImpl> applications) {
            this.applications = ApplicationDescriptionListCopier.copyFromBuilder(applications);
        }

        @Override
        public final Builder applications(Collection<ApplicationDescription> applications) {
            this.applications = ApplicationDescriptionListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(ApplicationDescription ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<ApplicationDescription.Builder> ... applications) {
            this.applications(Stream.of(applications).map(c -> (ApplicationDescription)((ApplicationDescription.Builder)ApplicationDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeApplicationsResponse build() {
            return new DescribeApplicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationsResponse> {
        public Builder applications(Collection<ApplicationDescription> var1);

        public Builder applications(ApplicationDescription ... var1);

        public Builder applications(Consumer<ApplicationDescription.Builder> ... var1);
    }
}

