/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to retrieve a list of events for an environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventsRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<DescribeEventsRequest.Builder, DescribeEventsRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(DescribeEventsRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionLabel").getter(getter(DescribeEventsRequest::versionLabel)).setter(setter(Builder::versionLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(DescribeEventsRequest::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(DescribeEventsRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentName").getter(getter(DescribeEventsRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformArn").getter(getter(DescribeEventsRequest::platformArn)).setter(setter(Builder::platformArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeEventsRequest::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(DescribeEventsRequest::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeEventsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeEventsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeEventsRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeEventsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            VERSION_LABEL_FIELD, TEMPLATE_NAME_FIELD, ENVIRONMENT_ID_FIELD, ENVIRONMENT_NAME_FIELD, PLATFORM_ARN_FIELD,
            REQUEST_ID_FIELD, SEVERITY_FIELD, START_TIME_FIELD, END_TIME_FIELD, MAX_RECORDS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ApplicationName", APPLICATION_NAME_FIELD);
                    put("VersionLabel", VERSION_LABEL_FIELD);
                    put("TemplateName", TEMPLATE_NAME_FIELD);
                    put("EnvironmentId", ENVIRONMENT_ID_FIELD);
                    put("EnvironmentName", ENVIRONMENT_NAME_FIELD);
                    put("PlatformArn", PLATFORM_ARN_FIELD);
                    put("RequestId", REQUEST_ID_FIELD);
                    put("Severity", SEVERITY_FIELD);
                    put("StartTime", START_TIME_FIELD);
                    put("EndTime", END_TIME_FIELD);
                    put("MaxRecords", MAX_RECORDS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final String applicationName;

    private final String versionLabel;

    private final String templateName;

    private final String environmentId;

    private final String environmentName;

    private final String platformArn;

    private final String requestId;

    private final String severity;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer maxRecords;

    private final String nextToken;

    private DescribeEventsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.templateName = builder.templateName;
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
        this.platformArn = builder.platformArn;
        this.requestId = builder.requestId;
        this.severity = builder.severity;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those associated with
     * this application.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those associated
     *         with this application.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this application
     * version.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this
     *         application version.
     */
    public final String versionLabel() {
        return versionLabel;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that are associated with this
     * environment configuration.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that are associated with
     *         this environment configuration.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this
     * environment.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this
     *         environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this
     * environment.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this
     *         environment.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the returned descriptions to
     * those associated with this custom platform version.
     * </p>
     * 
     * @return The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the returned
     *         descriptions to those associated with this custom platform version.
     */
    public final String platformArn() {
        return platformArn;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the described events to include only those associated with this
     * request ID.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk restricts the described events to include only those associated with
     *         this request ID.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * If specified, limits the events returned from this call to include only those with the specified severity or
     * higher.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link EventSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return If specified, limits the events returned from this call to include only those with the specified severity
     *         or higher.
     * @see EventSeverity
     */
    public final EventSeverity severity() {
        return EventSeverity.fromValue(severity);
    }

    /**
     * <p>
     * If specified, limits the events returned from this call to include only those with the specified severity or
     * higher.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link EventSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return If specified, limits the events returned from this call to include only those with the specified severity
     *         or higher.
     * @see EventSeverity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur on or after this
     * time.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur on or after
     *         this time.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur up to, but not
     * including, the <code>EndTime</code>.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur up to, but
     *         not including, the <code>EndTime</code>.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Specifies the maximum number of events that can be returned, beginning with the most recent event.
     * </p>
     * 
     * @return Specifies the maximum number of events that can be returned, beginning with the most recent event.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * Pagination token. If specified, the events return the next batch of results.
     * </p>
     * 
     * @return Pagination token. If specified, the events return the next batch of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsRequest)) {
            return false;
        }
        DescribeEventsRequest other = (DescribeEventsRequest) obj;
        return Objects.equals(applicationName(), other.applicationName()) && Objects.equals(versionLabel(), other.versionLabel())
                && Objects.equals(templateName(), other.templateName()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(platformArn(), other.platformArn()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(severityAsString(), other.severityAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEventsRequest").add("ApplicationName", applicationName())
                .add("VersionLabel", versionLabel()).add("TemplateName", templateName()).add("EnvironmentId", environmentId())
                .add("EnvironmentName", environmentName()).add("PlatformArn", platformArn()).add("RequestId", requestId())
                .add("Severity", severityAsString()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("MaxRecords", maxRecords()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "VersionLabel":
            return Optional.ofNullable(clazz.cast(versionLabel()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "PlatformArn":
            return Optional.ofNullable(clazz.cast(platformArn()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventsRequest, T> g) {
        return obj -> g.apply((DescribeEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventsRequest> {
        /**
         * <p>
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those associated with
         * this application.
         * </p>
         * 
         * @param applicationName
         *        If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those
         *        associated with this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this
         * application version.
         * </p>
         * 
         * @param versionLabel
         *        If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this
         *        application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionLabel(String versionLabel);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that are associated with
         * this environment configuration.
         * </p>
         * 
         * @param templateName
         *        If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that are associated
         *        with this environment configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this
         * environment.
         * </p>
         * 
         * @param environmentId
         *        If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this
         *        environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this
         * environment.
         * </p>
         * 
         * @param environmentName
         *        If specified, AWS Elastic Beanstalk restricts the returned descriptions to those associated with this
         *        environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the returned descriptions
         * to those associated with this custom platform version.
         * </p>
         * 
         * @param platformArn
         *        The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the returned
         *        descriptions to those associated with this custom platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformArn(String platformArn);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk restricts the described events to include only those associated with this
         * request ID.
         * </p>
         * 
         * @param requestId
         *        If specified, AWS Elastic Beanstalk restricts the described events to include only those associated
         *        with this request ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * If specified, limits the events returned from this call to include only those with the specified severity or
         * higher.
         * </p>
         * 
         * @param severity
         *        If specified, limits the events returned from this call to include only those with the specified
         *        severity or higher.
         * @see EventSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * If specified, limits the events returned from this call to include only those with the specified severity or
         * higher.
         * </p>
         * 
         * @param severity
         *        If specified, limits the events returned from this call to include only those with the specified
         *        severity or higher.
         * @see EventSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSeverity
         */
        Builder severity(EventSeverity severity);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur on or after this
         * time.
         * </p>
         * 
         * @param startTime
         *        If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur on or
         *        after this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur up to, but not
         * including, the <code>EndTime</code>.
         * </p>
         * 
         * @param endTime
         *        If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that occur up to, but
         *        not including, the <code>EndTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Specifies the maximum number of events that can be returned, beginning with the most recent event.
         * </p>
         * 
         * @param maxRecords
         *        Specifies the maximum number of events that can be returned, beginning with the most recent event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * Pagination token. If specified, the events return the next batch of results.
         * </p>
         * 
         * @param nextToken
         *        Pagination token. If specified, the events return the next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String versionLabel;

        private String templateName;

        private String environmentId;

        private String environmentName;

        private String platformArn;

        private String requestId;

        private String severity;

        private Instant startTime;

        private Instant endTime;

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsRequest model) {
            super(model);
            applicationName(model.applicationName);
            versionLabel(model.versionLabel);
            templateName(model.templateName);
            environmentId(model.environmentId);
            environmentName(model.environmentName);
            platformArn(model.platformArn);
            requestId(model.requestId);
            severity(model.severity);
            startTime(model.startTime);
            endTime(model.endTime);
            maxRecords(model.maxRecords);
            nextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getVersionLabel() {
            return versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getPlatformArn() {
            return platformArn;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(EventSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventsRequest build() {
            return new DescribeEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
