/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to terminate an environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateEnvironmentRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<TerminateEnvironmentRequest.Builder, TerminateEnvironmentRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(TerminateEnvironmentRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentName").getter(getter(TerminateEnvironmentRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<Boolean> TERMINATE_RESOURCES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminateResources").getter(getter(TerminateEnvironmentRequest::terminateResources))
            .setter(setter(Builder::terminateResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateResources").build())
            .build();

    private static final SdkField<Boolean> FORCE_TERMINATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceTerminate").getter(getter(TerminateEnvironmentRequest::forceTerminate))
            .setter(setter(Builder::forceTerminate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceTerminate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            ENVIRONMENT_NAME_FIELD, TERMINATE_RESOURCES_FIELD, FORCE_TERMINATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("EnvironmentId", ENVIRONMENT_ID_FIELD);
                    put("EnvironmentName", ENVIRONMENT_NAME_FIELD);
                    put("TerminateResources", TERMINATE_RESOURCES_FIELD);
                    put("ForceTerminate", FORCE_TERMINATE_FIELD);
                }
            });

    private final String environmentId;

    private final String environmentName;

    private final Boolean terminateResources;

    private final Boolean forceTerminate;

    private TerminateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
        this.terminateResources = builder.terminateResources;
        this.forceTerminate = builder.forceTerminate;
    }

    /**
     * <p>
     * The ID of the environment to terminate.
     * </p>
     * <p>
     * Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic
     * Beanstalk returns <code>MissingRequiredParameter</code> error.
     * </p>
     * 
     * @return The ID of the environment to terminate.</p>
     *         <p>
     *         Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS
     *         Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The name of the environment to terminate.
     * </p>
     * <p>
     * Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic
     * Beanstalk returns <code>MissingRequiredParameter</code> error.
     * </p>
     * 
     * @return The name of the environment to terminate.</p>
     *         <p>
     *         Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS
     *         Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * Indicates whether the associated AWS resources should shut down when the environment is terminated:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>true</code>: The specified environment as well as the associated AWS resources, such as Auto Scaling group
     * and LoadBalancer, are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>false</code>: AWS Elastic Beanstalk resource management is removed from the environment, but the AWS
     * resources continue to operate.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS Elastic
     * Beanstalk User Guide. </a>
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return Indicates whether the associated AWS resources should shut down when the environment is terminated:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>true</code>: The specified environment as well as the associated AWS resources, such as Auto
     *         Scaling group and LoadBalancer, are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>false</code>: AWS Elastic Beanstalk resource management is removed from the environment, but the
     *         AWS resources continue to operate.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS
     *         Elastic Beanstalk User Guide. </a>
     *         </p>
     *         <p>
     *         Default: <code>true</code>
     *         </p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean terminateResources() {
        return terminateResources;
    }

    /**
     * <p>
     * Terminates the target environment even if another environment in the same group is dependent on it.
     * </p>
     * 
     * @return Terminates the target environment even if another environment in the same group is dependent on it.
     */
    public final Boolean forceTerminate() {
        return forceTerminate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(terminateResources());
        hashCode = 31 * hashCode + Objects.hashCode(forceTerminate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateEnvironmentRequest)) {
            return false;
        }
        TerminateEnvironmentRequest other = (TerminateEnvironmentRequest) obj;
        return Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(terminateResources(), other.terminateResources())
                && Objects.equals(forceTerminate(), other.forceTerminate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TerminateEnvironmentRequest").add("EnvironmentId", environmentId())
                .add("EnvironmentName", environmentName()).add("TerminateResources", terminateResources())
                .add("ForceTerminate", forceTerminate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "TerminateResources":
            return Optional.ofNullable(clazz.cast(terminateResources()));
        case "ForceTerminate":
            return Optional.ofNullable(clazz.cast(forceTerminate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TerminateEnvironmentRequest, T> g) {
        return obj -> g.apply((TerminateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, TerminateEnvironmentRequest> {
        /**
         * <p>
         * The ID of the environment to terminate.
         * </p>
         * <p>
         * Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS
         * Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
         * </p>
         * 
         * @param environmentId
         *        The ID of the environment to terminate.</p>
         *        <p>
         *        Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either,
         *        AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The name of the environment to terminate.
         * </p>
         * <p>
         * Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS
         * Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
         * </p>
         * 
         * @param environmentName
         *        The name of the environment to terminate.</p>
         *        <p>
         *        Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either,
         *        AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * Indicates whether the associated AWS resources should shut down when the environment is terminated:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>true</code>: The specified environment as well as the associated AWS resources, such as Auto Scaling
         * group and LoadBalancer, are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>false</code>: AWS Elastic Beanstalk resource management is removed from the environment, but the AWS
         * resources continue to operate.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS Elastic
         * Beanstalk User Guide. </a>
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param terminateResources
         *        Indicates whether the associated AWS resources should shut down when the environment is
         *        terminated:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>true</code>: The specified environment as well as the associated AWS resources, such as Auto
         *        Scaling group and LoadBalancer, are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>false</code>: AWS Elastic Beanstalk resource management is removed from the environment, but the
         *        AWS resources continue to operate.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS
         *        Elastic Beanstalk User Guide. </a>
         *        </p>
         *        <p>
         *        Default: <code>true</code>
         *        </p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateResources(Boolean terminateResources);

        /**
         * <p>
         * Terminates the target environment even if another environment in the same group is dependent on it.
         * </p>
         * 
         * @param forceTerminate
         *        Terminates the target environment even if another environment in the same group is dependent on it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceTerminate(Boolean forceTerminate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String environmentId;

        private String environmentName;

        private Boolean terminateResources;

        private Boolean forceTerminate;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateEnvironmentRequest model) {
            super(model);
            environmentId(model.environmentId);
            environmentName(model.environmentName);
            terminateResources(model.terminateResources);
            forceTerminate(model.forceTerminate);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final Boolean getTerminateResources() {
            return terminateResources;
        }

        public final void setTerminateResources(Boolean terminateResources) {
            this.terminateResources = terminateResources;
        }

        @Override
        public final Builder terminateResources(Boolean terminateResources) {
            this.terminateResources = terminateResources;
            return this;
        }

        public final Boolean getForceTerminate() {
            return forceTerminate;
        }

        public final void setForceTerminate(Boolean forceTerminate) {
            this.forceTerminate = forceTerminate;
        }

        @Override
        public final Builder forceTerminate(Boolean forceTerminate) {
            this.forceTerminate = forceTerminate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TerminateEnvironmentRequest build() {
            return new TerminateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
