/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of an environment tier
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentTier implements SdkPojo, Serializable, ToCopyableBuilder<EnvironmentTier.Builder, EnvironmentTier> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(EnvironmentTier::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(EnvironmentTier::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(EnvironmentTier::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("Type", TYPE_FIELD);
                    put("Version", VERSION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String version;

    private EnvironmentTier(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.version = builder.version;
    }

    /**
     * <p>
     * The name of this environment tier.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <i>Web server tier</i> – <code>WebServer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * For <i>Worker tier</i> – <code>Worker</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of this environment tier.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <i>Web server tier</i> – <code>WebServer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <i>Worker tier</i> – <code>Worker</code>
     *         </p>
     *         </li>
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of this environment tier.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <i>Web server tier</i> – <code>Standard</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * For <i>Worker tier</i> – <code>SQS/HTTP</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of this environment tier.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <i>Web server tier</i> – <code>Standard</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <i>Worker tier</i> – <code>SQS/HTTP</code>
     *         </p>
     *         </li>
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The version of this environment tier. When you don't set a value to it, Elastic Beanstalk uses the latest
     * compatible worker tier version.
     * </p>
     * <note>
     * <p>
     * This member is deprecated. Any specific version that you set may become out of date. We recommend leaving it
     * unspecified.
     * </p>
     * </note>
     * 
     * @return The version of this environment tier. When you don't set a value to it, Elastic Beanstalk uses the latest
     *         compatible worker tier version.</p> <note>
     *         <p>
     *         This member is deprecated. Any specific version that you set may become out of date. We recommend leaving
     *         it unspecified.
     *         </p>
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentTier)) {
            return false;
        }
        EnvironmentTier other = (EnvironmentTier) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(type(), other.type())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentTier").add("Name", name()).add("Type", type()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentTier, T> g) {
        return obj -> g.apply((EnvironmentTier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentTier> {
        /**
         * <p>
         * The name of this environment tier.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <i>Web server tier</i> – <code>WebServer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * For <i>Worker tier</i> – <code>Worker</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of this environment tier.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <i>Web server tier</i> – <code>WebServer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <i>Worker tier</i> – <code>Worker</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of this environment tier.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <i>Web server tier</i> – <code>Standard</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * For <i>Worker tier</i> – <code>SQS/HTTP</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of this environment tier.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <i>Web server tier</i> – <code>Standard</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <i>Worker tier</i> – <code>SQS/HTTP</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The version of this environment tier. When you don't set a value to it, Elastic Beanstalk uses the latest
         * compatible worker tier version.
         * </p>
         * <note>
         * <p>
         * This member is deprecated. Any specific version that you set may become out of date. We recommend leaving it
         * unspecified.
         * </p>
         * </note>
         * 
         * @param version
         *        The version of this environment tier. When you don't set a value to it, Elastic Beanstalk uses the
         *        latest compatible worker tier version.</p> <note>
         *        <p>
         *        This member is deprecated. Any specific version that you set may become out of date. We recommend
         *        leaving it unspecified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentTier model) {
            name(model.name);
            type(model.type);
            version(model.version);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public EnvironmentTier build() {
            return new EnvironmentTier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
