/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A lifecycle rule that deletes application versions after the specified number of days.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaxAgeRule implements SdkPojo, Serializable, ToCopyableBuilder<MaxAgeRule.Builder, MaxAgeRule> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(MaxAgeRule::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Integer> MAX_AGE_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAgeInDays").getter(getter(MaxAgeRule::maxAgeInDays)).setter(setter(Builder::maxAgeInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAgeInDays").build()).build();

    private static final SdkField<Boolean> DELETE_SOURCE_FROM_S3_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteSourceFromS3").getter(getter(MaxAgeRule::deleteSourceFromS3))
            .setter(setter(Builder::deleteSourceFromS3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteSourceFromS3").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            MAX_AGE_IN_DAYS_FIELD, DELETE_SOURCE_FROM_S3_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Enabled", ENABLED_FIELD);
                    put("MaxAgeInDays", MAX_AGE_IN_DAYS_FIELD);
                    put("DeleteSourceFromS3", DELETE_SOURCE_FROM_S3_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Integer maxAgeInDays;

    private final Boolean deleteSourceFromS3;

    private MaxAgeRule(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.maxAgeInDays = builder.maxAgeInDays;
        this.deleteSourceFromS3 = builder.deleteSourceFromS3;
    }

    /**
     * <p>
     * Specify <code>true</code> to apply the rule, or <code>false</code> to disable it.
     * </p>
     * 
     * @return Specify <code>true</code> to apply the rule, or <code>false</code> to disable it.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Specify the number of days to retain an application versions.
     * </p>
     * 
     * @return Specify the number of days to retain an application versions.
     */
    public final Integer maxAgeInDays() {
        return maxAgeInDays;
    }

    /**
     * <p>
     * Set to <code>true</code> to delete a version's source bundle from Amazon S3 when Elastic Beanstalk deletes the
     * application version.
     * </p>
     * 
     * @return Set to <code>true</code> to delete a version's source bundle from Amazon S3 when Elastic Beanstalk
     *         deletes the application version.
     */
    public final Boolean deleteSourceFromS3() {
        return deleteSourceFromS3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(maxAgeInDays());
        hashCode = 31 * hashCode + Objects.hashCode(deleteSourceFromS3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaxAgeRule)) {
            return false;
        }
        MaxAgeRule other = (MaxAgeRule) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(maxAgeInDays(), other.maxAgeInDays())
                && Objects.equals(deleteSourceFromS3(), other.deleteSourceFromS3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MaxAgeRule").add("Enabled", enabled()).add("MaxAgeInDays", maxAgeInDays())
                .add("DeleteSourceFromS3", deleteSourceFromS3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "MaxAgeInDays":
            return Optional.ofNullable(clazz.cast(maxAgeInDays()));
        case "DeleteSourceFromS3":
            return Optional.ofNullable(clazz.cast(deleteSourceFromS3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MaxAgeRule, T> g) {
        return obj -> g.apply((MaxAgeRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaxAgeRule> {
        /**
         * <p>
         * Specify <code>true</code> to apply the rule, or <code>false</code> to disable it.
         * </p>
         * 
         * @param enabled
         *        Specify <code>true</code> to apply the rule, or <code>false</code> to disable it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Specify the number of days to retain an application versions.
         * </p>
         * 
         * @param maxAgeInDays
         *        Specify the number of days to retain an application versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAgeInDays(Integer maxAgeInDays);

        /**
         * <p>
         * Set to <code>true</code> to delete a version's source bundle from Amazon S3 when Elastic Beanstalk deletes
         * the application version.
         * </p>
         * 
         * @param deleteSourceFromS3
         *        Set to <code>true</code> to delete a version's source bundle from Amazon S3 when Elastic Beanstalk
         *        deletes the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteSourceFromS3(Boolean deleteSourceFromS3);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Integer maxAgeInDays;

        private Boolean deleteSourceFromS3;

        private BuilderImpl() {
        }

        private BuilderImpl(MaxAgeRule model) {
            enabled(model.enabled);
            maxAgeInDays(model.maxAgeInDays);
            deleteSourceFromS3(model.deleteSourceFromS3);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getMaxAgeInDays() {
            return maxAgeInDays;
        }

        public final void setMaxAgeInDays(Integer maxAgeInDays) {
            this.maxAgeInDays = maxAgeInDays;
        }

        @Override
        public final Builder maxAgeInDays(Integer maxAgeInDays) {
            this.maxAgeInDays = maxAgeInDays;
            return this;
        }

        public final Boolean getDeleteSourceFromS3() {
            return deleteSourceFromS3;
        }

        public final void setDeleteSourceFromS3(Boolean deleteSourceFromS3) {
            this.deleteSourceFromS3 = deleteSourceFromS3;
        }

        @Override
        public final Builder deleteSourceFromS3(Boolean deleteSourceFromS3) {
            this.deleteSourceFromS3 = deleteSourceFromS3;
            return this;
        }

        @Override
        public MaxAgeRule build() {
            return new MaxAgeRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
