/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationResourceLifecycleResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<UpdateApplicationResourceLifecycleResponse.Builder, UpdateApplicationResourceLifecycleResponse> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(UpdateApplicationResourceLifecycleResponse::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<ApplicationResourceLifecycleConfig> RESOURCE_LIFECYCLE_CONFIG_FIELD = SdkField
            .<ApplicationResourceLifecycleConfig> builder(MarshallingType.SDK_POJO).memberName("ResourceLifecycleConfig")
            .getter(getter(UpdateApplicationResourceLifecycleResponse::resourceLifecycleConfig))
            .setter(setter(Builder::resourceLifecycleConfig)).constructor(ApplicationResourceLifecycleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLifecycleConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            RESOURCE_LIFECYCLE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ApplicationName", APPLICATION_NAME_FIELD);
                    put("ResourceLifecycleConfig", RESOURCE_LIFECYCLE_CONFIG_FIELD);
                }
            });

    private final String applicationName;

    private final ApplicationResourceLifecycleConfig resourceLifecycleConfig;

    private UpdateApplicationResourceLifecycleResponse(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.resourceLifecycleConfig = builder.resourceLifecycleConfig;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The lifecycle configuration.
     * </p>
     * 
     * @return The lifecycle configuration.
     */
    public final ApplicationResourceLifecycleConfig resourceLifecycleConfig() {
        return resourceLifecycleConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceLifecycleConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationResourceLifecycleResponse)) {
            return false;
        }
        UpdateApplicationResourceLifecycleResponse other = (UpdateApplicationResourceLifecycleResponse) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(resourceLifecycleConfig(), other.resourceLifecycleConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationResourceLifecycleResponse").add("ApplicationName", applicationName())
                .add("ResourceLifecycleConfig", resourceLifecycleConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "ResourceLifecycleConfig":
            return Optional.ofNullable(clazz.cast(resourceLifecycleConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationResourceLifecycleResponse, T> g) {
        return obj -> g.apply((UpdateApplicationResourceLifecycleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApplicationResourceLifecycleResponse> {
        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param applicationName
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The lifecycle configuration.
         * </p>
         * 
         * @param resourceLifecycleConfig
         *        The lifecycle configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig);

        /**
         * <p>
         * The lifecycle configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ApplicationResourceLifecycleConfig.Builder} avoiding the need to create one manually via
         * {@link ApplicationResourceLifecycleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationResourceLifecycleConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceLifecycleConfig(ApplicationResourceLifecycleConfig)}.
         * 
         * @param resourceLifecycleConfig
         *        a consumer that will call methods on {@link ApplicationResourceLifecycleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceLifecycleConfig(ApplicationResourceLifecycleConfig)
         */
        default Builder resourceLifecycleConfig(Consumer<ApplicationResourceLifecycleConfig.Builder> resourceLifecycleConfig) {
            return resourceLifecycleConfig(ApplicationResourceLifecycleConfig.builder().applyMutation(resourceLifecycleConfig)
                    .build());
        }
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private String applicationName;

        private ApplicationResourceLifecycleConfig resourceLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationResourceLifecycleResponse model) {
            super(model);
            applicationName(model.applicationName);
            resourceLifecycleConfig(model.resourceLifecycleConfig);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final ApplicationResourceLifecycleConfig.Builder getResourceLifecycleConfig() {
            return resourceLifecycleConfig != null ? resourceLifecycleConfig.toBuilder() : null;
        }

        public final void setResourceLifecycleConfig(ApplicationResourceLifecycleConfig.BuilderImpl resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig != null ? resourceLifecycleConfig.build() : null;
        }

        @Override
        public final Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig;
            return this;
        }

        @Override
        public UpdateApplicationResourceLifecycleResponse build() {
            return new UpdateApplicationResourceLifecycleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
