/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSettingsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.Tag;
import software.amazon.awssdk.services.elasticbeanstalk.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfigurationTemplateRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, CreateConfigurationTemplateRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(CreateConfigurationTemplateRequest.getter(CreateConfigurationTemplateRequest::applicationName)).setter(CreateConfigurationTemplateRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(CreateConfigurationTemplateRequest.getter(CreateConfigurationTemplateRequest::templateName)).setter(CreateConfigurationTemplateRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SolutionStackName").getter(CreateConfigurationTemplateRequest.getter(CreateConfigurationTemplateRequest::solutionStackName)).setter(CreateConfigurationTemplateRequest.setter(Builder::solutionStackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()}).build();
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformArn").getter(CreateConfigurationTemplateRequest.getter(CreateConfigurationTemplateRequest::platformArn)).setter(CreateConfigurationTemplateRequest.setter(Builder::platformArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()}).build();
    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceConfiguration").getter(CreateConfigurationTemplateRequest.getter(CreateConfigurationTemplateRequest::sourceConfiguration)).setter(CreateConfigurationTemplateRequest.setter(Builder::sourceConfiguration)).constructor(SourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConfiguration").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(CreateConfigurationTemplateRequest.getter(CreateConfigurationTemplateRequest::environmentId)).setter(CreateConfigurationTemplateRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateConfigurationTemplateRequest.getter(CreateConfigurationTemplateRequest::description)).setter(CreateConfigurationTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<ConfigurationOptionSetting>> OPTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptionSettings").getter(CreateConfigurationTemplateRequest.getter(CreateConfigurationTemplateRequest::optionSettings)).setter(CreateConfigurationTemplateRequest.setter(Builder::optionSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationOptionSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateConfigurationTemplateRequest.getter(CreateConfigurationTemplateRequest::tags)).setter(CreateConfigurationTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, TEMPLATE_NAME_FIELD, SOLUTION_STACK_NAME_FIELD, PLATFORM_ARN_FIELD, SOURCE_CONFIGURATION_FIELD, ENVIRONMENT_ID_FIELD, DESCRIPTION_FIELD, OPTION_SETTINGS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApplicationName", APPLICATION_NAME_FIELD);
            this.put("TemplateName", TEMPLATE_NAME_FIELD);
            this.put("SolutionStackName", SOLUTION_STACK_NAME_FIELD);
            this.put("PlatformArn", PLATFORM_ARN_FIELD);
            this.put("SourceConfiguration", SOURCE_CONFIGURATION_FIELD);
            this.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("OptionSettings", OPTION_SETTINGS_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String applicationName;
    private final String templateName;
    private final String solutionStackName;
    private final String platformArn;
    private final SourceConfiguration sourceConfiguration;
    private final String environmentId;
    private final String description;
    private final List<ConfigurationOptionSetting> optionSettings;
    private final List<Tag> tags;

    private CreateConfigurationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.sourceConfiguration = builder.sourceConfiguration;
        this.environmentId = builder.environmentId;
        this.description = builder.description;
        this.optionSettings = builder.optionSettings;
        this.tags = builder.tags;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String solutionStackName() {
        return this.solutionStackName;
    }

    public final String platformArn() {
        return this.platformArn;
    }

    public final SourceConfiguration sourceConfiguration() {
        return this.sourceConfiguration;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasOptionSettings() {
        return this.optionSettings != null && !(this.optionSettings instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationOptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptionSettings() ? this.optionSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationTemplateRequest)) {
            return false;
        }
        CreateConfigurationTemplateRequest other = (CreateConfigurationTemplateRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.solutionStackName(), other.solutionStackName()) && Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.sourceConfiguration(), other.sourceConfiguration()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.description(), other.description()) && this.hasOptionSettings() == other.hasOptionSettings() && Objects.equals(this.optionSettings(), other.optionSettings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConfigurationTemplateRequest").add("ApplicationName", (Object)this.applicationName()).add("TemplateName", (Object)this.templateName()).add("SolutionStackName", (Object)this.solutionStackName()).add("PlatformArn", (Object)this.platformArn()).add("SourceConfiguration", (Object)this.sourceConfiguration()).add("EnvironmentId", (Object)this.environmentId()).add("Description", (Object)this.description()).add("OptionSettings", this.hasOptionSettings() ? this.optionSettings() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "SolutionStackName": {
                return Optional.ofNullable(clazz.cast(this.solutionStackName()));
            }
            case "PlatformArn": {
                return Optional.ofNullable(clazz.cast(this.platformArn()));
            }
            case "SourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sourceConfiguration()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OptionSettings": {
                return Optional.ofNullable(clazz.cast(this.optionSettings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationTemplateRequest, T> g) {
        return obj -> g.apply((CreateConfigurationTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String templateName;
        private String solutionStackName;
        private String platformArn;
        private SourceConfiguration sourceConfiguration;
        private String environmentId;
        private String description;
        private List<ConfigurationOptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationTemplateRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.templateName(model.templateName);
            this.solutionStackName(model.solutionStackName);
            this.platformArn(model.platformArn);
            this.sourceConfiguration(model.sourceConfiguration);
            this.environmentId(model.environmentId);
            this.description(model.description);
            this.optionSettings(model.optionSettings);
            this.tags(model.tags);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return this.sourceConfiguration != null ? this.sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ConfigurationOptionSetting.Builder> getOptionSettings() {
            List<ConfigurationOptionSetting.Builder> result = ConfigurationOptionSettingsListCopier.copyToBuilder(this.optionSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copyFromBuilder(optionSettings);
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder> ... optionSettings) {
            this.optionSettings(Stream.of(optionSettings).map(c -> (ConfigurationOptionSetting)((ConfigurationOptionSetting.Builder)ConfigurationOptionSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationTemplateRequest build() {
            return new CreateConfigurationTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfigurationTemplateRequest> {
        public Builder applicationName(String var1);

        public Builder templateName(String var1);

        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder sourceConfiguration(SourceConfiguration var1);

        default public Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return this.sourceConfiguration((SourceConfiguration)((SourceConfiguration.Builder)SourceConfiguration.builder().applyMutation(sourceConfiguration)).build());
        }

        public Builder environmentId(String var1);

        public Builder description(String var1);

        public Builder optionSettings(Collection<ConfigurationOptionSetting> var1);

        public Builder optionSettings(ConfigurationOptionSetting ... var1);

        public Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

