/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates if the specified CNAME is available.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckDnsAvailabilityResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<CheckDnsAvailabilityResponse.Builder, CheckDnsAvailabilityResponse> {
    private static final SdkField<Boolean> AVAILABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CheckDnsAvailabilityResponse::available)).setter(setter(Builder::available))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Available").build()).build();

    private static final SdkField<String> FULLY_QUALIFIED_CNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CheckDnsAvailabilityResponse::fullyQualifiedCNAME)).setter(setter(Builder::fullyQualifiedCNAME))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullyQualifiedCNAME").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_FIELD,
            FULLY_QUALIFIED_CNAME_FIELD));

    private final Boolean available;

    private final String fullyQualifiedCNAME;

    private CheckDnsAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.available = builder.available;
        this.fullyQualifiedCNAME = builder.fullyQualifiedCNAME;
    }

    /**
     * <p>
     * Indicates if the specified CNAME is available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>true</code> : The CNAME is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>false</code> : The CNAME is not available.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates if the specified CNAME is available:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>true</code> : The CNAME is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>false</code> : The CNAME is not available.
     *         </p>
     *         </li>
     */
    public Boolean available() {
        return available;
    }

    /**
     * <p>
     * The fully qualified CNAME to reserve when <a>CreateEnvironment</a> is called with the provided prefix.
     * </p>
     * 
     * @return The fully qualified CNAME to reserve when <a>CreateEnvironment</a> is called with the provided prefix.
     */
    public String fullyQualifiedCNAME() {
        return fullyQualifiedCNAME;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(available());
        hashCode = 31 * hashCode + Objects.hashCode(fullyQualifiedCNAME());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDnsAvailabilityResponse)) {
            return false;
        }
        CheckDnsAvailabilityResponse other = (CheckDnsAvailabilityResponse) obj;
        return Objects.equals(available(), other.available())
                && Objects.equals(fullyQualifiedCNAME(), other.fullyQualifiedCNAME());
    }

    @Override
    public String toString() {
        return ToString.builder("CheckDnsAvailabilityResponse").add("Available", available())
                .add("FullyQualifiedCNAME", fullyQualifiedCNAME()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Available":
            return Optional.ofNullable(clazz.cast(available()));
        case "FullyQualifiedCNAME":
            return Optional.ofNullable(clazz.cast(fullyQualifiedCNAME()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckDnsAvailabilityResponse, T> g) {
        return obj -> g.apply((CheckDnsAvailabilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CheckDnsAvailabilityResponse> {
        /**
         * <p>
         * Indicates if the specified CNAME is available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>true</code> : The CNAME is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>false</code> : The CNAME is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param available
         *        Indicates if the specified CNAME is available:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>true</code> : The CNAME is available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>false</code> : The CNAME is not available.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder available(Boolean available);

        /**
         * <p>
         * The fully qualified CNAME to reserve when <a>CreateEnvironment</a> is called with the provided prefix.
         * </p>
         * 
         * @param fullyQualifiedCNAME
         *        The fully qualified CNAME to reserve when <a>CreateEnvironment</a> is called with the provided prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullyQualifiedCNAME(String fullyQualifiedCNAME);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private Boolean available;

        private String fullyQualifiedCNAME;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDnsAvailabilityResponse model) {
            super(model);
            available(model.available);
            fullyQualifiedCNAME(model.fullyQualifiedCNAME);
        }

        public final Boolean getAvailable() {
            return available;
        }

        @Override
        public final Builder available(Boolean available) {
            this.available = available;
            return this;
        }

        public final void setAvailable(Boolean available) {
            this.available = available;
        }

        public final String getFullyQualifiedCNAME() {
            return fullyQualifiedCNAME;
        }

        @Override
        public final Builder fullyQualifiedCNAME(String fullyQualifiedCNAME) {
            this.fullyQualifiedCNAME = fullyQualifiedCNAME;
            return this;
        }

        public final void setFullyQualifiedCNAME(String fullyQualifiedCNAME) {
            this.fullyQualifiedCNAME = fullyQualifiedCNAME;
        }

        @Override
        public CheckDnsAvailabilityResponse build() {
            return new CheckDnsAvailabilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
