/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to create an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::applicationName)).setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ApplicationResourceLifecycleConfig> RESOURCE_LIFECYCLE_CONFIG_FIELD = SdkField
            .<ApplicationResourceLifecycleConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateApplicationRequest::resourceLifecycleConfig)).setter(setter(Builder::resourceLifecycleConfig))
            .constructor(ApplicationResourceLifecycleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLifecycleConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            DESCRIPTION_FIELD, RESOURCE_LIFECYCLE_CONFIG_FIELD));

    private final String applicationName;

    private final String description;

    private final ApplicationResourceLifecycleConfig resourceLifecycleConfig;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.description = builder.description;
        this.resourceLifecycleConfig = builder.resourceLifecycleConfig;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * <p>
     * Constraint: This name must be unique within your account. If the specified name already exists, the action
     * returns an <code>InvalidParameterValue</code> error.
     * </p>
     * 
     * @return The name of the application.</p>
     *         <p>
     *         Constraint: This name must be unique within your account. If the specified name already exists, the
     *         action returns an <code>InvalidParameterValue</code> error.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Describes the application.
     * </p>
     * 
     * @return Describes the application.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Specify an application resource lifecycle configuration to prevent your application from accumulating too many
     * versions.
     * </p>
     * 
     * @return Specify an application resource lifecycle configuration to prevent your application from accumulating too
     *         many versions.
     */
    public ApplicationResourceLifecycleConfig resourceLifecycleConfig() {
        return resourceLifecycleConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(resourceLifecycleConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName()) && Objects.equals(description(), other.description())
                && Objects.equals(resourceLifecycleConfig(), other.resourceLifecycleConfig());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateApplicationRequest").add("ApplicationName", applicationName())
                .add("Description", description()).add("ResourceLifecycleConfig", resourceLifecycleConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ResourceLifecycleConfig":
            return Optional.ofNullable(clazz.cast(resourceLifecycleConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * The name of the application.
         * </p>
         * <p>
         * Constraint: This name must be unique within your account. If the specified name already exists, the action
         * returns an <code>InvalidParameterValue</code> error.
         * </p>
         * 
         * @param applicationName
         *        The name of the application.</p>
         *        <p>
         *        Constraint: This name must be unique within your account. If the specified name already exists, the
         *        action returns an <code>InvalidParameterValue</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Describes the application.
         * </p>
         * 
         * @param description
         *        Describes the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specify an application resource lifecycle configuration to prevent your application from accumulating too
         * many versions.
         * </p>
         * 
         * @param resourceLifecycleConfig
         *        Specify an application resource lifecycle configuration to prevent your application from accumulating
         *        too many versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig);

        /**
         * <p>
         * Specify an application resource lifecycle configuration to prevent your application from accumulating too
         * many versions.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationResourceLifecycleConfig.Builder}
         * avoiding the need to create one manually via {@link ApplicationResourceLifecycleConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationResourceLifecycleConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceLifecycleConfig(ApplicationResourceLifecycleConfig)}.
         * 
         * @param resourceLifecycleConfig
         *        a consumer that will call methods on {@link ApplicationResourceLifecycleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceLifecycleConfig(ApplicationResourceLifecycleConfig)
         */
        default Builder resourceLifecycleConfig(Consumer<ApplicationResourceLifecycleConfig.Builder> resourceLifecycleConfig) {
            return resourceLifecycleConfig(ApplicationResourceLifecycleConfig.builder().applyMutation(resourceLifecycleConfig)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String description;

        private ApplicationResourceLifecycleConfig resourceLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            applicationName(model.applicationName);
            description(model.description);
            resourceLifecycleConfig(model.resourceLifecycleConfig);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ApplicationResourceLifecycleConfig.Builder getResourceLifecycleConfig() {
            return resourceLifecycleConfig != null ? resourceLifecycleConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig;
            return this;
        }

        public final void setResourceLifecycleConfig(ApplicationResourceLifecycleConfig.BuilderImpl resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig != null ? resourceLifecycleConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
