/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<CreateEnvironmentRequest.Builder, CreateEnvironmentRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentRequest::applicationName)).setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentRequest::environmentName)).setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CNAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentRequest::cnamePrefix)).setter(setter(Builder::cnamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CNAMEPrefix").build()).build();

    private static final SdkField<EnvironmentTier> TIER_FIELD = SdkField.<EnvironmentTier> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateEnvironmentRequest::tier)).setter(setter(Builder::tier)).constructor(EnvironmentTier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateEnvironmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentRequest::versionLabel)).setter(setter(Builder::versionLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentRequest::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentRequest::solutionStackName)).setter(setter(Builder::solutionStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()).build();

    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentRequest::platformArn)).setter(setter(Builder::platformArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()).build();

    private static final SdkField<List<ConfigurationOptionSetting>> OPTION_SETTINGS_FIELD = SdkField
            .<List<ConfigurationOptionSetting>> builder(MarshallingType.LIST)
            .getter(getter(CreateEnvironmentRequest::optionSettings))
            .setter(setter(Builder::optionSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationOptionSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationOptionSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OptionSpecification>> OPTIONS_TO_REMOVE_FIELD = SdkField
            .<List<OptionSpecification>> builder(MarshallingType.LIST)
            .getter(getter(CreateEnvironmentRequest::optionsToRemove))
            .setter(setter(Builder::optionsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OptionSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptionSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            ENVIRONMENT_NAME_FIELD, GROUP_NAME_FIELD, DESCRIPTION_FIELD, CNAME_PREFIX_FIELD, TIER_FIELD, TAGS_FIELD,
            VERSION_LABEL_FIELD, TEMPLATE_NAME_FIELD, SOLUTION_STACK_NAME_FIELD, PLATFORM_ARN_FIELD, OPTION_SETTINGS_FIELD,
            OPTIONS_TO_REMOVE_FIELD));

    private final String applicationName;

    private final String environmentName;

    private final String groupName;

    private final String description;

    private final String cnamePrefix;

    private final EnvironmentTier tier;

    private final List<Tag> tags;

    private final String versionLabel;

    private final String templateName;

    private final String solutionStackName;

    private final String platformArn;

    private final List<ConfigurationOptionSetting> optionSettings;

    private final List<OptionSpecification> optionsToRemove;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.environmentName = builder.environmentName;
        this.groupName = builder.groupName;
        this.description = builder.description;
        this.cnamePrefix = builder.cnamePrefix;
        this.tier = builder.tier;
        this.tags = builder.tags;
        this.versionLabel = builder.versionLabel;
        this.templateName = builder.templateName;
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.optionSettings = builder.optionSettings;
        this.optionsToRemove = builder.optionsToRemove;
    }

    /**
     * <p>
     * The name of the application that contains the version to be deployed.
     * </p>
     * <p>
     * If no application is found with this name, <code>CreateEnvironment</code> returns an
     * <code>InvalidParameterValue</code> error.
     * </p>
     * 
     * @return The name of the application that contains the version to be deployed.</p>
     *         <p>
     *         If no application is found with this name, <code>CreateEnvironment</code> returns an
     *         <code>InvalidParameterValue</code> error.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * A unique name for the deployment environment. Used in the application URL.
     * </p>
     * <p>
     * Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and hyphens.
     * It cannot start or end with a hyphen. This name must be unique within a region in your account. If the specified
     * name already exists in the region, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.
     * </p>
     * <p>
     * Default: If the CNAME parameter is not specified, the environment name becomes part of the CNAME, and therefore
     * part of the visible URL for your application.
     * </p>
     * 
     * @return A unique name for the deployment environment. Used in the application URL.</p>
     *         <p>
     *         Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and
     *         hyphens. It cannot start or end with a hyphen. This name must be unique within a region in your account.
     *         If the specified name already exists in the region, AWS Elastic Beanstalk returns an
     *         <code>InvalidParameterValue</code> error.
     *         </p>
     *         <p>
     *         Default: If the CNAME parameter is not specified, the environment name becomes part of the CNAME, and
     *         therefore part of the visible URL for your application.
     */
    public String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The name of the group to which the target environment belongs. Specify a group name only if the environment's
     * name is specified in an environment manifest and not with the environment name parameter. See <a
     * href="http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest
     * (env.yaml)</a> for details.
     * </p>
     * 
     * @return The name of the group to which the target environment belongs. Specify a group name only if the
     *         environment's name is specified in an environment manifest and not with the environment name parameter.
     *         See <a
     *         href="http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment
     *         Manifest (env.yaml)</a> for details.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * Describes this environment.
     * </p>
     * 
     * @return Describes this environment.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * If specified, the environment attempts to use this value as the prefix for the CNAME. If not specified, the CNAME
     * is generated automatically by appending a random alphanumeric string to the environment name.
     * </p>
     * 
     * @return If specified, the environment attempts to use this value as the prefix for the CNAME. If not specified,
     *         the CNAME is generated automatically by appending a random alphanumeric string to the environment name.
     */
    public String cnamePrefix() {
        return cnamePrefix;
    }

    /**
     * <p>
     * This specifies the tier to use for creating this environment.
     * </p>
     * 
     * @return This specifies the tier to use for creating this environment.
     */
    public EnvironmentTier tier() {
        return tier;
    }

    /**
     * <p>
     * This specifies the tags applied to resources in the environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return This specifies the tags applied to resources in the environment.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the application version to deploy.
     * </p>
     * <p>
     * If the specified application has no associated application versions, AWS Elastic Beanstalk
     * <code>UpdateEnvironment</code> returns an <code>InvalidParameterValue</code> error.
     * </p>
     * <p>
     * Default: If not specified, AWS Elastic Beanstalk attempts to launch the sample application in the container.
     * </p>
     * 
     * @return The name of the application version to deploy.</p>
     *         <p>
     *         If the specified application has no associated application versions, AWS Elastic Beanstalk
     *         <code>UpdateEnvironment</code> returns an <code>InvalidParameterValue</code> error.
     *         </p>
     *         <p>
     *         Default: If not specified, AWS Elastic Beanstalk attempts to launch the sample application in the
     *         container.
     */
    public String versionLabel() {
        return versionLabel;
    }

    /**
     * <p>
     * The name of the configuration template to use in deployment. If no configuration template is found with this
     * name, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.
     * </p>
     * 
     * @return The name of the configuration template to use in deployment. If no configuration template is found with
     *         this name, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * This is an alternative to specifying a template name. If specified, AWS Elastic Beanstalk sets the configuration
     * values to the default values associated with the specified solution stack.
     * </p>
     * <p>
     * For a list of current solution stacks, see <a
     * href="http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Elastic Beanstalk Supported
     * Platforms</a>.
     * </p>
     * 
     * @return This is an alternative to specifying a template name. If specified, AWS Elastic Beanstalk sets the
     *         configuration values to the default values associated with the specified solution stack.</p>
     *         <p>
     *         For a list of current solution stacks, see <a
     *         href="http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Elastic Beanstalk
     *         Supported Platforms</a>.
     */
    public String solutionStackName() {
        return solutionStackName;
    }

    /**
     * <p>
     * The ARN of the platform.
     * </p>
     * 
     * @return The ARN of the platform.
     */
    public String platformArn() {
        return platformArn;
    }

    /**
     * <p>
     * If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the
     * configuration set for the new environment. These override the values obtained from the solution stack or the
     * configuration template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in
     *         the configuration set for the new environment. These override the values obtained from the solution stack
     *         or the configuration template.
     */
    public List<ConfigurationOptionSetting> optionSettings() {
        return optionSettings;
    }

    /**
     * <p>
     * A list of custom user-defined configuration options to remove from the configuration set for this new
     * environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of custom user-defined configuration options to remove from the configuration set for this new
     *         environment.
     */
    public List<OptionSpecification> optionsToRemove() {
        return optionsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(cnamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(tier());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(optionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(optionsToRemove());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(environmentName(), other.environmentName()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(description(), other.description()) && Objects.equals(cnamePrefix(), other.cnamePrefix())
                && Objects.equals(tier(), other.tier()) && Objects.equals(tags(), other.tags())
                && Objects.equals(versionLabel(), other.versionLabel()) && Objects.equals(templateName(), other.templateName())
                && Objects.equals(solutionStackName(), other.solutionStackName())
                && Objects.equals(platformArn(), other.platformArn()) && Objects.equals(optionSettings(), other.optionSettings())
                && Objects.equals(optionsToRemove(), other.optionsToRemove());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateEnvironmentRequest").add("ApplicationName", applicationName())
                .add("EnvironmentName", environmentName()).add("GroupName", groupName()).add("Description", description())
                .add("CNAMEPrefix", cnamePrefix()).add("Tier", tier()).add("Tags", tags()).add("VersionLabel", versionLabel())
                .add("TemplateName", templateName()).add("SolutionStackName", solutionStackName())
                .add("PlatformArn", platformArn()).add("OptionSettings", optionSettings())
                .add("OptionsToRemove", optionsToRemove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CNAMEPrefix":
            return Optional.ofNullable(clazz.cast(cnamePrefix()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tier()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VersionLabel":
            return Optional.ofNullable(clazz.cast(versionLabel()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "SolutionStackName":
            return Optional.ofNullable(clazz.cast(solutionStackName()));
        case "PlatformArn":
            return Optional.ofNullable(clazz.cast(platformArn()));
        case "OptionSettings":
            return Optional.ofNullable(clazz.cast(optionSettings()));
        case "OptionsToRemove":
            return Optional.ofNullable(clazz.cast(optionsToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentRequest> {
        /**
         * <p>
         * The name of the application that contains the version to be deployed.
         * </p>
         * <p>
         * If no application is found with this name, <code>CreateEnvironment</code> returns an
         * <code>InvalidParameterValue</code> error.
         * </p>
         * 
         * @param applicationName
         *        The name of the application that contains the version to be deployed.</p>
         *        <p>
         *        If no application is found with this name, <code>CreateEnvironment</code> returns an
         *        <code>InvalidParameterValue</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * A unique name for the deployment environment. Used in the application URL.
         * </p>
         * <p>
         * Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and
         * hyphens. It cannot start or end with a hyphen. This name must be unique within a region in your account. If
         * the specified name already exists in the region, AWS Elastic Beanstalk returns an
         * <code>InvalidParameterValue</code> error.
         * </p>
         * <p>
         * Default: If the CNAME parameter is not specified, the environment name becomes part of the CNAME, and
         * therefore part of the visible URL for your application.
         * </p>
         * 
         * @param environmentName
         *        A unique name for the deployment environment. Used in the application URL.</p>
         *        <p>
         *        Constraint: Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and
         *        hyphens. It cannot start or end with a hyphen. This name must be unique within a region in your
         *        account. If the specified name already exists in the region, AWS Elastic Beanstalk returns an
         *        <code>InvalidParameterValue</code> error.
         *        </p>
         *        <p>
         *        Default: If the CNAME parameter is not specified, the environment name becomes part of the CNAME, and
         *        therefore part of the visible URL for your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The name of the group to which the target environment belongs. Specify a group name only if the environment's
         * name is specified in an environment manifest and not with the environment name parameter. See <a
         * href="http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment
         * Manifest (env.yaml)</a> for details.
         * </p>
         * 
         * @param groupName
         *        The name of the group to which the target environment belongs. Specify a group name only if the
         *        environment's name is specified in an environment manifest and not with the environment name
         *        parameter. See <a
         *        href="http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment
         *        Manifest (env.yaml)</a> for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * Describes this environment.
         * </p>
         * 
         * @param description
         *        Describes this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If specified, the environment attempts to use this value as the prefix for the CNAME. If not specified, the
         * CNAME is generated automatically by appending a random alphanumeric string to the environment name.
         * </p>
         * 
         * @param cnamePrefix
         *        If specified, the environment attempts to use this value as the prefix for the CNAME. If not
         *        specified, the CNAME is generated automatically by appending a random alphanumeric string to the
         *        environment name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cnamePrefix(String cnamePrefix);

        /**
         * <p>
         * This specifies the tier to use for creating this environment.
         * </p>
         * 
         * @param tier
         *        This specifies the tier to use for creating this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tier(EnvironmentTier tier);

        /**
         * <p>
         * This specifies the tier to use for creating this environment.
         * </p>
         * This is a convenience that creates an instance of the {@link EnvironmentTier.Builder} avoiding the need to
         * create one manually via {@link EnvironmentTier#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnvironmentTier.Builder#build()} is called immediately and its
         * result is passed to {@link #tier(EnvironmentTier)}.
         * 
         * @param tier
         *        a consumer that will call methods on {@link EnvironmentTier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tier(EnvironmentTier)
         */
        default Builder tier(Consumer<EnvironmentTier.Builder> tier) {
            return tier(EnvironmentTier.builder().applyMutation(tier).build());
        }

        /**
         * <p>
         * This specifies the tags applied to resources in the environment.
         * </p>
         * 
         * @param tags
         *        This specifies the tags applied to resources in the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * This specifies the tags applied to resources in the environment.
         * </p>
         * 
         * @param tags
         *        This specifies the tags applied to resources in the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * This specifies the tags applied to resources in the environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The name of the application version to deploy.
         * </p>
         * <p>
         * If the specified application has no associated application versions, AWS Elastic Beanstalk
         * <code>UpdateEnvironment</code> returns an <code>InvalidParameterValue</code> error.
         * </p>
         * <p>
         * Default: If not specified, AWS Elastic Beanstalk attempts to launch the sample application in the container.
         * </p>
         * 
         * @param versionLabel
         *        The name of the application version to deploy.</p>
         *        <p>
         *        If the specified application has no associated application versions, AWS Elastic Beanstalk
         *        <code>UpdateEnvironment</code> returns an <code>InvalidParameterValue</code> error.
         *        </p>
         *        <p>
         *        Default: If not specified, AWS Elastic Beanstalk attempts to launch the sample application in the
         *        container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionLabel(String versionLabel);

        /**
         * <p>
         * The name of the configuration template to use in deployment. If no configuration template is found with this
         * name, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.
         * </p>
         * 
         * @param templateName
         *        The name of the configuration template to use in deployment. If no configuration template is found
         *        with this name, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * This is an alternative to specifying a template name. If specified, AWS Elastic Beanstalk sets the
         * configuration values to the default values associated with the specified solution stack.
         * </p>
         * <p>
         * For a list of current solution stacks, see <a
         * href="http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Elastic Beanstalk
         * Supported Platforms</a>.
         * </p>
         * 
         * @param solutionStackName
         *        This is an alternative to specifying a template name. If specified, AWS Elastic Beanstalk sets the
         *        configuration values to the default values associated with the specified solution stack.</p>
         *        <p>
         *        For a list of current solution stacks, see <a
         *        href="http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Elastic Beanstalk
         *        Supported Platforms</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionStackName(String solutionStackName);

        /**
         * <p>
         * The ARN of the platform.
         * </p>
         * 
         * @param platformArn
         *        The ARN of the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformArn(String platformArn);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the
         * configuration set for the new environment. These override the values obtained from the solution stack or the
         * configuration template.
         * </p>
         * 
         * @param optionSettings
         *        If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in
         *        the configuration set for the new environment. These override the values obtained from the solution
         *        stack or the configuration template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the
         * configuration set for the new environment. These override the values obtained from the solution stack or the
         * configuration template.
         * </p>
         * 
         * @param optionSettings
         *        If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in
         *        the configuration set for the new environment. These override the values obtained from the solution
         *        stack or the configuration template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(ConfigurationOptionSetting... optionSettings);

        /**
         * <p>
         * If specified, AWS Elastic Beanstalk sets the specified configuration options to the requested value in the
         * configuration set for the new environment. These override the values obtained from the solution stack or the
         * configuration template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationOptionSetting>.Builder}
         * avoiding the need to create one manually via {@link List<ConfigurationOptionSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationOptionSetting>.Builder#build()} is called
         * immediately and its result is passed to {@link #optionSettings(List<ConfigurationOptionSetting>)}.
         * 
         * @param optionSettings
         *        a consumer that will call methods on {@link List<ConfigurationOptionSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionSettings(List<ConfigurationOptionSetting>)
         */
        Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder>... optionSettings);

        /**
         * <p>
         * A list of custom user-defined configuration options to remove from the configuration set for this new
         * environment.
         * </p>
         * 
         * @param optionsToRemove
         *        A list of custom user-defined configuration options to remove from the configuration set for this new
         *        environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsToRemove(Collection<OptionSpecification> optionsToRemove);

        /**
         * <p>
         * A list of custom user-defined configuration options to remove from the configuration set for this new
         * environment.
         * </p>
         * 
         * @param optionsToRemove
         *        A list of custom user-defined configuration options to remove from the configuration set for this new
         *        environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsToRemove(OptionSpecification... optionsToRemove);

        /**
         * <p>
         * A list of custom user-defined configuration options to remove from the configuration set for this new
         * environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OptionSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<OptionSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OptionSpecification>.Builder#build()} is called immediately
         * and its result is passed to {@link #optionsToRemove(List<OptionSpecification>)}.
         * 
         * @param optionsToRemove
         *        a consumer that will call methods on {@link List<OptionSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionsToRemove(List<OptionSpecification>)
         */
        Builder optionsToRemove(Consumer<OptionSpecification.Builder>... optionsToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String environmentName;

        private String groupName;

        private String description;

        private String cnamePrefix;

        private EnvironmentTier tier;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String versionLabel;

        private String templateName;

        private String solutionStackName;

        private String platformArn;

        private List<ConfigurationOptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();

        private List<OptionSpecification> optionsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            applicationName(model.applicationName);
            environmentName(model.environmentName);
            groupName(model.groupName);
            description(model.description);
            cnamePrefix(model.cnamePrefix);
            tier(model.tier);
            tags(model.tags);
            versionLabel(model.versionLabel);
            templateName(model.templateName);
            solutionStackName(model.solutionStackName);
            platformArn(model.platformArn);
            optionSettings(model.optionSettings);
            optionsToRemove(model.optionsToRemove);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCnamePrefix() {
            return cnamePrefix;
        }

        @Override
        public final Builder cnamePrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
            return this;
        }

        public final void setCnamePrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
        }

        public final EnvironmentTier.Builder getTier() {
            return tier != null ? tier.toBuilder() : null;
        }

        @Override
        public final Builder tier(EnvironmentTier tier) {
            this.tier = tier;
            return this;
        }

        public final void setTier(EnvironmentTier.BuilderImpl tier) {
            this.tier = tier != null ? tier.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getVersionLabel() {
            return versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getSolutionStackName() {
            return solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final Collection<ConfigurationOptionSetting.Builder> getOptionSettings() {
            return optionSettings != null ? optionSettings.stream().map(ConfigurationOptionSetting::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting... optionSettings) {
            optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder>... optionSettings) {
            optionSettings(Stream.of(optionSettings).map(c -> ConfigurationOptionSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copyFromBuilder(optionSettings);
        }

        public final Collection<OptionSpecification.Builder> getOptionsToRemove() {
            return optionsToRemove != null ? optionsToRemove.stream().map(OptionSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionsToRemove(Collection<OptionSpecification> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copy(optionsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToRemove(OptionSpecification... optionsToRemove) {
            optionsToRemove(Arrays.asList(optionsToRemove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToRemove(Consumer<OptionSpecification.Builder>... optionsToRemove) {
            optionsToRemove(Stream.of(optionsToRemove).map(c -> OptionSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOptionsToRemove(Collection<OptionSpecification.BuilderImpl> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copyFromBuilder(optionsToRemove);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
