/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result message containing a list of application version descriptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationOptionsRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<DescribeConfigurationOptionsRequest.Builder, DescribeConfigurationOptionsRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeConfigurationOptionsRequest::applicationName)).setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeConfigurationOptionsRequest::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeConfigurationOptionsRequest::environmentName)).setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeConfigurationOptionsRequest::solutionStackName)).setter(setter(Builder::solutionStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()).build();

    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeConfigurationOptionsRequest::platformArn)).setter(setter(Builder::platformArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()).build();

    private static final SdkField<List<OptionSpecification>> OPTIONS_FIELD = SdkField
            .<List<OptionSpecification>> builder(MarshallingType.LIST)
            .getter(getter(DescribeConfigurationOptionsRequest::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OptionSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptionSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            TEMPLATE_NAME_FIELD, ENVIRONMENT_NAME_FIELD, SOLUTION_STACK_NAME_FIELD, PLATFORM_ARN_FIELD, OPTIONS_FIELD));

    private final String applicationName;

    private final String templateName;

    private final String environmentName;

    private final String solutionStackName;

    private final String platformArn;

    private final List<OptionSpecification> options;

    private DescribeConfigurationOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.environmentName = builder.environmentName;
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.options = builder.options;
    }

    /**
     * <p>
     * The name of the application associated with the configuration template or environment. Only needed if you want to
     * describe the configuration options associated with either the configuration template or environment.
     * </p>
     * 
     * @return The name of the application associated with the configuration template or environment. Only needed if you
     *         want to describe the configuration options associated with either the configuration template or
     *         environment.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The name of the configuration template whose configuration options you want to describe.
     * </p>
     * 
     * @return The name of the configuration template whose configuration options you want to describe.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The name of the environment whose configuration options you want to describe.
     * </p>
     * 
     * @return The name of the environment whose configuration options you want to describe.
     */
    public String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The name of the solution stack whose configuration options you want to describe.
     * </p>
     * 
     * @return The name of the solution stack whose configuration options you want to describe.
     */
    public String solutionStackName() {
        return solutionStackName;
    }

    /**
     * <p>
     * The ARN of the custom platform.
     * </p>
     * 
     * @return The ARN of the custom platform.
     */
    public String platformArn() {
        return platformArn;
    }

    /**
     * <p>
     * If specified, restricts the descriptions to only the specified options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return If specified, restricts the descriptions to only the specified options.
     */
    public List<OptionSpecification> options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationOptionsRequest)) {
            return false;
        }
        DescribeConfigurationOptionsRequest other = (DescribeConfigurationOptionsRequest) obj;
        return Objects.equals(applicationName(), other.applicationName()) && Objects.equals(templateName(), other.templateName())
                && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(solutionStackName(), other.solutionStackName())
                && Objects.equals(platformArn(), other.platformArn()) && Objects.equals(options(), other.options());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeConfigurationOptionsRequest").add("ApplicationName", applicationName())
                .add("TemplateName", templateName()).add("EnvironmentName", environmentName())
                .add("SolutionStackName", solutionStackName()).add("PlatformArn", platformArn()).add("Options", options())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "SolutionStackName":
            return Optional.ofNullable(clazz.cast(solutionStackName()));
        case "PlatformArn":
            return Optional.ofNullable(clazz.cast(platformArn()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationOptionsRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationOptionsRequest> {
        /**
         * <p>
         * The name of the application associated with the configuration template or environment. Only needed if you
         * want to describe the configuration options associated with either the configuration template or environment.
         * </p>
         * 
         * @param applicationName
         *        The name of the application associated with the configuration template or environment. Only needed if
         *        you want to describe the configuration options associated with either the configuration template or
         *        environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The name of the configuration template whose configuration options you want to describe.
         * </p>
         * 
         * @param templateName
         *        The name of the configuration template whose configuration options you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The name of the environment whose configuration options you want to describe.
         * </p>
         * 
         * @param environmentName
         *        The name of the environment whose configuration options you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The name of the solution stack whose configuration options you want to describe.
         * </p>
         * 
         * @param solutionStackName
         *        The name of the solution stack whose configuration options you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionStackName(String solutionStackName);

        /**
         * <p>
         * The ARN of the custom platform.
         * </p>
         * 
         * @param platformArn
         *        The ARN of the custom platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformArn(String platformArn);

        /**
         * <p>
         * If specified, restricts the descriptions to only the specified options.
         * </p>
         * 
         * @param options
         *        If specified, restricts the descriptions to only the specified options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<OptionSpecification> options);

        /**
         * <p>
         * If specified, restricts the descriptions to only the specified options.
         * </p>
         * 
         * @param options
         *        If specified, restricts the descriptions to only the specified options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(OptionSpecification... options);

        /**
         * <p>
         * If specified, restricts the descriptions to only the specified options.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OptionSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<OptionSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OptionSpecification>.Builder#build()} is called immediately
         * and its result is passed to {@link #options(List<OptionSpecification>)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link List<OptionSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(List<OptionSpecification>)
         */
        Builder options(Consumer<OptionSpecification.Builder>... options);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String templateName;

        private String environmentName;

        private String solutionStackName;

        private String platformArn;

        private List<OptionSpecification> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationOptionsRequest model) {
            super(model);
            applicationName(model.applicationName);
            templateName(model.templateName);
            environmentName(model.environmentName);
            solutionStackName(model.solutionStackName);
            platformArn(model.platformArn);
            options(model.options);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getSolutionStackName() {
            return solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final Collection<OptionSpecification.Builder> getOptions() {
            return options != null ? options.stream().map(OptionSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder options(Collection<OptionSpecification> options) {
            this.options = OptionsSpecifierListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(OptionSpecification... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<OptionSpecification.Builder>... options) {
            options(Stream.of(options).map(c -> OptionSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOptions(Collection<OptionSpecification.BuilderImpl> options) {
            this.options = OptionsSpecifierListCopier.copyFromBuilder(options);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationOptionsRequest build() {
            return new DescribeConfigurationOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
