/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The results from a request to change the configuration settings of an environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationSettingsResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<DescribeConfigurationSettingsResponse.Builder, DescribeConfigurationSettingsResponse> {
    private static final SdkField<List<ConfigurationSettingsDescription>> CONFIGURATION_SETTINGS_FIELD = SdkField
            .<List<ConfigurationSettingsDescription>> builder(MarshallingType.LIST)
            .getter(getter(DescribeConfigurationSettingsResponse::configurationSettings))
            .setter(setter(Builder::configurationSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationSettingsDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationSettingsDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SETTINGS_FIELD));

    private final List<ConfigurationSettingsDescription> configurationSettings;

    private DescribeConfigurationSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSettings = builder.configurationSettings;
    }

    /**
     * <p>
     * A list of <a>ConfigurationSettingsDescription</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <a>ConfigurationSettingsDescription</a>.
     */
    public List<ConfigurationSettingsDescription> configurationSettings() {
        return configurationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSettingsResponse)) {
            return false;
        }
        DescribeConfigurationSettingsResponse other = (DescribeConfigurationSettingsResponse) obj;
        return Objects.equals(configurationSettings(), other.configurationSettings());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeConfigurationSettingsResponse").add("ConfigurationSettings", configurationSettings())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSettings":
            return Optional.ofNullable(clazz.cast(configurationSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationSettingsResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationSettingsResponse> {
        /**
         * <p>
         * A list of <a>ConfigurationSettingsDescription</a>.
         * </p>
         * 
         * @param configurationSettings
         *        A list of <a>ConfigurationSettingsDescription</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSettings(Collection<ConfigurationSettingsDescription> configurationSettings);

        /**
         * <p>
         * A list of <a>ConfigurationSettingsDescription</a>.
         * </p>
         * 
         * @param configurationSettings
         *        A list of <a>ConfigurationSettingsDescription</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSettings(ConfigurationSettingsDescription... configurationSettings);

        /**
         * <p>
         * A list of <a>ConfigurationSettingsDescription</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationSettingsDescription>.Builder}
         * avoiding the need to create one manually via {@link List<ConfigurationSettingsDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationSettingsDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #configurationSettings(List<ConfigurationSettingsDescription>)}.
         * 
         * @param configurationSettings
         *        a consumer that will call methods on {@link List<ConfigurationSettingsDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationSettings(List<ConfigurationSettingsDescription>)
         */
        Builder configurationSettings(Consumer<ConfigurationSettingsDescription.Builder>... configurationSettings);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<ConfigurationSettingsDescription> configurationSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSettingsResponse model) {
            super(model);
            configurationSettings(model.configurationSettings);
        }

        public final Collection<ConfigurationSettingsDescription.Builder> getConfigurationSettings() {
            return configurationSettings != null ? configurationSettings.stream()
                    .map(ConfigurationSettingsDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationSettings(Collection<ConfigurationSettingsDescription> configurationSettings) {
            this.configurationSettings = ConfigurationSettingsDescriptionListCopier.copy(configurationSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSettings(ConfigurationSettingsDescription... configurationSettings) {
            configurationSettings(Arrays.asList(configurationSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSettings(Consumer<ConfigurationSettingsDescription.Builder>... configurationSettings) {
            configurationSettings(Stream.of(configurationSettings)
                    .map(c -> ConfigurationSettingsDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationSettings(Collection<ConfigurationSettingsDescription.BuilderImpl> configurationSettings) {
            this.configurationSettings = ConfigurationSettingsDescriptionListCopier.copyFromBuilder(configurationSettings);
        }

        @Override
        public DescribeConfigurationSettingsResponse build() {
            return new DescribeConfigurationSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
