/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters for a call to <code>DescribeInstancesHealth</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstancesHealthRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<DescribeInstancesHealthRequest.Builder, DescribeInstancesHealthRequest> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInstancesHealthRequest::environmentName)).setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInstancesHealthRequest::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeInstancesHealthRequest::attributeNamesAsStrings))
            .setter(setter(Builder::attributeNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInstancesHealthRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD,
            ENVIRONMENT_ID_FIELD, ATTRIBUTE_NAMES_FIELD, NEXT_TOKEN_FIELD));

    private final String environmentName;

    private final String environmentId;

    private final List<String> attributeNames;

    private final String nextToken;

    private DescribeInstancesHealthRequest(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.environmentId = builder.environmentId;
        this.attributeNames = builder.attributeNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Specify the AWS Elastic Beanstalk environment by name.
     * </p>
     * 
     * @return Specify the AWS Elastic Beanstalk environment by name.
     */
    public String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * Specify the AWS Elastic Beanstalk environment by ID.
     * </p>
     * 
     * @return Specify the AWS Elastic Beanstalk environment by ID.
     */
    public String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>. If no
     * attribute names are specified, returns a list of instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>.
     *         If no attribute names are specified, returns a list of instances.
     */
    public List<InstancesHealthAttribute> attributeNames() {
        return TypeConverter.convert(attributeNames, InstancesHealthAttribute::fromValue);
    }

    /**
     * <p>
     * Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>. If no
     * attribute names are specified, returns a list of instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>.
     *         If no attribute names are specified, returns a list of instances.
     */
    public List<String> attributeNamesAsStrings() {
        return attributeNames;
    }

    /**
     * <p>
     * Specify the pagination token returned by a previous call.
     * </p>
     * 
     * @return Specify the pagination token returned by a previous call.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(attributeNamesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesHealthRequest)) {
            return false;
        }
        DescribeInstancesHealthRequest other = (DescribeInstancesHealthRequest) obj;
        return Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(attributeNamesAsStrings(), other.attributeNamesAsStrings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeInstancesHealthRequest").add("EnvironmentName", environmentName())
                .add("EnvironmentId", environmentId()).add("AttributeNames", attributeNamesAsStrings())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "AttributeNames":
            return Optional.ofNullable(clazz.cast(attributeNamesAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancesHealthRequest, T> g) {
        return obj -> g.apply((DescribeInstancesHealthRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstancesHealthRequest> {
        /**
         * <p>
         * Specify the AWS Elastic Beanstalk environment by name.
         * </p>
         * 
         * @param environmentName
         *        Specify the AWS Elastic Beanstalk environment by name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * Specify the AWS Elastic Beanstalk environment by ID.
         * </p>
         * 
         * @param environmentId
         *        Specify the AWS Elastic Beanstalk environment by ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>. If
         * no attribute names are specified, returns a list of instances.
         * </p>
         * 
         * @param attributeNames
         *        Specifies the response elements you wish to receive. To retrieve all attributes, set to
         *        <code>All</code>. If no attribute names are specified, returns a list of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNamesWithStrings(Collection<String> attributeNames);

        /**
         * <p>
         * Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>. If
         * no attribute names are specified, returns a list of instances.
         * </p>
         * 
         * @param attributeNames
         *        Specifies the response elements you wish to receive. To retrieve all attributes, set to
         *        <code>All</code>. If no attribute names are specified, returns a list of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNamesWithStrings(String... attributeNames);

        /**
         * <p>
         * Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>. If
         * no attribute names are specified, returns a list of instances.
         * </p>
         * 
         * @param attributeNames
         *        Specifies the response elements you wish to receive. To retrieve all attributes, set to
         *        <code>All</code>. If no attribute names are specified, returns a list of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(Collection<InstancesHealthAttribute> attributeNames);

        /**
         * <p>
         * Specifies the response elements you wish to receive. To retrieve all attributes, set to <code>All</code>. If
         * no attribute names are specified, returns a list of instances.
         * </p>
         * 
         * @param attributeNames
         *        Specifies the response elements you wish to receive. To retrieve all attributes, set to
         *        <code>All</code>. If no attribute names are specified, returns a list of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(InstancesHealthAttribute... attributeNames);

        /**
         * <p>
         * Specify the pagination token returned by a previous call.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token returned by a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String environmentName;

        private String environmentId;

        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesHealthRequest model) {
            super(model);
            environmentName(model.environmentName);
            environmentId(model.environmentId);
            attributeNamesWithStrings(model.attributeNames);
            nextToken(model.nextToken);
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final Collection<String> getAttributeNamesAsStrings() {
            return attributeNames;
        }

        @Override
        public final Builder attributeNamesWithStrings(Collection<String> attributeNames) {
            this.attributeNames = InstancesHealthAttributesCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNamesWithStrings(String... attributeNames) {
            attributeNamesWithStrings(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        public final Builder attributeNames(Collection<InstancesHealthAttribute> attributeNames) {
            this.attributeNames = InstancesHealthAttributesCopier.copyEnumToString(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(InstancesHealthAttribute... attributeNames) {
            attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNamesWithStrings(Collection<String> attributeNames) {
            this.attributeNames = InstancesHealthAttributesCopier.copy(attributeNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstancesHealthRequest build() {
            return new DescribeInstancesHealthRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
