/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of available AWS Elastic Beanstalk solution stacks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAvailableSolutionStacksResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<ListAvailableSolutionStacksResponse.Builder, ListAvailableSolutionStacksResponse> {
    private static final SdkField<List<String>> SOLUTION_STACKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListAvailableSolutionStacksResponse::solutionStacks))
            .setter(setter(Builder::solutionStacks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStacks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SolutionStackDescription>> SOLUTION_STACK_DETAILS_FIELD = SdkField
            .<List<SolutionStackDescription>> builder(MarshallingType.LIST)
            .getter(getter(ListAvailableSolutionStacksResponse::solutionStackDetails))
            .setter(setter(Builder::solutionStackDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SolutionStackDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(SolutionStackDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_STACKS_FIELD,
            SOLUTION_STACK_DETAILS_FIELD));

    private final List<String> solutionStacks;

    private final List<SolutionStackDescription> solutionStackDetails;

    private ListAvailableSolutionStacksResponse(BuilderImpl builder) {
        super(builder);
        this.solutionStacks = builder.solutionStacks;
        this.solutionStackDetails = builder.solutionStackDetails;
    }

    /**
     * <p>
     * A list of available solution stacks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of available solution stacks.
     */
    public List<String> solutionStacks() {
        return solutionStacks;
    }

    /**
     * <p>
     * A list of available solution stacks and their <a>SolutionStackDescription</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of available solution stacks and their <a>SolutionStackDescription</a>.
     */
    public List<SolutionStackDescription> solutionStackDetails() {
        return solutionStackDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(solutionStacks());
        hashCode = 31 * hashCode + Objects.hashCode(solutionStackDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableSolutionStacksResponse)) {
            return false;
        }
        ListAvailableSolutionStacksResponse other = (ListAvailableSolutionStacksResponse) obj;
        return Objects.equals(solutionStacks(), other.solutionStacks())
                && Objects.equals(solutionStackDetails(), other.solutionStackDetails());
    }

    @Override
    public String toString() {
        return ToString.builder("ListAvailableSolutionStacksResponse").add("SolutionStacks", solutionStacks())
                .add("SolutionStackDetails", solutionStackDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SolutionStacks":
            return Optional.ofNullable(clazz.cast(solutionStacks()));
        case "SolutionStackDetails":
            return Optional.ofNullable(clazz.cast(solutionStackDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableSolutionStacksResponse, T> g) {
        return obj -> g.apply((ListAvailableSolutionStacksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAvailableSolutionStacksResponse> {
        /**
         * <p>
         * A list of available solution stacks.
         * </p>
         * 
         * @param solutionStacks
         *        A list of available solution stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionStacks(Collection<String> solutionStacks);

        /**
         * <p>
         * A list of available solution stacks.
         * </p>
         * 
         * @param solutionStacks
         *        A list of available solution stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionStacks(String... solutionStacks);

        /**
         * <p>
         * A list of available solution stacks and their <a>SolutionStackDescription</a>.
         * </p>
         * 
         * @param solutionStackDetails
         *        A list of available solution stacks and their <a>SolutionStackDescription</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionStackDetails(Collection<SolutionStackDescription> solutionStackDetails);

        /**
         * <p>
         * A list of available solution stacks and their <a>SolutionStackDescription</a>.
         * </p>
         * 
         * @param solutionStackDetails
         *        A list of available solution stacks and their <a>SolutionStackDescription</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionStackDetails(SolutionStackDescription... solutionStackDetails);

        /**
         * <p>
         * A list of available solution stacks and their <a>SolutionStackDescription</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SolutionStackDescription>.Builder} avoiding
         * the need to create one manually via {@link List<SolutionStackDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SolutionStackDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #solutionStackDetails(List<SolutionStackDescription>)}.
         * 
         * @param solutionStackDetails
         *        a consumer that will call methods on {@link List<SolutionStackDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #solutionStackDetails(List<SolutionStackDescription>)
         */
        Builder solutionStackDetails(Consumer<SolutionStackDescription.Builder>... solutionStackDetails);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<String> solutionStacks = DefaultSdkAutoConstructList.getInstance();

        private List<SolutionStackDescription> solutionStackDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableSolutionStacksResponse model) {
            super(model);
            solutionStacks(model.solutionStacks);
            solutionStackDetails(model.solutionStackDetails);
        }

        public final Collection<String> getSolutionStacks() {
            return solutionStacks;
        }

        @Override
        public final Builder solutionStacks(Collection<String> solutionStacks) {
            this.solutionStacks = AvailableSolutionStackNamesListCopier.copy(solutionStacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionStacks(String... solutionStacks) {
            solutionStacks(Arrays.asList(solutionStacks));
            return this;
        }

        public final void setSolutionStacks(Collection<String> solutionStacks) {
            this.solutionStacks = AvailableSolutionStackNamesListCopier.copy(solutionStacks);
        }

        public final Collection<SolutionStackDescription.Builder> getSolutionStackDetails() {
            return solutionStackDetails != null ? solutionStackDetails.stream().map(SolutionStackDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder solutionStackDetails(Collection<SolutionStackDescription> solutionStackDetails) {
            this.solutionStackDetails = AvailableSolutionStackDetailsListCopier.copy(solutionStackDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionStackDetails(SolutionStackDescription... solutionStackDetails) {
            solutionStackDetails(Arrays.asList(solutionStackDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionStackDetails(Consumer<SolutionStackDescription.Builder>... solutionStackDetails) {
            solutionStackDetails(Stream.of(solutionStackDetails)
                    .map(c -> SolutionStackDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSolutionStackDetails(Collection<SolutionStackDescription.BuilderImpl> solutionStackDetails) {
            this.solutionStackDetails = AvailableSolutionStackDetailsListCopier.copyFromBuilder(solutionStackDetails);
        }

        @Override
        public ListAvailableSolutionStacksResponse build() {
            return new ListAvailableSolutionStacksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
