/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A specification identifying an individual configuration option.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptionSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<OptionSpecification.Builder, OptionSpecification> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OptionSpecification::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OptionSpecification::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> OPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OptionSpecification::optionName)).setter(setter(Builder::optionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD,
            NAMESPACE_FIELD, OPTION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceName;

    private final String namespace;

    private final String optionName;

    private OptionSpecification(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.namespace = builder.namespace;
        this.optionName = builder.optionName;
    }

    /**
     * <p>
     * A unique resource name for a time-based scaling configuration option.
     * </p>
     * 
     * @return A unique resource name for a time-based scaling configuration option.
     */
    public String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * A unique namespace identifying the option's associated AWS resource.
     * </p>
     * 
     * @return A unique namespace identifying the option's associated AWS resource.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the configuration option.
     * </p>
     * 
     * @return The name of the configuration option.
     */
    public String optionName() {
        return optionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(optionName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionSpecification)) {
            return false;
        }
        OptionSpecification other = (OptionSpecification) obj;
        return Objects.equals(resourceName(), other.resourceName()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(optionName(), other.optionName());
    }

    @Override
    public String toString() {
        return ToString.builder("OptionSpecification").add("ResourceName", resourceName()).add("Namespace", namespace())
                .add("OptionName", optionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "OptionName":
            return Optional.ofNullable(clazz.cast(optionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptionSpecification, T> g) {
        return obj -> g.apply((OptionSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptionSpecification> {
        /**
         * <p>
         * A unique resource name for a time-based scaling configuration option.
         * </p>
         * 
         * @param resourceName
         *        A unique resource name for a time-based scaling configuration option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * A unique namespace identifying the option's associated AWS resource.
         * </p>
         * 
         * @param namespace
         *        A unique namespace identifying the option's associated AWS resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the configuration option.
         * </p>
         * 
         * @param optionName
         *        The name of the configuration option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionName(String optionName);
    }

    static final class BuilderImpl implements Builder {
        private String resourceName;

        private String namespace;

        private String optionName;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionSpecification model) {
            resourceName(model.resourceName);
            namespace(model.namespace);
            optionName(model.optionName);
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getOptionName() {
            return optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        @Override
        public OptionSpecification build() {
            return new OptionSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
