/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a platform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlatformSummary implements SdkPojo, Serializable, ToCopyableBuilder<PlatformSummary.Builder, PlatformSummary> {
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformSummary::platformArn)).setter(setter(Builder::platformArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()).build();

    private static final SdkField<String> PLATFORM_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformSummary::platformOwner)).setter(setter(Builder::platformOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformOwner").build()).build();

    private static final SdkField<String> PLATFORM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformSummary::platformStatusAsString)).setter(setter(Builder::platformStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformStatus").build()).build();

    private static final SdkField<String> PLATFORM_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformSummary::platformCategory)).setter(setter(Builder::platformCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformCategory").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformSummary::operatingSystemName)).setter(setter(Builder::operatingSystemName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemName").build())
            .build();

    private static final SdkField<String> OPERATING_SYSTEM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformSummary::operatingSystemVersion)).setter(setter(Builder::operatingSystemVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemVersion").build())
            .build();

    private static final SdkField<List<String>> SUPPORTED_TIER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PlatformSummary::supportedTierList))
            .setter(setter(Builder::supportedTierList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTierList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_ADDON_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PlatformSummary::supportedAddonList))
            .setter(setter(Builder::supportedAddonList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAddonList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_ARN_FIELD,
            PLATFORM_OWNER_FIELD, PLATFORM_STATUS_FIELD, PLATFORM_CATEGORY_FIELD, OPERATING_SYSTEM_NAME_FIELD,
            OPERATING_SYSTEM_VERSION_FIELD, SUPPORTED_TIER_LIST_FIELD, SUPPORTED_ADDON_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String platformArn;

    private final String platformOwner;

    private final String platformStatus;

    private final String platformCategory;

    private final String operatingSystemName;

    private final String operatingSystemVersion;

    private final List<String> supportedTierList;

    private final List<String> supportedAddonList;

    private PlatformSummary(BuilderImpl builder) {
        this.platformArn = builder.platformArn;
        this.platformOwner = builder.platformOwner;
        this.platformStatus = builder.platformStatus;
        this.platformCategory = builder.platformCategory;
        this.operatingSystemName = builder.operatingSystemName;
        this.operatingSystemVersion = builder.operatingSystemVersion;
        this.supportedTierList = builder.supportedTierList;
        this.supportedAddonList = builder.supportedAddonList;
    }

    /**
     * <p>
     * The ARN of the platform.
     * </p>
     * 
     * @return The ARN of the platform.
     */
    public String platformArn() {
        return platformArn;
    }

    /**
     * <p>
     * The AWS account ID of the person who created the platform.
     * </p>
     * 
     * @return The AWS account ID of the person who created the platform.
     */
    public String platformOwner() {
        return platformOwner;
    }

    /**
     * <p>
     * The status of the platform. You can create an environment from the platform once it is ready.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformStatus}
     * will return {@link PlatformStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #platformStatusAsString}.
     * </p>
     * 
     * @return The status of the platform. You can create an environment from the platform once it is ready.
     * @see PlatformStatus
     */
    public PlatformStatus platformStatus() {
        return PlatformStatus.fromValue(platformStatus);
    }

    /**
     * <p>
     * The status of the platform. You can create an environment from the platform once it is ready.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformStatus}
     * will return {@link PlatformStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #platformStatusAsString}.
     * </p>
     * 
     * @return The status of the platform. You can create an environment from the platform once it is ready.
     * @see PlatformStatus
     */
    public String platformStatusAsString() {
        return platformStatus;
    }

    /**
     * <p>
     * The category of platform.
     * </p>
     * 
     * @return The category of platform.
     */
    public String platformCategory() {
        return platformCategory;
    }

    /**
     * <p>
     * The operating system used by the platform.
     * </p>
     * 
     * @return The operating system used by the platform.
     */
    public String operatingSystemName() {
        return operatingSystemName;
    }

    /**
     * <p>
     * The version of the operating system used by the platform.
     * </p>
     * 
     * @return The version of the operating system used by the platform.
     */
    public String operatingSystemVersion() {
        return operatingSystemVersion;
    }

    /**
     * <p>
     * The tiers in which the platform runs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tiers in which the platform runs.
     */
    public List<String> supportedTierList() {
        return supportedTierList;
    }

    /**
     * <p>
     * The additions associated with the platform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The additions associated with the platform.
     */
    public List<String> supportedAddonList() {
        return supportedAddonList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(platformOwner());
        hashCode = 31 * hashCode + Objects.hashCode(platformStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformCategory());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemName());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(supportedTierList());
        hashCode = 31 * hashCode + Objects.hashCode(supportedAddonList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformSummary)) {
            return false;
        }
        PlatformSummary other = (PlatformSummary) obj;
        return Objects.equals(platformArn(), other.platformArn()) && Objects.equals(platformOwner(), other.platformOwner())
                && Objects.equals(platformStatusAsString(), other.platformStatusAsString())
                && Objects.equals(platformCategory(), other.platformCategory())
                && Objects.equals(operatingSystemName(), other.operatingSystemName())
                && Objects.equals(operatingSystemVersion(), other.operatingSystemVersion())
                && Objects.equals(supportedTierList(), other.supportedTierList())
                && Objects.equals(supportedAddonList(), other.supportedAddonList());
    }

    @Override
    public String toString() {
        return ToString.builder("PlatformSummary").add("PlatformArn", platformArn()).add("PlatformOwner", platformOwner())
                .add("PlatformStatus", platformStatusAsString()).add("PlatformCategory", platformCategory())
                .add("OperatingSystemName", operatingSystemName()).add("OperatingSystemVersion", operatingSystemVersion())
                .add("SupportedTierList", supportedTierList()).add("SupportedAddonList", supportedAddonList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformArn":
            return Optional.ofNullable(clazz.cast(platformArn()));
        case "PlatformOwner":
            return Optional.ofNullable(clazz.cast(platformOwner()));
        case "PlatformStatus":
            return Optional.ofNullable(clazz.cast(platformStatusAsString()));
        case "PlatformCategory":
            return Optional.ofNullable(clazz.cast(platformCategory()));
        case "OperatingSystemName":
            return Optional.ofNullable(clazz.cast(operatingSystemName()));
        case "OperatingSystemVersion":
            return Optional.ofNullable(clazz.cast(operatingSystemVersion()));
        case "SupportedTierList":
            return Optional.ofNullable(clazz.cast(supportedTierList()));
        case "SupportedAddonList":
            return Optional.ofNullable(clazz.cast(supportedAddonList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlatformSummary, T> g) {
        return obj -> g.apply((PlatformSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlatformSummary> {
        /**
         * <p>
         * The ARN of the platform.
         * </p>
         * 
         * @param platformArn
         *        The ARN of the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformArn(String platformArn);

        /**
         * <p>
         * The AWS account ID of the person who created the platform.
         * </p>
         * 
         * @param platformOwner
         *        The AWS account ID of the person who created the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformOwner(String platformOwner);

        /**
         * <p>
         * The status of the platform. You can create an environment from the platform once it is ready.
         * </p>
         * 
         * @param platformStatus
         *        The status of the platform. You can create an environment from the platform once it is ready.
         * @see PlatformStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformStatus
         */
        Builder platformStatus(String platformStatus);

        /**
         * <p>
         * The status of the platform. You can create an environment from the platform once it is ready.
         * </p>
         * 
         * @param platformStatus
         *        The status of the platform. You can create an environment from the platform once it is ready.
         * @see PlatformStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformStatus
         */
        Builder platformStatus(PlatformStatus platformStatus);

        /**
         * <p>
         * The category of platform.
         * </p>
         * 
         * @param platformCategory
         *        The category of platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformCategory(String platformCategory);

        /**
         * <p>
         * The operating system used by the platform.
         * </p>
         * 
         * @param operatingSystemName
         *        The operating system used by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemName(String operatingSystemName);

        /**
         * <p>
         * The version of the operating system used by the platform.
         * </p>
         * 
         * @param operatingSystemVersion
         *        The version of the operating system used by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemVersion(String operatingSystemVersion);

        /**
         * <p>
         * The tiers in which the platform runs.
         * </p>
         * 
         * @param supportedTierList
         *        The tiers in which the platform runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTierList(Collection<String> supportedTierList);

        /**
         * <p>
         * The tiers in which the platform runs.
         * </p>
         * 
         * @param supportedTierList
         *        The tiers in which the platform runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTierList(String... supportedTierList);

        /**
         * <p>
         * The additions associated with the platform.
         * </p>
         * 
         * @param supportedAddonList
         *        The additions associated with the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAddonList(Collection<String> supportedAddonList);

        /**
         * <p>
         * The additions associated with the platform.
         * </p>
         * 
         * @param supportedAddonList
         *        The additions associated with the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAddonList(String... supportedAddonList);
    }

    static final class BuilderImpl implements Builder {
        private String platformArn;

        private String platformOwner;

        private String platformStatus;

        private String platformCategory;

        private String operatingSystemName;

        private String operatingSystemVersion;

        private List<String> supportedTierList = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedAddonList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformSummary model) {
            platformArn(model.platformArn);
            platformOwner(model.platformOwner);
            platformStatus(model.platformStatus);
            platformCategory(model.platformCategory);
            operatingSystemName(model.operatingSystemName);
            operatingSystemVersion(model.operatingSystemVersion);
            supportedTierList(model.supportedTierList);
            supportedAddonList(model.supportedAddonList);
        }

        public final String getPlatformArn() {
            return platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getPlatformOwner() {
            return platformOwner;
        }

        @Override
        public final Builder platformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
            return this;
        }

        public final void setPlatformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
        }

        public final String getPlatformStatusAsString() {
            return platformStatus;
        }

        @Override
        public final Builder platformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
            return this;
        }

        @Override
        public final Builder platformStatus(PlatformStatus platformStatus) {
            this.platformStatus(platformStatus.toString());
            return this;
        }

        public final void setPlatformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
        }

        public final String getPlatformCategory() {
            return platformCategory;
        }

        @Override
        public final Builder platformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
            return this;
        }

        public final void setPlatformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
        }

        public final String getOperatingSystemName() {
            return operatingSystemName;
        }

        @Override
        public final Builder operatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
            return this;
        }

        public final void setOperatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
        }

        public final String getOperatingSystemVersion() {
            return operatingSystemVersion;
        }

        @Override
        public final Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        public final void setOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
        }

        public final Collection<String> getSupportedTierList() {
            return supportedTierList;
        }

        @Override
        public final Builder supportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTierList(String... supportedTierList) {
            supportedTierList(Arrays.asList(supportedTierList));
            return this;
        }

        public final void setSupportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
        }

        public final Collection<String> getSupportedAddonList() {
            return supportedAddonList;
        }

        @Override
        public final Builder supportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAddonList(String... supportedAddonList) {
            supportedAddonList(Arrays.asList(supportedAddonList));
            return this;
        }

        public final void setSupportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
        }

        @Override
        public PlatformSummary build() {
            return new PlatformSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
