/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the solution stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SolutionStackDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<SolutionStackDescription.Builder, SolutionStackDescription> {
    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SolutionStackDescription::solutionStackName)).setter(setter(Builder::solutionStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()).build();

    private static final SdkField<List<String>> PERMITTED_FILE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SolutionStackDescription::permittedFileTypes))
            .setter(setter(Builder::permittedFileTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermittedFileTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_STACK_NAME_FIELD,
            PERMITTED_FILE_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String solutionStackName;

    private final List<String> permittedFileTypes;

    private SolutionStackDescription(BuilderImpl builder) {
        this.solutionStackName = builder.solutionStackName;
        this.permittedFileTypes = builder.permittedFileTypes;
    }

    /**
     * <p>
     * The name of the solution stack.
     * </p>
     * 
     * @return The name of the solution stack.
     */
    public String solutionStackName() {
        return solutionStackName;
    }

    /**
     * <p>
     * The permitted file types allowed for a solution stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The permitted file types allowed for a solution stack.
     */
    public List<String> permittedFileTypes() {
        return permittedFileTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(permittedFileTypes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionStackDescription)) {
            return false;
        }
        SolutionStackDescription other = (SolutionStackDescription) obj;
        return Objects.equals(solutionStackName(), other.solutionStackName())
                && Objects.equals(permittedFileTypes(), other.permittedFileTypes());
    }

    @Override
    public String toString() {
        return ToString.builder("SolutionStackDescription").add("SolutionStackName", solutionStackName())
                .add("PermittedFileTypes", permittedFileTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SolutionStackName":
            return Optional.ofNullable(clazz.cast(solutionStackName()));
        case "PermittedFileTypes":
            return Optional.ofNullable(clazz.cast(permittedFileTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SolutionStackDescription, T> g) {
        return obj -> g.apply((SolutionStackDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SolutionStackDescription> {
        /**
         * <p>
         * The name of the solution stack.
         * </p>
         * 
         * @param solutionStackName
         *        The name of the solution stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionStackName(String solutionStackName);

        /**
         * <p>
         * The permitted file types allowed for a solution stack.
         * </p>
         * 
         * @param permittedFileTypes
         *        The permitted file types allowed for a solution stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permittedFileTypes(Collection<String> permittedFileTypes);

        /**
         * <p>
         * The permitted file types allowed for a solution stack.
         * </p>
         * 
         * @param permittedFileTypes
         *        The permitted file types allowed for a solution stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permittedFileTypes(String... permittedFileTypes);
    }

    static final class BuilderImpl implements Builder {
        private String solutionStackName;

        private List<String> permittedFileTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionStackDescription model) {
            solutionStackName(model.solutionStackName);
            permittedFileTypes(model.permittedFileTypes);
        }

        public final String getSolutionStackName() {
            return solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final Collection<String> getPermittedFileTypes() {
            return permittedFileTypes;
        }

        @Override
        public final Builder permittedFileTypes(Collection<String> permittedFileTypes) {
            this.permittedFileTypes = SolutionStackFileTypeListCopier.copy(permittedFileTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedFileTypes(String... permittedFileTypes) {
            permittedFileTypes(Arrays.asList(permittedFileTypes));
            return this;
        }

        public final void setPermittedFileTypes(Collection<String> permittedFileTypes) {
            this.permittedFileTypes = SolutionStackFileTypeListCopier.copy(permittedFileTypes);
        }

        @Override
        public SolutionStackDescription build() {
            return new SolutionStackDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
