/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationVersionRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<CreateApplicationVersionRequest.Builder, CreateApplicationVersionRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(CreateApplicationVersionRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionLabel").getter(getter(CreateApplicationVersionRequest::versionLabel))
            .setter(setter(Builder::versionLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateApplicationVersionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<SourceBuildInformation> SOURCE_BUILD_INFORMATION_FIELD = SdkField
            .<SourceBuildInformation> builder(MarshallingType.SDK_POJO).memberName("SourceBuildInformation")
            .getter(getter(CreateApplicationVersionRequest::sourceBuildInformation))
            .setter(setter(Builder::sourceBuildInformation)).constructor(SourceBuildInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBuildInformation").build())
            .build();

    private static final SdkField<S3Location> SOURCE_BUNDLE_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("SourceBundle").getter(getter(CreateApplicationVersionRequest::sourceBundle))
            .setter(setter(Builder::sourceBundle)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBundle").build()).build();

    private static final SdkField<BuildConfiguration> BUILD_CONFIGURATION_FIELD = SdkField
            .<BuildConfiguration> builder(MarshallingType.SDK_POJO).memberName("BuildConfiguration")
            .getter(getter(CreateApplicationVersionRequest::buildConfiguration)).setter(setter(Builder::buildConfiguration))
            .constructor(BuildConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildConfiguration").build())
            .build();

    private static final SdkField<Boolean> AUTO_CREATE_APPLICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoCreateApplication").getter(getter(CreateApplicationVersionRequest::autoCreateApplication))
            .setter(setter(Builder::autoCreateApplication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoCreateApplication").build())
            .build();

    private static final SdkField<Boolean> PROCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Process").getter(getter(CreateApplicationVersionRequest::process)).setter(setter(Builder::process))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Process").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateApplicationVersionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            VERSION_LABEL_FIELD, DESCRIPTION_FIELD, SOURCE_BUILD_INFORMATION_FIELD, SOURCE_BUNDLE_FIELD,
            BUILD_CONFIGURATION_FIELD, AUTO_CREATE_APPLICATION_FIELD, PROCESS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationName;

    private final String versionLabel;

    private final String description;

    private final SourceBuildInformation sourceBuildInformation;

    private final S3Location sourceBundle;

    private final BuildConfiguration buildConfiguration;

    private final Boolean autoCreateApplication;

    private final Boolean process;

    private final List<Tag> tags;

    private CreateApplicationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.description = builder.description;
        this.sourceBuildInformation = builder.sourceBuildInformation;
        this.sourceBundle = builder.sourceBundle;
        this.buildConfiguration = builder.buildConfiguration;
        this.autoCreateApplication = builder.autoCreateApplication;
        this.process = builder.process;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the application. If no application is found with this name, and <code>AutoCreateApplication</code> is
     * <code>false</code>, returns an <code>InvalidParameterValue</code> error.
     * </p>
     * 
     * @return The name of the application. If no application is found with this name, and
     *         <code>AutoCreateApplication</code> is <code>false</code>, returns an <code>InvalidParameterValue</code>
     *         error.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * A label identifying this version.
     * </p>
     * <p>
     * Constraint: Must be unique per application. If an application version already exists with this label for the
     * specified application, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.
     * </p>
     * 
     * @return A label identifying this version.</p>
     *         <p>
     *         Constraint: Must be unique per application. If an application version already exists with this label for
     *         the specified application, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.
     */
    public final String versionLabel() {
        return versionLabel;
    }

    /**
     * <p>
     * A description of this application version.
     * </p>
     * 
     * @return A description of this application version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application version.
     * </p>
     * 
     * @return Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application
     *         version.
     */
    public final SourceBuildInformation sourceBuildInformation() {
        return sourceBuildInformation;
    }

    /**
     * <p>
     * The Amazon S3 bucket and key that identify the location of the source bundle for this version.
     * </p>
     * <note>
     * <p>
     * The Amazon S3 bucket must be in the same region as the environment.
     * </p>
     * </note>
     * <p>
     * Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with
     * <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor
     * <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample application.
     * </p>
     * 
     * @return The Amazon S3 bucket and key that identify the location of the source bundle for this version.</p> <note>
     *         <p>
     *         The Amazon S3 bucket must be in the same region as the environment.
     *         </p>
     *         </note>
     *         <p>
     *         Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with
     *         <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor
     *         <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample application.
     */
    public final S3Location sourceBundle() {
        return sourceBundle;
    }

    /**
     * <p>
     * Settings for an AWS CodeBuild build.
     * </p>
     * 
     * @return Settings for an AWS CodeBuild build.
     */
    public final BuildConfiguration buildConfiguration() {
        return buildConfiguration;
    }

    /**
     * <p>
     * Set to <code>true</code> to create an application with the specified name if it doesn't already exist.
     * </p>
     * 
     * @return Set to <code>true</code> to create an application with the specified name if it doesn't already exist.
     */
    public final Boolean autoCreateApplication() {
        return autoCreateApplication;
    }

    /**
     * <p>
     * Pre-processes and validates the environment manifest (<code>env.yaml</code>) and configuration files (
     * <code>*.config</code> files in the <code>.ebextensions</code> folder) in the source bundle. Validating
     * configuration files can identify issues prior to deploying the application version to an environment.
     * </p>
     * <p>
     * You must turn processing on for application versions that you create using AWS CodeBuild or AWS CodeCommit. For
     * application versions built from a source bundle in Amazon S3, processing is optional.
     * </p>
     * <note>
     * <p>
     * The <code>Process</code> option validates Elastic Beanstalk configuration files. It doesn't validate your
     * application's configuration files, like proxy server or Docker configuration.
     * </p>
     * </note>
     * 
     * @return Pre-processes and validates the environment manifest (<code>env.yaml</code>) and configuration files (
     *         <code>*.config</code> files in the <code>.ebextensions</code> folder) in the source bundle. Validating
     *         configuration files can identify issues prior to deploying the application version to an environment.</p>
     *         <p>
     *         You must turn processing on for application versions that you create using AWS CodeBuild or AWS
     *         CodeCommit. For application versions built from a source bundle in Amazon S3, processing is optional.
     *         </p>
     *         <note>
     *         <p>
     *         The <code>Process</code> option validates Elastic Beanstalk configuration files. It doesn't validate your
     *         application's configuration files, like proxy server or Docker configuration.
     *         </p>
     */
    public final Boolean process() {
        return process;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the tags applied to the application version.
     * </p>
     * <p>
     * Elastic Beanstalk applies these tags only to the application version. Environments that use the application
     * version don't inherit the tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies the tags applied to the application version.</p>
     *         <p>
     *         Elastic Beanstalk applies these tags only to the application version. Environments that use the
     *         application version don't inherit the tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBuildInformation());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBundle());
        hashCode = 31 * hashCode + Objects.hashCode(buildConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoCreateApplication());
        hashCode = 31 * hashCode + Objects.hashCode(process());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationVersionRequest)) {
            return false;
        }
        CreateApplicationVersionRequest other = (CreateApplicationVersionRequest) obj;
        return Objects.equals(applicationName(), other.applicationName()) && Objects.equals(versionLabel(), other.versionLabel())
                && Objects.equals(description(), other.description())
                && Objects.equals(sourceBuildInformation(), other.sourceBuildInformation())
                && Objects.equals(sourceBundle(), other.sourceBundle())
                && Objects.equals(buildConfiguration(), other.buildConfiguration())
                && Objects.equals(autoCreateApplication(), other.autoCreateApplication())
                && Objects.equals(process(), other.process()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationVersionRequest").add("ApplicationName", applicationName())
                .add("VersionLabel", versionLabel()).add("Description", description())
                .add("SourceBuildInformation", sourceBuildInformation()).add("SourceBundle", sourceBundle())
                .add("BuildConfiguration", buildConfiguration()).add("AutoCreateApplication", autoCreateApplication())
                .add("Process", process()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "VersionLabel":
            return Optional.ofNullable(clazz.cast(versionLabel()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SourceBuildInformation":
            return Optional.ofNullable(clazz.cast(sourceBuildInformation()));
        case "SourceBundle":
            return Optional.ofNullable(clazz.cast(sourceBundle()));
        case "BuildConfiguration":
            return Optional.ofNullable(clazz.cast(buildConfiguration()));
        case "AutoCreateApplication":
            return Optional.ofNullable(clazz.cast(autoCreateApplication()));
        case "Process":
            return Optional.ofNullable(clazz.cast(process()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationName", APPLICATION_NAME_FIELD);
        map.put("VersionLabel", VERSION_LABEL_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SourceBuildInformation", SOURCE_BUILD_INFORMATION_FIELD);
        map.put("SourceBundle", SOURCE_BUNDLE_FIELD);
        map.put("BuildConfiguration", BUILD_CONFIGURATION_FIELD);
        map.put("AutoCreateApplication", AUTO_CREATE_APPLICATION_FIELD);
        map.put("Process", PROCESS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationVersionRequest, T> g) {
        return obj -> g.apply((CreateApplicationVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateApplicationVersionRequest> {
        /**
         * <p>
         * The name of the application. If no application is found with this name, and
         * <code>AutoCreateApplication</code> is <code>false</code>, returns an <code>InvalidParameterValue</code>
         * error.
         * </p>
         * 
         * @param applicationName
         *        The name of the application. If no application is found with this name, and
         *        <code>AutoCreateApplication</code> is <code>false</code>, returns an
         *        <code>InvalidParameterValue</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * A label identifying this version.
         * </p>
         * <p>
         * Constraint: Must be unique per application. If an application version already exists with this label for the
         * specified application, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code> error.
         * </p>
         * 
         * @param versionLabel
         *        A label identifying this version.</p>
         *        <p>
         *        Constraint: Must be unique per application. If an application version already exists with this label
         *        for the specified application, AWS Elastic Beanstalk returns an <code>InvalidParameterValue</code>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionLabel(String versionLabel);

        /**
         * <p>
         * A description of this application version.
         * </p>
         * 
         * @param description
         *        A description of this application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application version.
         * </p>
         * 
         * @param sourceBuildInformation
         *        Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBuildInformation(SourceBuildInformation sourceBuildInformation);

        /**
         * <p>
         * Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application version.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceBuildInformation.Builder} avoiding
         * the need to create one manually via {@link SourceBuildInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceBuildInformation.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceBuildInformation(SourceBuildInformation)}.
         * 
         * @param sourceBuildInformation
         *        a consumer that will call methods on {@link SourceBuildInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceBuildInformation(SourceBuildInformation)
         */
        default Builder sourceBuildInformation(Consumer<SourceBuildInformation.Builder> sourceBuildInformation) {
            return sourceBuildInformation(SourceBuildInformation.builder().applyMutation(sourceBuildInformation).build());
        }

        /**
         * <p>
         * The Amazon S3 bucket and key that identify the location of the source bundle for this version.
         * </p>
         * <note>
         * <p>
         * The Amazon S3 bucket must be in the same region as the environment.
         * </p>
         * </note>
         * <p>
         * Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with
         * <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor
         * <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample application.
         * </p>
         * 
         * @param sourceBundle
         *        The Amazon S3 bucket and key that identify the location of the source bundle for this version.</p>
         *        <note>
         *        <p>
         *        The Amazon S3 bucket must be in the same region as the environment.
         *        </p>
         *        </note>
         *        <p>
         *        Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with
         *        <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor
         *        <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBundle(S3Location sourceBundle);

        /**
         * <p>
         * The Amazon S3 bucket and key that identify the location of the source bundle for this version.
         * </p>
         * <note>
         * <p>
         * The Amazon S3 bucket must be in the same region as the environment.
         * </p>
         * </note>
         * <p>
         * Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with
         * <code>SourceBuildInformation</code>), but not both. If neither <code>SourceBundle</code> nor
         * <code>SourceBuildInformation</code> are provided, Elastic Beanstalk uses a sample application.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #sourceBundle(S3Location)}.
         * 
         * @param sourceBundle
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceBundle(S3Location)
         */
        default Builder sourceBundle(Consumer<S3Location.Builder> sourceBundle) {
            return sourceBundle(S3Location.builder().applyMutation(sourceBundle).build());
        }

        /**
         * <p>
         * Settings for an AWS CodeBuild build.
         * </p>
         * 
         * @param buildConfiguration
         *        Settings for an AWS CodeBuild build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildConfiguration(BuildConfiguration buildConfiguration);

        /**
         * <p>
         * Settings for an AWS CodeBuild build.
         * </p>
         * This is a convenience method that creates an instance of the {@link BuildConfiguration.Builder} avoiding the
         * need to create one manually via {@link BuildConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BuildConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #buildConfiguration(BuildConfiguration)}.
         * 
         * @param buildConfiguration
         *        a consumer that will call methods on {@link BuildConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buildConfiguration(BuildConfiguration)
         */
        default Builder buildConfiguration(Consumer<BuildConfiguration.Builder> buildConfiguration) {
            return buildConfiguration(BuildConfiguration.builder().applyMutation(buildConfiguration).build());
        }

        /**
         * <p>
         * Set to <code>true</code> to create an application with the specified name if it doesn't already exist.
         * </p>
         * 
         * @param autoCreateApplication
         *        Set to <code>true</code> to create an application with the specified name if it doesn't already exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoCreateApplication(Boolean autoCreateApplication);

        /**
         * <p>
         * Pre-processes and validates the environment manifest (<code>env.yaml</code>) and configuration files (
         * <code>*.config</code> files in the <code>.ebextensions</code> folder) in the source bundle. Validating
         * configuration files can identify issues prior to deploying the application version to an environment.
         * </p>
         * <p>
         * You must turn processing on for application versions that you create using AWS CodeBuild or AWS CodeCommit.
         * For application versions built from a source bundle in Amazon S3, processing is optional.
         * </p>
         * <note>
         * <p>
         * The <code>Process</code> option validates Elastic Beanstalk configuration files. It doesn't validate your
         * application's configuration files, like proxy server or Docker configuration.
         * </p>
         * </note>
         * 
         * @param process
         *        Pre-processes and validates the environment manifest (<code>env.yaml</code>) and configuration files (
         *        <code>*.config</code> files in the <code>.ebextensions</code> folder) in the source bundle. Validating
         *        configuration files can identify issues prior to deploying the application version to an
         *        environment.</p>
         *        <p>
         *        You must turn processing on for application versions that you create using AWS CodeBuild or AWS
         *        CodeCommit. For application versions built from a source bundle in Amazon S3, processing is optional.
         *        </p>
         *        <note>
         *        <p>
         *        The <code>Process</code> option validates Elastic Beanstalk configuration files. It doesn't validate
         *        your application's configuration files, like proxy server or Docker configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder process(Boolean process);

        /**
         * <p>
         * Specifies the tags applied to the application version.
         * </p>
         * <p>
         * Elastic Beanstalk applies these tags only to the application version. Environments that use the application
         * version don't inherit the tags.
         * </p>
         * 
         * @param tags
         *        Specifies the tags applied to the application version.</p>
         *        <p>
         *        Elastic Beanstalk applies these tags only to the application version. Environments that use the
         *        application version don't inherit the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Specifies the tags applied to the application version.
         * </p>
         * <p>
         * Elastic Beanstalk applies these tags only to the application version. Environments that use the application
         * version don't inherit the tags.
         * </p>
         * 
         * @param tags
         *        Specifies the tags applied to the application version.</p>
         *        <p>
         *        Elastic Beanstalk applies these tags only to the application version. Environments that use the
         *        application version don't inherit the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Specifies the tags applied to the application version.
         * </p>
         * <p>
         * Elastic Beanstalk applies these tags only to the application version. Environments that use the application
         * version don't inherit the tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.elasticbeanstalk.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticbeanstalk.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String versionLabel;

        private String description;

        private SourceBuildInformation sourceBuildInformation;

        private S3Location sourceBundle;

        private BuildConfiguration buildConfiguration;

        private Boolean autoCreateApplication;

        private Boolean process;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationVersionRequest model) {
            super(model);
            applicationName(model.applicationName);
            versionLabel(model.versionLabel);
            description(model.description);
            sourceBuildInformation(model.sourceBuildInformation);
            sourceBundle(model.sourceBundle);
            buildConfiguration(model.buildConfiguration);
            autoCreateApplication(model.autoCreateApplication);
            process(model.process);
            tags(model.tags);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getVersionLabel() {
            return versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SourceBuildInformation.Builder getSourceBuildInformation() {
            return sourceBuildInformation != null ? sourceBuildInformation.toBuilder() : null;
        }

        public final void setSourceBuildInformation(SourceBuildInformation.BuilderImpl sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation != null ? sourceBuildInformation.build() : null;
        }

        @Override
        public final Builder sourceBuildInformation(SourceBuildInformation sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation;
            return this;
        }

        public final S3Location.Builder getSourceBundle() {
            return sourceBundle != null ? sourceBundle.toBuilder() : null;
        }

        public final void setSourceBundle(S3Location.BuilderImpl sourceBundle) {
            this.sourceBundle = sourceBundle != null ? sourceBundle.build() : null;
        }

        @Override
        public final Builder sourceBundle(S3Location sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        public final BuildConfiguration.Builder getBuildConfiguration() {
            return buildConfiguration != null ? buildConfiguration.toBuilder() : null;
        }

        public final void setBuildConfiguration(BuildConfiguration.BuilderImpl buildConfiguration) {
            this.buildConfiguration = buildConfiguration != null ? buildConfiguration.build() : null;
        }

        @Override
        public final Builder buildConfiguration(BuildConfiguration buildConfiguration) {
            this.buildConfiguration = buildConfiguration;
            return this;
        }

        public final Boolean getAutoCreateApplication() {
            return autoCreateApplication;
        }

        public final void setAutoCreateApplication(Boolean autoCreateApplication) {
            this.autoCreateApplication = autoCreateApplication;
        }

        @Override
        public final Builder autoCreateApplication(Boolean autoCreateApplication) {
            this.autoCreateApplication = autoCreateApplication;
            return this;
        }

        public final Boolean getProcess() {
            return process;
        }

        public final void setProcess(Boolean process) {
            this.process = process;
        }

        @Override
        public final Builder process(Boolean process) {
            this.process = process;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationVersionRequest build() {
            return new CreateApplicationVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
