/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Location of the source code for an application version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceBuildInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceBuildInformation.Builder, SourceBuildInformation> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(SourceBuildInformation::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> SOURCE_REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceRepository").getter(getter(SourceBuildInformation::sourceRepositoryAsString))
            .setter(setter(Builder::sourceRepository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRepository").build()).build();

    private static final SdkField<String> SOURCE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocation").getter(getter(SourceBuildInformation::sourceLocation))
            .setter(setter(Builder::sourceLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD,
            SOURCE_REPOSITORY_FIELD, SOURCE_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceType;

    private final String sourceRepository;

    private final String sourceLocation;

    private SourceBuildInformation(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.sourceRepository = builder.sourceRepository;
        this.sourceLocation = builder.sourceLocation;
    }

    /**
     * <p>
     * The type of repository.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Git</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Zip</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of repository.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Git</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Zip</code>
     *         </p>
     *         </li>
     * @see SourceType
     */
    public final SourceType sourceType() {
        return SourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The type of repository.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Git</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Zip</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of repository.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Git</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Zip</code>
     *         </p>
     *         </li>
     * @see SourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * Location where the repository is stored.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CodeCommit</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceRepository}
     * will return {@link SourceRepository#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceRepositoryAsString}.
     * </p>
     * 
     * @return Location where the repository is stored.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CodeCommit</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code>
     *         </p>
     *         </li>
     * @see SourceRepository
     */
    public final SourceRepository sourceRepository() {
        return SourceRepository.fromValue(sourceRepository);
    }

    /**
     * <p>
     * Location where the repository is stored.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CodeCommit</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceRepository}
     * will return {@link SourceRepository#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceRepositoryAsString}.
     * </p>
     * 
     * @return Location where the repository is stored.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CodeCommit</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code>
     *         </p>
     *         </li>
     * @see SourceRepository
     */
    public final String sourceRepositoryAsString() {
        return sourceRepository;
    }

    /**
     * <p>
     * The location of the source code, as a formatted string, depending on the value of <code>SourceRepository</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>CodeCommit</code>, the format is the repository name and commit ID, separated by a forward slash. For
     * example, <code>my-git-repo/265cfa0cf6af46153527f55d6503ec030551f57a</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>S3</code>, the format is the S3 bucket name and object key, separated by a forward slash. For example,
     * <code>my-s3-bucket/Folders/my-source-file</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The location of the source code, as a formatted string, depending on the value of
     *         <code>SourceRepository</code> </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>CodeCommit</code>, the format is the repository name and commit ID, separated by a forward
     *         slash. For example, <code>my-git-repo/265cfa0cf6af46153527f55d6503ec030551f57a</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>S3</code>, the format is the S3 bucket name and object key, separated by a forward slash. For
     *         example, <code>my-s3-bucket/Folders/my-source-file</code>.
     *         </p>
     *         </li>
     */
    public final String sourceLocation() {
        return sourceLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRepositoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceBuildInformation)) {
            return false;
        }
        SourceBuildInformation other = (SourceBuildInformation) obj;
        return Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(sourceRepositoryAsString(), other.sourceRepositoryAsString())
                && Objects.equals(sourceLocation(), other.sourceLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceBuildInformation").add("SourceType", sourceTypeAsString())
                .add("SourceRepository", sourceRepositoryAsString()).add("SourceLocation", sourceLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "SourceRepository":
            return Optional.ofNullable(clazz.cast(sourceRepositoryAsString()));
        case "SourceLocation":
            return Optional.ofNullable(clazz.cast(sourceLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("SourceRepository", SOURCE_REPOSITORY_FIELD);
        map.put("SourceLocation", SOURCE_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceBuildInformation, T> g) {
        return obj -> g.apply((SourceBuildInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceBuildInformation> {
        /**
         * <p>
         * The type of repository.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Git</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Zip</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceType
         *        The type of repository.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Git</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Zip</code>
         *        </p>
         *        </li>
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The type of repository.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Git</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Zip</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceType
         *        The type of repository.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Git</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Zip</code>
         *        </p>
         *        </li>
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(SourceType sourceType);

        /**
         * <p>
         * Location where the repository is stored.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CodeCommit</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceRepository
         *        Location where the repository is stored.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CodeCommit</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code>
         *        </p>
         *        </li>
         * @see SourceRepository
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceRepository
         */
        Builder sourceRepository(String sourceRepository);

        /**
         * <p>
         * Location where the repository is stored.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CodeCommit</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceRepository
         *        Location where the repository is stored.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CodeCommit</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code>
         *        </p>
         *        </li>
         * @see SourceRepository
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceRepository
         */
        Builder sourceRepository(SourceRepository sourceRepository);

        /**
         * <p>
         * The location of the source code, as a formatted string, depending on the value of
         * <code>SourceRepository</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>CodeCommit</code>, the format is the repository name and commit ID, separated by a forward slash.
         * For example, <code>my-git-repo/265cfa0cf6af46153527f55d6503ec030551f57a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>S3</code>, the format is the S3 bucket name and object key, separated by a forward slash. For
         * example, <code>my-s3-bucket/Folders/my-source-file</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceLocation
         *        The location of the source code, as a formatted string, depending on the value of
         *        <code>SourceRepository</code> </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>CodeCommit</code>, the format is the repository name and commit ID, separated by a forward
         *        slash. For example, <code>my-git-repo/265cfa0cf6af46153527f55d6503ec030551f57a</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>S3</code>, the format is the S3 bucket name and object key, separated by a forward slash.
         *        For example, <code>my-s3-bucket/Folders/my-source-file</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocation(String sourceLocation);
    }

    static final class BuilderImpl implements Builder {
        private String sourceType;

        private String sourceRepository;

        private String sourceLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceBuildInformation model) {
            sourceType(model.sourceType);
            sourceRepository(model.sourceRepository);
            sourceLocation(model.sourceLocation);
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getSourceRepository() {
            return sourceRepository;
        }

        public final void setSourceRepository(String sourceRepository) {
            this.sourceRepository = sourceRepository;
        }

        @Override
        public final Builder sourceRepository(String sourceRepository) {
            this.sourceRepository = sourceRepository;
            return this;
        }

        @Override
        public final Builder sourceRepository(SourceRepository sourceRepository) {
            this.sourceRepository(sourceRepository == null ? null : sourceRepository.toString());
            return this;
        }

        public final String getSourceLocation() {
            return sourceLocation;
        }

        public final void setSourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        public final Builder sourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public SourceBuildInformation build() {
            return new SourceBuildInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
