/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Deployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Deployment> {
    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionLabel").getter(Deployment.getter(Deployment::versionLabel)).setter(Deployment.setter(Builder::versionLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()}).build();
    private static final SdkField<Long> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DeploymentId").getter(Deployment.getter(Deployment::deploymentId)).setter(Deployment.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Deployment.getter(Deployment::status)).setter(Deployment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> DEPLOYMENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeploymentTime").getter(Deployment.getter(Deployment::deploymentTime)).setter(Deployment.setter(Builder::deploymentTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_LABEL_FIELD, DEPLOYMENT_ID_FIELD, STATUS_FIELD, DEPLOYMENT_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Deployment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String versionLabel;
    private final Long deploymentId;
    private final String status;
    private final Instant deploymentTime;

    private Deployment(BuilderImpl builder) {
        this.versionLabel = builder.versionLabel;
        this.deploymentId = builder.deploymentId;
        this.status = builder.status;
        this.deploymentTime = builder.deploymentTime;
    }

    public final String versionLabel() {
        return this.versionLabel;
    }

    public final Long deploymentId() {
        return this.deploymentId;
    }

    public final String status() {
        return this.status;
    }

    public final Instant deploymentTime() {
        return this.deploymentTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        return Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.deploymentTime(), other.deploymentTime());
    }

    public final String toString() {
        return ToString.builder((String)"Deployment").add("VersionLabel", (Object)this.versionLabel()).add("DeploymentId", (Object)this.deploymentId()).add("Status", (Object)this.status()).add("DeploymentTime", (Object)this.deploymentTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VersionLabel": {
                return Optional.ofNullable(clazz.cast(this.versionLabel()));
            }
            case "DeploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "DeploymentTime": {
                return Optional.ofNullable(clazz.cast(this.deploymentTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VersionLabel", VERSION_LABEL_FIELD);
        map.put("DeploymentId", DEPLOYMENT_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DeploymentTime", DEPLOYMENT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Deployment, T> g) {
        return obj -> g.apply((Deployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String versionLabel;
        private Long deploymentId;
        private String status;
        private Instant deploymentTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            this.versionLabel(model.versionLabel);
            this.deploymentId(model.deploymentId);
            this.status(model.status);
            this.deploymentTime(model.deploymentTime);
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final Long getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(Long deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(Long deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getDeploymentTime() {
            return this.deploymentTime;
        }

        public final void setDeploymentTime(Instant deploymentTime) {
            this.deploymentTime = deploymentTime;
        }

        @Override
        public final Builder deploymentTime(Instant deploymentTime) {
            this.deploymentTime = deploymentTime;
            return this;
        }

        public Deployment build() {
            return new Deployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Deployment> {
        public Builder versionLabel(String var1);

        public Builder deploymentId(Long var1);

        public Builder status(String var1);

        public Builder deploymentTime(Instant var1);
    }
}

