/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to list completed and failed managed actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEnvironmentManagedActionHistoryRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<DescribeEnvironmentManagedActionHistoryRequest.Builder, DescribeEnvironmentManagedActionHistoryRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(DescribeEnvironmentManagedActionHistoryRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentName").getter(getter(DescribeEnvironmentManagedActionHistoryRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeEnvironmentManagedActionHistoryRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(DescribeEnvironmentManagedActionHistoryRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            ENVIRONMENT_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String environmentId;

    private final String environmentName;

    private final String nextToken;

    private final Integer maxItems;

    private DescribeEnvironmentManagedActionHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
        this.nextToken = builder.nextToken;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The environment ID of the target environment.
     * </p>
     * 
     * @return The environment ID of the target environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The name of the target environment.
     * </p>
     * 
     * @return The name of the target environment.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The pagination token returned by a previous request.
     * </p>
     * 
     * @return The pagination token returned by a previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for a single request.
     * </p>
     * 
     * @return The maximum number of items to return for a single request.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentManagedActionHistoryRequest)) {
            return false;
        }
        DescribeEnvironmentManagedActionHistoryRequest other = (DescribeEnvironmentManagedActionHistoryRequest) obj;
        return Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(environmentName(), other.environmentName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEnvironmentManagedActionHistoryRequest").add("EnvironmentId", environmentId())
                .add("EnvironmentName", environmentName()).add("NextToken", nextToken()).add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
        map.put("EnvironmentName", ENVIRONMENT_NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentManagedActionHistoryRequest, T> g) {
        return obj -> g.apply((DescribeEnvironmentManagedActionHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEnvironmentManagedActionHistoryRequest> {
        /**
         * <p>
         * The environment ID of the target environment.
         * </p>
         * 
         * @param environmentId
         *        The environment ID of the target environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The name of the target environment.
         * </p>
         * 
         * @param environmentName
         *        The name of the target environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The pagination token returned by a previous request.
         * </p>
         * 
         * @param nextToken
         *        The pagination token returned by a previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for a single request.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of items to return for a single request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String environmentId;

        private String environmentName;

        private String nextToken;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentManagedActionHistoryRequest model) {
            super(model);
            environmentId(model.environmentId);
            environmentName(model.environmentName);
            nextToken(model.nextToken);
            maxItems(model.maxItems);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEnvironmentManagedActionHistoryRequest build() {
            return new DescribeEnvironmentManagedActionHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
