/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePlatformVersionResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<DescribePlatformVersionResponse.Builder, DescribePlatformVersionResponse> {
    private static final SdkField<PlatformDescription> PLATFORM_DESCRIPTION_FIELD = SdkField
            .<PlatformDescription> builder(MarshallingType.SDK_POJO).memberName("PlatformDescription")
            .getter(getter(DescribePlatformVersionResponse::platformDescription)).setter(setter(Builder::platformDescription))
            .constructor(PlatformDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PlatformDescription platformDescription;

    private DescribePlatformVersionResponse(BuilderImpl builder) {
        super(builder);
        this.platformDescription = builder.platformDescription;
    }

    /**
     * <p>
     * Detailed information about the platform version.
     * </p>
     * 
     * @return Detailed information about the platform version.
     */
    public final PlatformDescription platformDescription() {
        return platformDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(platformDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlatformVersionResponse)) {
            return false;
        }
        DescribePlatformVersionResponse other = (DescribePlatformVersionResponse) obj;
        return Objects.equals(platformDescription(), other.platformDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePlatformVersionResponse").add("PlatformDescription", platformDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformDescription":
            return Optional.ofNullable(clazz.cast(platformDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PlatformDescription", PLATFORM_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePlatformVersionResponse, T> g) {
        return obj -> g.apply((DescribePlatformVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePlatformVersionResponse> {
        /**
         * <p>
         * Detailed information about the platform version.
         * </p>
         * 
         * @param platformDescription
         *        Detailed information about the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformDescription(PlatformDescription platformDescription);

        /**
         * <p>
         * Detailed information about the platform version.
         * </p>
         * This is a convenience method that creates an instance of the {@link PlatformDescription.Builder} avoiding the
         * need to create one manually via {@link PlatformDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PlatformDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #platformDescription(PlatformDescription)}.
         * 
         * @param platformDescription
         *        a consumer that will call methods on {@link PlatformDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platformDescription(PlatformDescription)
         */
        default Builder platformDescription(Consumer<PlatformDescription.Builder> platformDescription) {
            return platformDescription(PlatformDescription.builder().applyMutation(platformDescription).build());
        }
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private PlatformDescription platformDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlatformVersionResponse model) {
            super(model);
            platformDescription(model.platformDescription);
        }

        public final PlatformDescription.Builder getPlatformDescription() {
            return platformDescription != null ? platformDescription.toBuilder() : null;
        }

        public final void setPlatformDescription(PlatformDescription.BuilderImpl platformDescription) {
            this.platformDescription = platformDescription != null ? platformDescription.build() : null;
        }

        @Override
        public final Builder platformDescription(PlatformDescription platformDescription) {
            this.platformDescription = platformDescription;
            return this;
        }

        @Override
        public DescribePlatformVersionResponse build() {
            return new DescribePlatformVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
