/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateEnvironmentOperationsRoleRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, AssociateEnvironmentOperationsRoleRequest> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentName").getter(AssociateEnvironmentOperationsRoleRequest.getter(AssociateEnvironmentOperationsRoleRequest::environmentName)).setter(AssociateEnvironmentOperationsRoleRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()}).build();
    private static final SdkField<String> OPERATIONS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationsRole").getter(AssociateEnvironmentOperationsRoleRequest.getter(AssociateEnvironmentOperationsRoleRequest::operationsRole)).setter(AssociateEnvironmentOperationsRoleRequest.setter(Builder::operationsRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationsRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD, OPERATIONS_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateEnvironmentOperationsRoleRequest.memberNameToFieldInitializer();
    private final String environmentName;
    private final String operationsRole;

    private AssociateEnvironmentOperationsRoleRequest(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.operationsRole = builder.operationsRole;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String operationsRole() {
        return this.operationsRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationsRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateEnvironmentOperationsRoleRequest)) {
            return false;
        }
        AssociateEnvironmentOperationsRoleRequest other = (AssociateEnvironmentOperationsRoleRequest)((Object)obj);
        return Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.operationsRole(), other.operationsRole());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateEnvironmentOperationsRoleRequest").add("EnvironmentName", (Object)this.environmentName()).add("OperationsRole", (Object)this.operationsRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "OperationsRole": {
                return Optional.ofNullable(clazz.cast(this.operationsRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("EnvironmentName", ENVIRONMENT_NAME_FIELD);
        map.put("OperationsRole", OPERATIONS_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateEnvironmentOperationsRoleRequest, T> g) {
        return obj -> g.apply((AssociateEnvironmentOperationsRoleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String environmentName;
        private String operationsRole;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateEnvironmentOperationsRoleRequest model) {
            super(model);
            this.environmentName(model.environmentName);
            this.operationsRole(model.operationsRole);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getOperationsRole() {
            return this.operationsRole;
        }

        public final void setOperationsRole(String operationsRole) {
            this.operationsRole = operationsRole;
        }

        @Override
        public final Builder operationsRole(String operationsRole) {
            this.operationsRole = operationsRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateEnvironmentOperationsRoleRequest build() {
            return new AssociateEnvironmentOperationsRoleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateEnvironmentOperationsRoleRequest> {
        public Builder environmentName(String var1);

        public Builder operationsRole(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

