/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for an AWS CodeBuild build.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BuildConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BuildConfiguration.Builder, BuildConfiguration> {
    private static final SdkField<String> ARTIFACT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactName").getter(getter(BuildConfiguration::artifactName)).setter(setter(Builder::artifactName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactName").build()).build();

    private static final SdkField<String> CODE_BUILD_SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeBuildServiceRole").getter(getter(BuildConfiguration::codeBuildServiceRole))
            .setter(setter(Builder::codeBuildServiceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeBuildServiceRole").build())
            .build();

    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeType").getter(getter(BuildConfiguration::computeTypeAsString))
            .setter(setter(Builder::computeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeType").build()).build();

    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Image")
            .getter(getter(BuildConfiguration::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()).build();

    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeoutInMinutes").getter(getter(BuildConfiguration::timeoutInMinutes))
            .setter(setter(Builder::timeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_NAME_FIELD,
            CODE_BUILD_SERVICE_ROLE_FIELD, COMPUTE_TYPE_FIELD, IMAGE_FIELD, TIMEOUT_IN_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String artifactName;

    private final String codeBuildServiceRole;

    private final String computeType;

    private final String image;

    private final Integer timeoutInMinutes;

    private BuildConfiguration(BuilderImpl builder) {
        this.artifactName = builder.artifactName;
        this.codeBuildServiceRole = builder.codeBuildServiceRole;
        this.computeType = builder.computeType;
        this.image = builder.image;
        this.timeoutInMinutes = builder.timeoutInMinutes;
    }

    /**
     * <p>
     * The name of the artifact of the CodeBuild build. If provided, Elastic Beanstalk stores the build artifact in the
     * S3 location
     * <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version-label</i>-<i>artifact
     * -name</i>.zip. If not provided, Elastic Beanstalk stores the build artifact in the S3 location
     * <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version-label</i>.zip.
     * </p>
     * 
     * @return The name of the artifact of the CodeBuild build. If provided, Elastic Beanstalk stores the build artifact
     *         in the S3 location
     *         <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version-label
     *         </i>-<i>artifact-name</i>.zip. If not provided, Elastic Beanstalk stores the build artifact in the S3
     *         location <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version-label</i>.zip.
     */
    public final String artifactName() {
        return artifactName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to
     * interact with dependent AWS services on behalf of the AWS account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS
     *         CodeBuild to interact with dependent AWS services on behalf of the AWS account.
     */
    public final String codeBuildServiceRole() {
        return codeBuildServiceRole;
    }

    /**
     * <p>
     * Information about the compute resources the build project will use.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return Information about the compute resources the build project will use.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds</code>
     *         </p>
     *         </li>
     * @see ComputeType
     */
    public final ComputeType computeType() {
        return ComputeType.fromValue(computeType);
    }

    /**
     * <p>
     * Information about the compute resources the build project will use.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return Information about the compute resources the build project will use.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds</code>
     *         </p>
     *         </li>
     * @see ComputeType
     */
    public final String computeTypeAsString() {
        return computeType;
    }

    /**
     * <p>
     * The ID of the Docker image to use for this build project.
     * </p>
     * 
     * @return The ID of the Docker image to use for this build project.
     */
    public final String image() {
        return image;
    }

    /**
     * <p>
     * How long in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that
     * does not get marked as completed. The default is 60 minutes.
     * </p>
     * 
     * @return How long in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related
     *         build that does not get marked as completed. The default is 60 minutes.
     */
    public final Integer timeoutInMinutes() {
        return timeoutInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(artifactName());
        hashCode = 31 * hashCode + Objects.hashCode(codeBuildServiceRole());
        hashCode = 31 * hashCode + Objects.hashCode(computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildConfiguration)) {
            return false;
        }
        BuildConfiguration other = (BuildConfiguration) obj;
        return Objects.equals(artifactName(), other.artifactName())
                && Objects.equals(codeBuildServiceRole(), other.codeBuildServiceRole())
                && Objects.equals(computeTypeAsString(), other.computeTypeAsString()) && Objects.equals(image(), other.image())
                && Objects.equals(timeoutInMinutes(), other.timeoutInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BuildConfiguration").add("ArtifactName", artifactName())
                .add("CodeBuildServiceRole", codeBuildServiceRole()).add("ComputeType", computeTypeAsString())
                .add("Image", image()).add("TimeoutInMinutes", timeoutInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArtifactName":
            return Optional.ofNullable(clazz.cast(artifactName()));
        case "CodeBuildServiceRole":
            return Optional.ofNullable(clazz.cast(codeBuildServiceRole()));
        case "ComputeType":
            return Optional.ofNullable(clazz.cast(computeTypeAsString()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "TimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(timeoutInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ArtifactName", ARTIFACT_NAME_FIELD);
        map.put("CodeBuildServiceRole", CODE_BUILD_SERVICE_ROLE_FIELD);
        map.put("ComputeType", COMPUTE_TYPE_FIELD);
        map.put("Image", IMAGE_FIELD);
        map.put("TimeoutInMinutes", TIMEOUT_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BuildConfiguration, T> g) {
        return obj -> g.apply((BuildConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BuildConfiguration> {
        /**
         * <p>
         * The name of the artifact of the CodeBuild build. If provided, Elastic Beanstalk stores the build artifact in
         * the S3 location
         * <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version-label</i>-<i
         * >artifact-name</i>.zip. If not provided, Elastic Beanstalk stores the build artifact in the S3 location
         * <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version-label</i>.zip.
         * </p>
         * 
         * @param artifactName
         *        The name of the artifact of the CodeBuild build. If provided, Elastic Beanstalk stores the build
         *        artifact in the S3 location
         *        <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version
         *        -label</i>-<i>artifact-name</i>.zip. If not provided, Elastic Beanstalk stores the build artifact in
         *        the S3 location
         *        <i>S3-bucket</i>/resources/<i>application-name</i>/codebuild/codebuild-<i>version-label</i>.zip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactName(String artifactName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS
         * CodeBuild to interact with dependent AWS services on behalf of the AWS account.
         * </p>
         * 
         * @param codeBuildServiceRole
         *        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS
         *        CodeBuild to interact with dependent AWS services on behalf of the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeBuildServiceRole(String codeBuildServiceRole);

        /**
         * <p>
         * Information about the compute resources the build project will use.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param computeType
         *        Information about the compute resources the build project will use.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds</code>
         *        </p>
         *        </li>
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeType(String computeType);

        /**
         * <p>
         * Information about the compute resources the build project will use.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param computeType
         *        Information about the compute resources the build project will use.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds</code>
         *        </p>
         *        </li>
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeType(ComputeType computeType);

        /**
         * <p>
         * The ID of the Docker image to use for this build project.
         * </p>
         * 
         * @param image
         *        The ID of the Docker image to use for this build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * How long in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build
         * that does not get marked as completed. The default is 60 minutes.
         * </p>
         * 
         * @param timeoutInMinutes
         *        How long in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related
         *        build that does not get marked as completed. The default is 60 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMinutes(Integer timeoutInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String artifactName;

        private String codeBuildServiceRole;

        private String computeType;

        private String image;

        private Integer timeoutInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildConfiguration model) {
            artifactName(model.artifactName);
            codeBuildServiceRole(model.codeBuildServiceRole);
            computeType(model.computeType);
            image(model.image);
            timeoutInMinutes(model.timeoutInMinutes);
        }

        public final String getArtifactName() {
            return artifactName;
        }

        public final void setArtifactName(String artifactName) {
            this.artifactName = artifactName;
        }

        @Override
        public final Builder artifactName(String artifactName) {
            this.artifactName = artifactName;
            return this;
        }

        public final String getCodeBuildServiceRole() {
            return codeBuildServiceRole;
        }

        public final void setCodeBuildServiceRole(String codeBuildServiceRole) {
            this.codeBuildServiceRole = codeBuildServiceRole;
        }

        @Override
        public final Builder codeBuildServiceRole(String codeBuildServiceRole) {
            this.codeBuildServiceRole = codeBuildServiceRole;
            return this;
        }

        public final String getComputeType() {
            return computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final String getImage() {
            return image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final Integer getTimeoutInMinutes() {
            return timeoutInMinutes;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        @Override
        public BuildConfiguration build() {
            return new BuildConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
