/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a platform version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlatformDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<PlatformDescription.Builder, PlatformDescription> {
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformArn").getter(getter(PlatformDescription::platformArn)).setter(setter(Builder::platformArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()).build();

    private static final SdkField<String> PLATFORM_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformOwner").getter(getter(PlatformDescription::platformOwner))
            .setter(setter(Builder::platformOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformOwner").build()).build();

    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformName").getter(getter(PlatformDescription::platformName)).setter(setter(Builder::platformName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformVersion").getter(getter(PlatformDescription::platformVersion))
            .setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()).build();

    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SolutionStackName").getter(getter(PlatformDescription::solutionStackName))
            .setter(setter(Builder::solutionStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()).build();

    private static final SdkField<String> PLATFORM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformStatus").getter(getter(PlatformDescription::platformStatusAsString))
            .setter(setter(Builder::platformStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformStatus").build()).build();

    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateCreated").getter(getter(PlatformDescription::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()).build();

    private static final SdkField<Instant> DATE_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateUpdated").getter(getter(PlatformDescription::dateUpdated)).setter(setter(Builder::dateUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateUpdated").build()).build();

    private static final SdkField<String> PLATFORM_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformCategory").getter(getter(PlatformDescription::platformCategory))
            .setter(setter(Builder::platformCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformCategory").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PlatformDescription::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> MAINTAINER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Maintainer").getter(getter(PlatformDescription::maintainer)).setter(setter(Builder::maintainer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maintainer").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingSystemName").getter(getter(PlatformDescription::operatingSystemName))
            .setter(setter(Builder::operatingSystemName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemName").build())
            .build();

    private static final SdkField<String> OPERATING_SYSTEM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingSystemVersion").getter(getter(PlatformDescription::operatingSystemVersion))
            .setter(setter(Builder::operatingSystemVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemVersion").build())
            .build();

    private static final SdkField<List<PlatformProgrammingLanguage>> PROGRAMMING_LANGUAGES_FIELD = SdkField
            .<List<PlatformProgrammingLanguage>> builder(MarshallingType.LIST)
            .memberName("ProgrammingLanguages")
            .getter(getter(PlatformDescription::programmingLanguages))
            .setter(setter(Builder::programmingLanguages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgrammingLanguages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlatformProgrammingLanguage> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlatformProgrammingLanguage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PlatformFramework>> FRAMEWORKS_FIELD = SdkField
            .<List<PlatformFramework>> builder(MarshallingType.LIST)
            .memberName("Frameworks")
            .getter(getter(PlatformDescription::frameworks))
            .setter(setter(Builder::frameworks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frameworks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlatformFramework> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlatformFramework::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CustomAmi>> CUSTOM_AMI_LIST_FIELD = SdkField
            .<List<CustomAmi>> builder(MarshallingType.LIST)
            .memberName("CustomAmiList")
            .getter(getter(PlatformDescription::customAmiList))
            .setter(setter(Builder::customAmiList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAmiList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomAmi> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomAmi::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_TIER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedTierList")
            .getter(getter(PlatformDescription::supportedTierList))
            .setter(setter(Builder::supportedTierList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTierList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_ADDON_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedAddonList")
            .getter(getter(PlatformDescription::supportedAddonList))
            .setter(setter(Builder::supportedAddonList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAddonList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLATFORM_LIFECYCLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformLifecycleState").getter(getter(PlatformDescription::platformLifecycleState))
            .setter(setter(Builder::platformLifecycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformLifecycleState").build())
            .build();

    private static final SdkField<String> PLATFORM_BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformBranchName").getter(getter(PlatformDescription::platformBranchName))
            .setter(setter(Builder::platformBranchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformBranchName").build())
            .build();

    private static final SdkField<String> PLATFORM_BRANCH_LIFECYCLE_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PlatformBranchLifecycleState")
            .getter(getter(PlatformDescription::platformBranchLifecycleState))
            .setter(setter(Builder::platformBranchLifecycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformBranchLifecycleState")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_ARN_FIELD,
            PLATFORM_OWNER_FIELD, PLATFORM_NAME_FIELD, PLATFORM_VERSION_FIELD, SOLUTION_STACK_NAME_FIELD, PLATFORM_STATUS_FIELD,
            DATE_CREATED_FIELD, DATE_UPDATED_FIELD, PLATFORM_CATEGORY_FIELD, DESCRIPTION_FIELD, MAINTAINER_FIELD,
            OPERATING_SYSTEM_NAME_FIELD, OPERATING_SYSTEM_VERSION_FIELD, PROGRAMMING_LANGUAGES_FIELD, FRAMEWORKS_FIELD,
            CUSTOM_AMI_LIST_FIELD, SUPPORTED_TIER_LIST_FIELD, SUPPORTED_ADDON_LIST_FIELD, PLATFORM_LIFECYCLE_STATE_FIELD,
            PLATFORM_BRANCH_NAME_FIELD, PLATFORM_BRANCH_LIFECYCLE_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String platformArn;

    private final String platformOwner;

    private final String platformName;

    private final String platformVersion;

    private final String solutionStackName;

    private final String platformStatus;

    private final Instant dateCreated;

    private final Instant dateUpdated;

    private final String platformCategory;

    private final String description;

    private final String maintainer;

    private final String operatingSystemName;

    private final String operatingSystemVersion;

    private final List<PlatformProgrammingLanguage> programmingLanguages;

    private final List<PlatformFramework> frameworks;

    private final List<CustomAmi> customAmiList;

    private final List<String> supportedTierList;

    private final List<String> supportedAddonList;

    private final String platformLifecycleState;

    private final String platformBranchName;

    private final String platformBranchLifecycleState;

    private PlatformDescription(BuilderImpl builder) {
        this.platformArn = builder.platformArn;
        this.platformOwner = builder.platformOwner;
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.solutionStackName = builder.solutionStackName;
        this.platformStatus = builder.platformStatus;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.platformCategory = builder.platformCategory;
        this.description = builder.description;
        this.maintainer = builder.maintainer;
        this.operatingSystemName = builder.operatingSystemName;
        this.operatingSystemVersion = builder.operatingSystemVersion;
        this.programmingLanguages = builder.programmingLanguages;
        this.frameworks = builder.frameworks;
        this.customAmiList = builder.customAmiList;
        this.supportedTierList = builder.supportedTierList;
        this.supportedAddonList = builder.supportedAddonList;
        this.platformLifecycleState = builder.platformLifecycleState;
        this.platformBranchName = builder.platformBranchName;
        this.platformBranchLifecycleState = builder.platformBranchLifecycleState;
    }

    /**
     * <p>
     * The ARN of the platform version.
     * </p>
     * 
     * @return The ARN of the platform version.
     */
    public final String platformArn() {
        return platformArn;
    }

    /**
     * <p>
     * The AWS account ID of the person who created the platform version.
     * </p>
     * 
     * @return The AWS account ID of the person who created the platform version.
     */
    public final String platformOwner() {
        return platformOwner;
    }

    /**
     * <p>
     * The name of the platform version.
     * </p>
     * 
     * @return The name of the platform version.
     */
    public final String platformName() {
        return platformName;
    }

    /**
     * <p>
     * The version of the platform version.
     * </p>
     * 
     * @return The version of the platform version.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The name of the solution stack used by the platform version.
     * </p>
     * 
     * @return The name of the solution stack used by the platform version.
     */
    public final String solutionStackName() {
        return solutionStackName;
    }

    /**
     * <p>
     * The status of the platform version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformStatus}
     * will return {@link PlatformStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #platformStatusAsString}.
     * </p>
     * 
     * @return The status of the platform version.
     * @see PlatformStatus
     */
    public final PlatformStatus platformStatus() {
        return PlatformStatus.fromValue(platformStatus);
    }

    /**
     * <p>
     * The status of the platform version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformStatus}
     * will return {@link PlatformStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #platformStatusAsString}.
     * </p>
     * 
     * @return The status of the platform version.
     * @see PlatformStatus
     */
    public final String platformStatusAsString() {
        return platformStatus;
    }

    /**
     * <p>
     * The date when the platform version was created.
     * </p>
     * 
     * @return The date when the platform version was created.
     */
    public final Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The date when the platform version was last updated.
     * </p>
     * 
     * @return The date when the platform version was last updated.
     */
    public final Instant dateUpdated() {
        return dateUpdated;
    }

    /**
     * <p>
     * The category of the platform version.
     * </p>
     * 
     * @return The category of the platform version.
     */
    public final String platformCategory() {
        return platformCategory;
    }

    /**
     * <p>
     * The description of the platform version.
     * </p>
     * 
     * @return The description of the platform version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the maintainer of the platform version.
     * </p>
     * 
     * @return Information about the maintainer of the platform version.
     */
    public final String maintainer() {
        return maintainer;
    }

    /**
     * <p>
     * The operating system used by the platform version.
     * </p>
     * 
     * @return The operating system used by the platform version.
     */
    public final String operatingSystemName() {
        return operatingSystemName;
    }

    /**
     * <p>
     * The version of the operating system used by the platform version.
     * </p>
     * 
     * @return The version of the operating system used by the platform version.
     */
    public final String operatingSystemVersion() {
        return operatingSystemVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProgrammingLanguages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProgrammingLanguages() {
        return programmingLanguages != null && !(programmingLanguages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The programming languages supported by the platform version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProgrammingLanguages} method.
     * </p>
     * 
     * @return The programming languages supported by the platform version.
     */
    public final List<PlatformProgrammingLanguage> programmingLanguages() {
        return programmingLanguages;
    }

    /**
     * For responses, this returns true if the service returned a value for the Frameworks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFrameworks() {
        return frameworks != null && !(frameworks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The frameworks supported by the platform version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFrameworks} method.
     * </p>
     * 
     * @return The frameworks supported by the platform version.
     */
    public final List<PlatformFramework> frameworks() {
        return frameworks;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomAmiList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomAmiList() {
        return customAmiList != null && !(customAmiList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom AMIs supported by the platform version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomAmiList} method.
     * </p>
     * 
     * @return The custom AMIs supported by the platform version.
     */
    public final List<CustomAmi> customAmiList() {
        return customAmiList;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedTierList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedTierList() {
        return supportedTierList != null && !(supportedTierList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tiers supported by the platform version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedTierList} method.
     * </p>
     * 
     * @return The tiers supported by the platform version.
     */
    public final List<String> supportedTierList() {
        return supportedTierList;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedAddonList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedAddonList() {
        return supportedAddonList != null && !(supportedAddonList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The additions supported by the platform version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedAddonList} method.
     * </p>
     * 
     * @return The additions supported by the platform version.
     */
    public final List<String> supportedAddonList() {
        return supportedAddonList;
    }

    /**
     * <p>
     * The state of the platform version in its lifecycle.
     * </p>
     * <p>
     * Possible values: <code>Recommended</code> | <code>null</code>
     * </p>
     * <p>
     * If a null value is returned, the platform version isn't the recommended one for its branch. Each platform branch
     * has a single recommended platform version, typically the most recent one.
     * </p>
     * 
     * @return The state of the platform version in its lifecycle.</p>
     *         <p>
     *         Possible values: <code>Recommended</code> | <code>null</code>
     *         </p>
     *         <p>
     *         If a null value is returned, the platform version isn't the recommended one for its branch. Each platform
     *         branch has a single recommended platform version, typically the most recent one.
     */
    public final String platformLifecycleState() {
        return platformLifecycleState;
    }

    /**
     * <p>
     * The platform branch to which the platform version belongs.
     * </p>
     * 
     * @return The platform branch to which the platform version belongs.
     */
    public final String platformBranchName() {
        return platformBranchName;
    }

    /**
     * <p>
     * The state of the platform version's branch in its lifecycle.
     * </p>
     * <p>
     * Possible values: <code>Beta</code> | <code>Supported</code> | <code>Deprecated</code> | <code>Retired</code>
     * </p>
     * 
     * @return The state of the platform version's branch in its lifecycle.</p>
     *         <p>
     *         Possible values: <code>Beta</code> | <code>Supported</code> | <code>Deprecated</code> |
     *         <code>Retired</code>
     */
    public final String platformBranchLifecycleState() {
        return platformBranchLifecycleState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(platformOwner());
        hashCode = 31 * hashCode + Objects.hashCode(platformName());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(platformStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(platformCategory());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(maintainer());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemName());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasProgrammingLanguages() ? programmingLanguages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFrameworks() ? frameworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomAmiList() ? customAmiList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedTierList() ? supportedTierList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedAddonList() ? supportedAddonList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(platformLifecycleState());
        hashCode = 31 * hashCode + Objects.hashCode(platformBranchName());
        hashCode = 31 * hashCode + Objects.hashCode(platformBranchLifecycleState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformDescription)) {
            return false;
        }
        PlatformDescription other = (PlatformDescription) obj;
        return Objects.equals(platformArn(), other.platformArn()) && Objects.equals(platformOwner(), other.platformOwner())
                && Objects.equals(platformName(), other.platformName())
                && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(solutionStackName(), other.solutionStackName())
                && Objects.equals(platformStatusAsString(), other.platformStatusAsString())
                && Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(dateUpdated(), other.dateUpdated())
                && Objects.equals(platformCategory(), other.platformCategory())
                && Objects.equals(description(), other.description()) && Objects.equals(maintainer(), other.maintainer())
                && Objects.equals(operatingSystemName(), other.operatingSystemName())
                && Objects.equals(operatingSystemVersion(), other.operatingSystemVersion())
                && hasProgrammingLanguages() == other.hasProgrammingLanguages()
                && Objects.equals(programmingLanguages(), other.programmingLanguages())
                && hasFrameworks() == other.hasFrameworks() && Objects.equals(frameworks(), other.frameworks())
                && hasCustomAmiList() == other.hasCustomAmiList() && Objects.equals(customAmiList(), other.customAmiList())
                && hasSupportedTierList() == other.hasSupportedTierList()
                && Objects.equals(supportedTierList(), other.supportedTierList())
                && hasSupportedAddonList() == other.hasSupportedAddonList()
                && Objects.equals(supportedAddonList(), other.supportedAddonList())
                && Objects.equals(platformLifecycleState(), other.platformLifecycleState())
                && Objects.equals(platformBranchName(), other.platformBranchName())
                && Objects.equals(platformBranchLifecycleState(), other.platformBranchLifecycleState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PlatformDescription").add("PlatformArn", platformArn()).add("PlatformOwner", platformOwner())
                .add("PlatformName", platformName()).add("PlatformVersion", platformVersion())
                .add("SolutionStackName", solutionStackName()).add("PlatformStatus", platformStatusAsString())
                .add("DateCreated", dateCreated()).add("DateUpdated", dateUpdated()).add("PlatformCategory", platformCategory())
                .add("Description", description()).add("Maintainer", maintainer())
                .add("OperatingSystemName", operatingSystemName()).add("OperatingSystemVersion", operatingSystemVersion())
                .add("ProgrammingLanguages", hasProgrammingLanguages() ? programmingLanguages() : null)
                .add("Frameworks", hasFrameworks() ? frameworks() : null)
                .add("CustomAmiList", hasCustomAmiList() ? customAmiList() : null)
                .add("SupportedTierList", hasSupportedTierList() ? supportedTierList() : null)
                .add("SupportedAddonList", hasSupportedAddonList() ? supportedAddonList() : null)
                .add("PlatformLifecycleState", platformLifecycleState()).add("PlatformBranchName", platformBranchName())
                .add("PlatformBranchLifecycleState", platformBranchLifecycleState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformArn":
            return Optional.ofNullable(clazz.cast(platformArn()));
        case "PlatformOwner":
            return Optional.ofNullable(clazz.cast(platformOwner()));
        case "PlatformName":
            return Optional.ofNullable(clazz.cast(platformName()));
        case "PlatformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "SolutionStackName":
            return Optional.ofNullable(clazz.cast(solutionStackName()));
        case "PlatformStatus":
            return Optional.ofNullable(clazz.cast(platformStatusAsString()));
        case "DateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "DateUpdated":
            return Optional.ofNullable(clazz.cast(dateUpdated()));
        case "PlatformCategory":
            return Optional.ofNullable(clazz.cast(platformCategory()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Maintainer":
            return Optional.ofNullable(clazz.cast(maintainer()));
        case "OperatingSystemName":
            return Optional.ofNullable(clazz.cast(operatingSystemName()));
        case "OperatingSystemVersion":
            return Optional.ofNullable(clazz.cast(operatingSystemVersion()));
        case "ProgrammingLanguages":
            return Optional.ofNullable(clazz.cast(programmingLanguages()));
        case "Frameworks":
            return Optional.ofNullable(clazz.cast(frameworks()));
        case "CustomAmiList":
            return Optional.ofNullable(clazz.cast(customAmiList()));
        case "SupportedTierList":
            return Optional.ofNullable(clazz.cast(supportedTierList()));
        case "SupportedAddonList":
            return Optional.ofNullable(clazz.cast(supportedAddonList()));
        case "PlatformLifecycleState":
            return Optional.ofNullable(clazz.cast(platformLifecycleState()));
        case "PlatformBranchName":
            return Optional.ofNullable(clazz.cast(platformBranchName()));
        case "PlatformBranchLifecycleState":
            return Optional.ofNullable(clazz.cast(platformBranchLifecycleState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PlatformArn", PLATFORM_ARN_FIELD);
        map.put("PlatformOwner", PLATFORM_OWNER_FIELD);
        map.put("PlatformName", PLATFORM_NAME_FIELD);
        map.put("PlatformVersion", PLATFORM_VERSION_FIELD);
        map.put("SolutionStackName", SOLUTION_STACK_NAME_FIELD);
        map.put("PlatformStatus", PLATFORM_STATUS_FIELD);
        map.put("DateCreated", DATE_CREATED_FIELD);
        map.put("DateUpdated", DATE_UPDATED_FIELD);
        map.put("PlatformCategory", PLATFORM_CATEGORY_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Maintainer", MAINTAINER_FIELD);
        map.put("OperatingSystemName", OPERATING_SYSTEM_NAME_FIELD);
        map.put("OperatingSystemVersion", OPERATING_SYSTEM_VERSION_FIELD);
        map.put("ProgrammingLanguages", PROGRAMMING_LANGUAGES_FIELD);
        map.put("Frameworks", FRAMEWORKS_FIELD);
        map.put("CustomAmiList", CUSTOM_AMI_LIST_FIELD);
        map.put("SupportedTierList", SUPPORTED_TIER_LIST_FIELD);
        map.put("SupportedAddonList", SUPPORTED_ADDON_LIST_FIELD);
        map.put("PlatformLifecycleState", PLATFORM_LIFECYCLE_STATE_FIELD);
        map.put("PlatformBranchName", PLATFORM_BRANCH_NAME_FIELD);
        map.put("PlatformBranchLifecycleState", PLATFORM_BRANCH_LIFECYCLE_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PlatformDescription, T> g) {
        return obj -> g.apply((PlatformDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlatformDescription> {
        /**
         * <p>
         * The ARN of the platform version.
         * </p>
         * 
         * @param platformArn
         *        The ARN of the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformArn(String platformArn);

        /**
         * <p>
         * The AWS account ID of the person who created the platform version.
         * </p>
         * 
         * @param platformOwner
         *        The AWS account ID of the person who created the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformOwner(String platformOwner);

        /**
         * <p>
         * The name of the platform version.
         * </p>
         * 
         * @param platformName
         *        The name of the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformName(String platformName);

        /**
         * <p>
         * The version of the platform version.
         * </p>
         * 
         * @param platformVersion
         *        The version of the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The name of the solution stack used by the platform version.
         * </p>
         * 
         * @param solutionStackName
         *        The name of the solution stack used by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionStackName(String solutionStackName);

        /**
         * <p>
         * The status of the platform version.
         * </p>
         * 
         * @param platformStatus
         *        The status of the platform version.
         * @see PlatformStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformStatus
         */
        Builder platformStatus(String platformStatus);

        /**
         * <p>
         * The status of the platform version.
         * </p>
         * 
         * @param platformStatus
         *        The status of the platform version.
         * @see PlatformStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformStatus
         */
        Builder platformStatus(PlatformStatus platformStatus);

        /**
         * <p>
         * The date when the platform version was created.
         * </p>
         * 
         * @param dateCreated
         *        The date when the platform version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * The date when the platform version was last updated.
         * </p>
         * 
         * @param dateUpdated
         *        The date when the platform version was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateUpdated(Instant dateUpdated);

        /**
         * <p>
         * The category of the platform version.
         * </p>
         * 
         * @param platformCategory
         *        The category of the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformCategory(String platformCategory);

        /**
         * <p>
         * The description of the platform version.
         * </p>
         * 
         * @param description
         *        The description of the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the maintainer of the platform version.
         * </p>
         * 
         * @param maintainer
         *        Information about the maintainer of the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintainer(String maintainer);

        /**
         * <p>
         * The operating system used by the platform version.
         * </p>
         * 
         * @param operatingSystemName
         *        The operating system used by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemName(String operatingSystemName);

        /**
         * <p>
         * The version of the operating system used by the platform version.
         * </p>
         * 
         * @param operatingSystemVersion
         *        The version of the operating system used by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemVersion(String operatingSystemVersion);

        /**
         * <p>
         * The programming languages supported by the platform version.
         * </p>
         * 
         * @param programmingLanguages
         *        The programming languages supported by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programmingLanguages(Collection<PlatformProgrammingLanguage> programmingLanguages);

        /**
         * <p>
         * The programming languages supported by the platform version.
         * </p>
         * 
         * @param programmingLanguages
         *        The programming languages supported by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programmingLanguages(PlatformProgrammingLanguage... programmingLanguages);

        /**
         * <p>
         * The programming languages supported by the platform version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformProgrammingLanguage.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformProgrammingLanguage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformProgrammingLanguage.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #programmingLanguages(List<PlatformProgrammingLanguage>)}.
         * 
         * @param programmingLanguages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformProgrammingLanguage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #programmingLanguages(java.util.Collection<PlatformProgrammingLanguage>)
         */
        Builder programmingLanguages(Consumer<PlatformProgrammingLanguage.Builder>... programmingLanguages);

        /**
         * <p>
         * The frameworks supported by the platform version.
         * </p>
         * 
         * @param frameworks
         *        The frameworks supported by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworks(Collection<PlatformFramework> frameworks);

        /**
         * <p>
         * The frameworks supported by the platform version.
         * </p>
         * 
         * @param frameworks
         *        The frameworks supported by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworks(PlatformFramework... frameworks);

        /**
         * <p>
         * The frameworks supported by the platform version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFramework.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFramework#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFramework.Builder#build()} is called
         * immediately and its result is passed to {@link #frameworks(List<PlatformFramework>)}.
         * 
         * @param frameworks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFramework.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameworks(java.util.Collection<PlatformFramework>)
         */
        Builder frameworks(Consumer<PlatformFramework.Builder>... frameworks);

        /**
         * <p>
         * The custom AMIs supported by the platform version.
         * </p>
         * 
         * @param customAmiList
         *        The custom AMIs supported by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAmiList(Collection<CustomAmi> customAmiList);

        /**
         * <p>
         * The custom AMIs supported by the platform version.
         * </p>
         * 
         * @param customAmiList
         *        The custom AMIs supported by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAmiList(CustomAmi... customAmiList);

        /**
         * <p>
         * The custom AMIs supported by the platform version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.CustomAmi.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.elasticbeanstalk.model.CustomAmi#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.CustomAmi.Builder#build()} is called
         * immediately and its result is passed to {@link #customAmiList(List<CustomAmi>)}.
         * 
         * @param customAmiList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticbeanstalk.model.CustomAmi.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customAmiList(java.util.Collection<CustomAmi>)
         */
        Builder customAmiList(Consumer<CustomAmi.Builder>... customAmiList);

        /**
         * <p>
         * The tiers supported by the platform version.
         * </p>
         * 
         * @param supportedTierList
         *        The tiers supported by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTierList(Collection<String> supportedTierList);

        /**
         * <p>
         * The tiers supported by the platform version.
         * </p>
         * 
         * @param supportedTierList
         *        The tiers supported by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTierList(String... supportedTierList);

        /**
         * <p>
         * The additions supported by the platform version.
         * </p>
         * 
         * @param supportedAddonList
         *        The additions supported by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAddonList(Collection<String> supportedAddonList);

        /**
         * <p>
         * The additions supported by the platform version.
         * </p>
         * 
         * @param supportedAddonList
         *        The additions supported by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAddonList(String... supportedAddonList);

        /**
         * <p>
         * The state of the platform version in its lifecycle.
         * </p>
         * <p>
         * Possible values: <code>Recommended</code> | <code>null</code>
         * </p>
         * <p>
         * If a null value is returned, the platform version isn't the recommended one for its branch. Each platform
         * branch has a single recommended platform version, typically the most recent one.
         * </p>
         * 
         * @param platformLifecycleState
         *        The state of the platform version in its lifecycle.</p>
         *        <p>
         *        Possible values: <code>Recommended</code> | <code>null</code>
         *        </p>
         *        <p>
         *        If a null value is returned, the platform version isn't the recommended one for its branch. Each
         *        platform branch has a single recommended platform version, typically the most recent one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformLifecycleState(String platformLifecycleState);

        /**
         * <p>
         * The platform branch to which the platform version belongs.
         * </p>
         * 
         * @param platformBranchName
         *        The platform branch to which the platform version belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformBranchName(String platformBranchName);

        /**
         * <p>
         * The state of the platform version's branch in its lifecycle.
         * </p>
         * <p>
         * Possible values: <code>Beta</code> | <code>Supported</code> | <code>Deprecated</code> | <code>Retired</code>
         * </p>
         * 
         * @param platformBranchLifecycleState
         *        The state of the platform version's branch in its lifecycle.</p>
         *        <p>
         *        Possible values: <code>Beta</code> | <code>Supported</code> | <code>Deprecated</code> |
         *        <code>Retired</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformBranchLifecycleState(String platformBranchLifecycleState);
    }

    static final class BuilderImpl implements Builder {
        private String platformArn;

        private String platformOwner;

        private String platformName;

        private String platformVersion;

        private String solutionStackName;

        private String platformStatus;

        private Instant dateCreated;

        private Instant dateUpdated;

        private String platformCategory;

        private String description;

        private String maintainer;

        private String operatingSystemName;

        private String operatingSystemVersion;

        private List<PlatformProgrammingLanguage> programmingLanguages = DefaultSdkAutoConstructList.getInstance();

        private List<PlatformFramework> frameworks = DefaultSdkAutoConstructList.getInstance();

        private List<CustomAmi> customAmiList = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedTierList = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedAddonList = DefaultSdkAutoConstructList.getInstance();

        private String platformLifecycleState;

        private String platformBranchName;

        private String platformBranchLifecycleState;

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformDescription model) {
            platformArn(model.platformArn);
            platformOwner(model.platformOwner);
            platformName(model.platformName);
            platformVersion(model.platformVersion);
            solutionStackName(model.solutionStackName);
            platformStatus(model.platformStatus);
            dateCreated(model.dateCreated);
            dateUpdated(model.dateUpdated);
            platformCategory(model.platformCategory);
            description(model.description);
            maintainer(model.maintainer);
            operatingSystemName(model.operatingSystemName);
            operatingSystemVersion(model.operatingSystemVersion);
            programmingLanguages(model.programmingLanguages);
            frameworks(model.frameworks);
            customAmiList(model.customAmiList);
            supportedTierList(model.supportedTierList);
            supportedAddonList(model.supportedAddonList);
            platformLifecycleState(model.platformLifecycleState);
            platformBranchName(model.platformBranchName);
            platformBranchLifecycleState(model.platformBranchLifecycleState);
        }

        public final String getPlatformArn() {
            return platformArn;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final String getPlatformOwner() {
            return platformOwner;
        }

        public final void setPlatformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
        }

        @Override
        public final Builder platformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
            return this;
        }

        public final String getPlatformName() {
            return platformName;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getSolutionStackName() {
            return solutionStackName;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final String getPlatformStatus() {
            return platformStatus;
        }

        public final void setPlatformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
        }

        @Override
        public final Builder platformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
            return this;
        }

        @Override
        public final Builder platformStatus(PlatformStatus platformStatus) {
            this.platformStatus(platformStatus == null ? null : platformStatus.toString());
            return this;
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateUpdated() {
            return dateUpdated;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final String getPlatformCategory() {
            return platformCategory;
        }

        public final void setPlatformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
        }

        @Override
        public final Builder platformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMaintainer() {
            return maintainer;
        }

        public final void setMaintainer(String maintainer) {
            this.maintainer = maintainer;
        }

        @Override
        public final Builder maintainer(String maintainer) {
            this.maintainer = maintainer;
            return this;
        }

        public final String getOperatingSystemName() {
            return operatingSystemName;
        }

        public final void setOperatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
        }

        @Override
        public final Builder operatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
            return this;
        }

        public final String getOperatingSystemVersion() {
            return operatingSystemVersion;
        }

        public final void setOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
        }

        @Override
        public final Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        public final List<PlatformProgrammingLanguage.Builder> getProgrammingLanguages() {
            List<PlatformProgrammingLanguage.Builder> result = PlatformProgrammingLanguagesCopier
                    .copyToBuilder(this.programmingLanguages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProgrammingLanguages(Collection<PlatformProgrammingLanguage.BuilderImpl> programmingLanguages) {
            this.programmingLanguages = PlatformProgrammingLanguagesCopier.copyFromBuilder(programmingLanguages);
        }

        @Override
        public final Builder programmingLanguages(Collection<PlatformProgrammingLanguage> programmingLanguages) {
            this.programmingLanguages = PlatformProgrammingLanguagesCopier.copy(programmingLanguages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programmingLanguages(PlatformProgrammingLanguage... programmingLanguages) {
            programmingLanguages(Arrays.asList(programmingLanguages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programmingLanguages(Consumer<PlatformProgrammingLanguage.Builder>... programmingLanguages) {
            programmingLanguages(Stream.of(programmingLanguages)
                    .map(c -> PlatformProgrammingLanguage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PlatformFramework.Builder> getFrameworks() {
            List<PlatformFramework.Builder> result = PlatformFrameworksCopier.copyToBuilder(this.frameworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFrameworks(Collection<PlatformFramework.BuilderImpl> frameworks) {
            this.frameworks = PlatformFrameworksCopier.copyFromBuilder(frameworks);
        }

        @Override
        public final Builder frameworks(Collection<PlatformFramework> frameworks) {
            this.frameworks = PlatformFrameworksCopier.copy(frameworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworks(PlatformFramework... frameworks) {
            frameworks(Arrays.asList(frameworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworks(Consumer<PlatformFramework.Builder>... frameworks) {
            frameworks(Stream.of(frameworks).map(c -> PlatformFramework.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CustomAmi.Builder> getCustomAmiList() {
            List<CustomAmi.Builder> result = CustomAmiListCopier.copyToBuilder(this.customAmiList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomAmiList(Collection<CustomAmi.BuilderImpl> customAmiList) {
            this.customAmiList = CustomAmiListCopier.copyFromBuilder(customAmiList);
        }

        @Override
        public final Builder customAmiList(Collection<CustomAmi> customAmiList) {
            this.customAmiList = CustomAmiListCopier.copy(customAmiList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmiList(CustomAmi... customAmiList) {
            customAmiList(Arrays.asList(customAmiList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmiList(Consumer<CustomAmi.Builder>... customAmiList) {
            customAmiList(Stream.of(customAmiList).map(c -> CustomAmi.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSupportedTierList() {
            if (supportedTierList instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedTierList;
        }

        public final void setSupportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
        }

        @Override
        public final Builder supportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTierList(String... supportedTierList) {
            supportedTierList(Arrays.asList(supportedTierList));
            return this;
        }

        public final Collection<String> getSupportedAddonList() {
            if (supportedAddonList instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedAddonList;
        }

        public final void setSupportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
        }

        @Override
        public final Builder supportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAddonList(String... supportedAddonList) {
            supportedAddonList(Arrays.asList(supportedAddonList));
            return this;
        }

        public final String getPlatformLifecycleState() {
            return platformLifecycleState;
        }

        public final void setPlatformLifecycleState(String platformLifecycleState) {
            this.platformLifecycleState = platformLifecycleState;
        }

        @Override
        public final Builder platformLifecycleState(String platformLifecycleState) {
            this.platformLifecycleState = platformLifecycleState;
            return this;
        }

        public final String getPlatformBranchName() {
            return platformBranchName;
        }

        public final void setPlatformBranchName(String platformBranchName) {
            this.platformBranchName = platformBranchName;
        }

        @Override
        public final Builder platformBranchName(String platformBranchName) {
            this.platformBranchName = platformBranchName;
            return this;
        }

        public final String getPlatformBranchLifecycleState() {
            return platformBranchLifecycleState;
        }

        public final void setPlatformBranchLifecycleState(String platformBranchLifecycleState) {
            this.platformBranchLifecycleState = platformBranchLifecycleState;
        }

        @Override
        public final Builder platformBranchLifecycleState(String platformBranchLifecycleState) {
            this.platformBranchLifecycleState = platformBranchLifecycleState;
            return this;
        }

        @Override
        public PlatformDescription build() {
            return new PlatformDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
