/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthAttribute;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEnvironmentHealthRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, DescribeEnvironmentHealthRequest> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentName").getter(DescribeEnvironmentHealthRequest.getter(DescribeEnvironmentHealthRequest::environmentName)).setter(DescribeEnvironmentHealthRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(DescribeEnvironmentHealthRequest.getter(DescribeEnvironmentHealthRequest::environmentId)).setter(DescribeEnvironmentHealthRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeNames").getter(DescribeEnvironmentHealthRequest.getter(DescribeEnvironmentHealthRequest::attributeNamesAsStrings)).setter(DescribeEnvironmentHealthRequest.setter(Builder::attributeNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD, ENVIRONMENT_ID_FIELD, ATTRIBUTE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeEnvironmentHealthRequest.memberNameToFieldInitializer();
    private final String environmentName;
    private final String environmentId;
    private final List<String> attributeNames;

    private DescribeEnvironmentHealthRequest(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.environmentId = builder.environmentId;
        this.attributeNames = builder.attributeNames;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final List<EnvironmentHealthAttribute> attributeNames() {
        return EnvironmentHealthAttributesCopier.copyStringToEnum(this.attributeNames);
    }

    public final boolean hasAttributeNames() {
        return this.attributeNames != null && !(this.attributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> attributeNamesAsStrings() {
        return this.attributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeNames() ? this.attributeNamesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentHealthRequest)) {
            return false;
        }
        DescribeEnvironmentHealthRequest other = (DescribeEnvironmentHealthRequest)((Object)obj);
        return Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.environmentId(), other.environmentId()) && this.hasAttributeNames() == other.hasAttributeNames() && Objects.equals(this.attributeNamesAsStrings(), other.attributeNamesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEnvironmentHealthRequest").add("EnvironmentName", (Object)this.environmentName()).add("EnvironmentId", (Object)this.environmentId()).add("AttributeNames", this.hasAttributeNames() ? this.attributeNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNamesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EnvironmentName", ENVIRONMENT_NAME_FIELD);
        map.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
        map.put("AttributeNames", ATTRIBUTE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentHealthRequest, T> g) {
        return obj -> g.apply((DescribeEnvironmentHealthRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String environmentName;
        private String environmentId;
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentHealthRequest model) {
            super(model);
            this.environmentName(model.environmentName);
            this.environmentId(model.environmentId);
            this.attributeNamesWithStrings(model.attributeNames);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (this.attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = EnvironmentHealthAttributesCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNamesWithStrings(Collection<String> attributeNames) {
            this.attributeNames = EnvironmentHealthAttributesCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNamesWithStrings(String ... attributeNames) {
            this.attributeNamesWithStrings(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        public final Builder attributeNames(Collection<EnvironmentHealthAttribute> attributeNames) {
            this.attributeNames = EnvironmentHealthAttributesCopier.copyEnumToString(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(EnvironmentHealthAttribute ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEnvironmentHealthRequest build() {
            return new DescribeEnvironmentHealthRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEnvironmentHealthRequest> {
        public Builder environmentName(String var1);

        public Builder environmentId(String var1);

        public Builder attributeNamesWithStrings(Collection<String> var1);

        public Builder attributeNamesWithStrings(String ... var1);

        public Builder attributeNames(Collection<EnvironmentHealthAttribute> var1);

        public Builder attributeNames(EnvironmentHealthAttribute ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

