/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPlatformVersionsResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<ListPlatformVersionsResponse.Builder, ListPlatformVersionsResponse> {
    private static final SdkField<List<PlatformSummary>> PLATFORM_SUMMARY_LIST_FIELD = SdkField
            .<List<PlatformSummary>> builder(MarshallingType.LIST)
            .memberName("PlatformSummaryList")
            .getter(getter(ListPlatformVersionsResponse::platformSummaryList))
            .setter(setter(Builder::platformSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlatformSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlatformSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPlatformVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PlatformSummary> platformSummaryList;

    private final String nextToken;

    private ListPlatformVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.platformSummaryList = builder.platformSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlatformSummaryList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlatformSummaryList() {
        return platformSummaryList != null && !(platformSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about the platform versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlatformSummaryList} method.
     * </p>
     * 
     * @return Summary information about the platform versions.
     */
    public final List<PlatformSummary> platformSummaryList() {
        return platformSummaryList;
    }

    /**
     * <p>
     * In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a subsequent
     * request to get the next response page.
     * </p>
     * 
     * @return In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a
     *         subsequent request to get the next response page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPlatformSummaryList() ? platformSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformVersionsResponse)) {
            return false;
        }
        ListPlatformVersionsResponse other = (ListPlatformVersionsResponse) obj;
        return hasPlatformSummaryList() == other.hasPlatformSummaryList()
                && Objects.equals(platformSummaryList(), other.platformSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPlatformVersionsResponse")
                .add("PlatformSummaryList", hasPlatformSummaryList() ? platformSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformSummaryList":
            return Optional.ofNullable(clazz.cast(platformSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PlatformSummaryList", PLATFORM_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPlatformVersionsResponse, T> g) {
        return obj -> g.apply((ListPlatformVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPlatformVersionsResponse> {
        /**
         * <p>
         * Summary information about the platform versions.
         * </p>
         * 
         * @param platformSummaryList
         *        Summary information about the platform versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformSummaryList(Collection<PlatformSummary> platformSummaryList);

        /**
         * <p>
         * Summary information about the platform versions.
         * </p>
         * 
         * @param platformSummaryList
         *        Summary information about the platform versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformSummaryList(PlatformSummary... platformSummaryList);

        /**
         * <p>
         * Summary information about the platform versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #platformSummaryList(List<PlatformSummary>)}.
         * 
         * @param platformSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platformSummaryList(java.util.Collection<PlatformSummary>)
         */
        Builder platformSummaryList(Consumer<PlatformSummary.Builder>... platformSummaryList);

        /**
         * <p>
         * In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a
         * subsequent request to get the next response page.
         * </p>
         * 
         * @param nextToken
         *        In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a
         *        subsequent request to get the next response page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<PlatformSummary> platformSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformVersionsResponse model) {
            super(model);
            platformSummaryList(model.platformSummaryList);
            nextToken(model.nextToken);
        }

        public final List<PlatformSummary.Builder> getPlatformSummaryList() {
            List<PlatformSummary.Builder> result = PlatformSummaryListCopier.copyToBuilder(this.platformSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlatformSummaryList(Collection<PlatformSummary.BuilderImpl> platformSummaryList) {
            this.platformSummaryList = PlatformSummaryListCopier.copyFromBuilder(platformSummaryList);
        }

        @Override
        public final Builder platformSummaryList(Collection<PlatformSummary> platformSummaryList) {
            this.platformSummaryList = PlatformSummaryListCopier.copy(platformSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformSummaryList(PlatformSummary... platformSummaryList) {
            platformSummaryList(Arrays.asList(platformSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformSummaryList(Consumer<PlatformSummary.Builder>... platformSummaryList) {
            platformSummaryList(Stream.of(platformSummaryList).map(c -> PlatformSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPlatformVersionsResponse build() {
            return new ListPlatformVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
