/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to delete an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteApplicationRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<DeleteApplicationRequest.Builder, DeleteApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteApplicationRequest::applicationName)).setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<Boolean> TERMINATE_ENV_BY_FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteApplicationRequest::terminateEnvByForce)).setter(setter(Builder::terminateEnvByForce))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateEnvByForce").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            TERMINATE_ENV_BY_FORCE_FIELD));

    private final String applicationName;

    private final Boolean terminateEnvByForce;

    private DeleteApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.terminateEnvByForce = builder.terminateEnvByForce;
    }

    /**
     * <p>
     * The name of the application to delete.
     * </p>
     * 
     * @return The name of the application to delete.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * When set to true, running environments will be terminated before deleting the application.
     * </p>
     * 
     * @return When set to true, running environments will be terminated before deleting the application.
     */
    public Boolean terminateEnvByForce() {
        return terminateEnvByForce;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(terminateEnvByForce());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationRequest)) {
            return false;
        }
        DeleteApplicationRequest other = (DeleteApplicationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(terminateEnvByForce(), other.terminateEnvByForce());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteApplicationRequest").add("ApplicationName", applicationName())
                .add("TerminateEnvByForce", terminateEnvByForce()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "TerminateEnvByForce":
            return Optional.ofNullable(clazz.cast(terminateEnvByForce()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationRequest, T> g) {
        return obj -> g.apply((DeleteApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteApplicationRequest> {
        /**
         * <p>
         * The name of the application to delete.
         * </p>
         * 
         * @param applicationName
         *        The name of the application to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * When set to true, running environments will be terminated before deleting the application.
         * </p>
         * 
         * @param terminateEnvByForce
         *        When set to true, running environments will be terminated before deleting the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateEnvByForce(Boolean terminateEnvByForce);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String applicationName;

        private Boolean terminateEnvByForce;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationRequest model) {
            super(model);
            applicationName(model.applicationName);
            terminateEnvByForce(model.terminateEnvByForce);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Boolean getTerminateEnvByForce() {
            return terminateEnvByForce;
        }

        @Override
        public final Builder terminateEnvByForce(Boolean terminateEnvByForce) {
            this.terminateEnvByForce = terminateEnvByForce;
            return this;
        }

        public final void setTerminateEnvByForce(Boolean terminateEnvByForce) {
            this.terminateEnvByForce = terminateEnvByForce;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationRequest build() {
            return new DeleteApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
