/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticinference.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticinference.model.AcceleratorTypeNameListCopier;
import software.amazon.awssdk.services.elasticinference.model.ElasticInferenceRequest;
import software.amazon.awssdk.services.elasticinference.model.LocationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAcceleratorOfferingsRequest
extends ElasticInferenceRequest
implements ToCopyableBuilder<Builder, DescribeAcceleratorOfferingsRequest> {
    private static final SdkField<String> LOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locationType").getter(DescribeAcceleratorOfferingsRequest.getter(DescribeAcceleratorOfferingsRequest::locationTypeAsString)).setter(DescribeAcceleratorOfferingsRequest.setter(Builder::locationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationType").build()}).build();
    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("acceleratorTypes").getter(DescribeAcceleratorOfferingsRequest.getter(DescribeAcceleratorOfferingsRequest::acceleratorTypes)).setter(DescribeAcceleratorOfferingsRequest.setter(Builder::acceleratorTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_TYPE_FIELD, ACCELERATOR_TYPES_FIELD));
    private final String locationType;
    private final List<String> acceleratorTypes;

    private DescribeAcceleratorOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.locationType = builder.locationType;
        this.acceleratorTypes = builder.acceleratorTypes;
    }

    public LocationType locationType() {
        return LocationType.fromValue(this.locationType);
    }

    public String locationTypeAsString() {
        return this.locationType;
    }

    public boolean hasAcceleratorTypes() {
        return this.acceleratorTypes != null && !(this.acceleratorTypes instanceof SdkAutoConstructList);
    }

    public List<String> acceleratorTypes() {
        return this.acceleratorTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorTypes() ? this.acceleratorTypes() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAcceleratorOfferingsRequest)) {
            return false;
        }
        DescribeAcceleratorOfferingsRequest other = (DescribeAcceleratorOfferingsRequest)((Object)obj);
        return Objects.equals(this.locationTypeAsString(), other.locationTypeAsString()) && this.hasAcceleratorTypes() == other.hasAcceleratorTypes() && Objects.equals(this.acceleratorTypes(), other.acceleratorTypes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAcceleratorOfferingsRequest").add("LocationType", (Object)this.locationTypeAsString()).add("AcceleratorTypes", this.hasAcceleratorTypes() ? this.acceleratorTypes() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locationType": {
                return Optional.ofNullable(clazz.cast(this.locationTypeAsString()));
            }
            case "acceleratorTypes": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTypes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAcceleratorOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeAcceleratorOfferingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticInferenceRequest.BuilderImpl
    implements Builder {
        private String locationType;
        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAcceleratorOfferingsRequest model) {
            super(model);
            this.locationType(model.locationType);
            this.acceleratorTypes(model.acceleratorTypes);
        }

        public final String getLocationType() {
            return this.locationType;
        }

        @Override
        public final Builder locationType(String locationType) {
            this.locationType = locationType;
            return this;
        }

        @Override
        public final Builder locationType(LocationType locationType) {
            this.locationType(locationType == null ? null : locationType.toString());
            return this;
        }

        public final void setLocationType(String locationType) {
            this.locationType = locationType;
        }

        public final Collection<String> getAcceleratorTypes() {
            if (this.acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorTypes;
        }

        @Override
        public final Builder acceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypeNameListCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(String ... acceleratorTypes) {
            this.acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypeNameListCopier.copy(acceleratorTypes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAcceleratorOfferingsRequest build() {
            return new DescribeAcceleratorOfferingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticInferenceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAcceleratorOfferingsRequest> {
        public Builder locationType(String var1);

        public Builder locationType(LocationType var1);

        public Builder acceleratorTypes(Collection<String> var1);

        public Builder acceleratorTypes(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

