/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticinference.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticinference.model.AcceleratorTypeOffering;
import software.amazon.awssdk.services.elasticinference.model.AcceleratorTypeOfferingListCopier;
import software.amazon.awssdk.services.elasticinference.model.ElasticInferenceResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAcceleratorOfferingsResponse
extends ElasticInferenceResponse
implements ToCopyableBuilder<Builder, DescribeAcceleratorOfferingsResponse> {
    private static final SdkField<List<AcceleratorTypeOffering>> ACCELERATOR_TYPE_OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("acceleratorTypeOfferings").getter(DescribeAcceleratorOfferingsResponse.getter(DescribeAcceleratorOfferingsResponse::acceleratorTypeOfferings)).setter(DescribeAcceleratorOfferingsResponse.setter(Builder::acceleratorTypeOfferings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorTypeOfferings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AcceleratorTypeOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_TYPE_OFFERINGS_FIELD));
    private final List<AcceleratorTypeOffering> acceleratorTypeOfferings;

    private DescribeAcceleratorOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.acceleratorTypeOfferings = builder.acceleratorTypeOfferings;
    }

    public boolean hasAcceleratorTypeOfferings() {
        return this.acceleratorTypeOfferings != null && !(this.acceleratorTypeOfferings instanceof SdkAutoConstructList);
    }

    public List<AcceleratorTypeOffering> acceleratorTypeOfferings() {
        return this.acceleratorTypeOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorTypeOfferings() ? this.acceleratorTypeOfferings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAcceleratorOfferingsResponse)) {
            return false;
        }
        DescribeAcceleratorOfferingsResponse other = (DescribeAcceleratorOfferingsResponse)((Object)obj);
        return this.hasAcceleratorTypeOfferings() == other.hasAcceleratorTypeOfferings() && Objects.equals(this.acceleratorTypeOfferings(), other.acceleratorTypeOfferings());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAcceleratorOfferingsResponse").add("AcceleratorTypeOfferings", this.hasAcceleratorTypeOfferings() ? this.acceleratorTypeOfferings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acceleratorTypeOfferings": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTypeOfferings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAcceleratorOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeAcceleratorOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticInferenceResponse.BuilderImpl
    implements Builder {
        private List<AcceleratorTypeOffering> acceleratorTypeOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAcceleratorOfferingsResponse model) {
            super(model);
            this.acceleratorTypeOfferings(model.acceleratorTypeOfferings);
        }

        public final Collection<AcceleratorTypeOffering.Builder> getAcceleratorTypeOfferings() {
            if (this.acceleratorTypeOfferings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorTypeOfferings != null ? (Collection)this.acceleratorTypeOfferings.stream().map(AcceleratorTypeOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder acceleratorTypeOfferings(Collection<AcceleratorTypeOffering> acceleratorTypeOfferings) {
            this.acceleratorTypeOfferings = AcceleratorTypeOfferingListCopier.copy(acceleratorTypeOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypeOfferings(AcceleratorTypeOffering ... acceleratorTypeOfferings) {
            this.acceleratorTypeOfferings(Arrays.asList(acceleratorTypeOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypeOfferings(Consumer<AcceleratorTypeOffering.Builder> ... acceleratorTypeOfferings) {
            this.acceleratorTypeOfferings(Stream.of(acceleratorTypeOfferings).map(c -> (AcceleratorTypeOffering)((AcceleratorTypeOffering.Builder)AcceleratorTypeOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAcceleratorTypeOfferings(Collection<AcceleratorTypeOffering.BuilderImpl> acceleratorTypeOfferings) {
            this.acceleratorTypeOfferings = AcceleratorTypeOfferingListCopier.copyFromBuilder(acceleratorTypeOfferings);
        }

        @Override
        public DescribeAcceleratorOfferingsResponse build() {
            return new DescribeAcceleratorOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticInferenceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAcceleratorOfferingsResponse> {
        public Builder acceleratorTypeOfferings(Collection<AcceleratorTypeOffering> var1);

        public Builder acceleratorTypeOfferings(AcceleratorTypeOffering ... var1);

        public Builder acceleratorTypeOfferings(Consumer<AcceleratorTypeOffering.Builder> ... var1);
    }
}

