/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticinference.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticinference.model.AcceleratorType;
import software.amazon.awssdk.services.elasticinference.model.AcceleratorTypeListCopier;
import software.amazon.awssdk.services.elasticinference.model.ElasticInferenceResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAcceleratorTypesResponse
extends ElasticInferenceResponse
implements ToCopyableBuilder<Builder, DescribeAcceleratorTypesResponse> {
    private static final SdkField<List<AcceleratorType>> ACCELERATOR_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("acceleratorTypes").getter(DescribeAcceleratorTypesResponse.getter(DescribeAcceleratorTypesResponse::acceleratorTypes)).setter(DescribeAcceleratorTypesResponse.setter(Builder::acceleratorTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AcceleratorType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_TYPES_FIELD));
    private final List<AcceleratorType> acceleratorTypes;

    private DescribeAcceleratorTypesResponse(BuilderImpl builder) {
        super(builder);
        this.acceleratorTypes = builder.acceleratorTypes;
    }

    public boolean hasAcceleratorTypes() {
        return this.acceleratorTypes != null && !(this.acceleratorTypes instanceof SdkAutoConstructList);
    }

    public List<AcceleratorType> acceleratorTypes() {
        return this.acceleratorTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorTypes() ? this.acceleratorTypes() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAcceleratorTypesResponse)) {
            return false;
        }
        DescribeAcceleratorTypesResponse other = (DescribeAcceleratorTypesResponse)((Object)obj);
        return this.hasAcceleratorTypes() == other.hasAcceleratorTypes() && Objects.equals(this.acceleratorTypes(), other.acceleratorTypes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAcceleratorTypesResponse").add("AcceleratorTypes", this.hasAcceleratorTypes() ? this.acceleratorTypes() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acceleratorTypes": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTypes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAcceleratorTypesResponse, T> g) {
        return obj -> g.apply((DescribeAcceleratorTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticInferenceResponse.BuilderImpl
    implements Builder {
        private List<AcceleratorType> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAcceleratorTypesResponse model) {
            super(model);
            this.acceleratorTypes(model.acceleratorTypes);
        }

        public final Collection<AcceleratorType.Builder> getAcceleratorTypes() {
            if (this.acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorTypes != null ? (Collection)this.acceleratorTypes.stream().map(AcceleratorType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder acceleratorTypes(Collection<AcceleratorType> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypeListCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(AcceleratorType ... acceleratorTypes) {
            this.acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(Consumer<AcceleratorType.Builder> ... acceleratorTypes) {
            this.acceleratorTypes(Stream.of(acceleratorTypes).map(c -> (AcceleratorType)((AcceleratorType.Builder)AcceleratorType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAcceleratorTypes(Collection<AcceleratorType.BuilderImpl> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypeListCopier.copyFromBuilder(acceleratorTypes);
        }

        @Override
        public DescribeAcceleratorTypesResponse build() {
            return new DescribeAcceleratorTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticInferenceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAcceleratorTypesResponse> {
        public Builder acceleratorTypes(Collection<AcceleratorType> var1);

        public Builder acceleratorTypes(AcceleratorType ... var1);

        public Builder acceleratorTypes(Consumer<AcceleratorType.Builder> ... var1);
    }
}

