/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticinference.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAcceleratorOfferingsRequest extends ElasticInferenceRequest implements
        ToCopyableBuilder<DescribeAcceleratorOfferingsRequest.Builder, DescribeAcceleratorOfferingsRequest> {
    private static final SdkField<String> LOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("locationType").getter(getter(DescribeAcceleratorOfferingsRequest::locationTypeAsString))
            .setter(setter(Builder::locationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationType").build()).build();

    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("acceleratorTypes")
            .getter(getter(DescribeAcceleratorOfferingsRequest::acceleratorTypes))
            .setter(setter(Builder::acceleratorTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_TYPE_FIELD,
            ACCELERATOR_TYPES_FIELD));

    private final String locationType;

    private final List<String> acceleratorTypes;

    private DescribeAcceleratorOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.locationType = builder.locationType;
        this.acceleratorTypes = builder.acceleratorTypes;
    }

    /**
     * <p>
     * The location type that you want to describe accelerator type offerings for. It can assume the following values:
     * region: will return the accelerator type offering at the regional level. availability-zone: will return the
     * accelerator type offering at the availability zone level. availability-zone-id: will return the accelerator type
     * offering at the availability zone level returning the availability zone id.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locationType} will
     * return {@link LocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #locationTypeAsString}.
     * </p>
     * 
     * @return The location type that you want to describe accelerator type offerings for. It can assume the following
     *         values: region: will return the accelerator type offering at the regional level. availability-zone: will
     *         return the accelerator type offering at the availability zone level. availability-zone-id: will return
     *         the accelerator type offering at the availability zone level returning the availability zone id.
     * @see LocationType
     */
    public LocationType locationType() {
        return LocationType.fromValue(locationType);
    }

    /**
     * <p>
     * The location type that you want to describe accelerator type offerings for. It can assume the following values:
     * region: will return the accelerator type offering at the regional level. availability-zone: will return the
     * accelerator type offering at the availability zone level. availability-zone-id: will return the accelerator type
     * offering at the availability zone level returning the availability zone id.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locationType} will
     * return {@link LocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #locationTypeAsString}.
     * </p>
     * 
     * @return The location type that you want to describe accelerator type offerings for. It can assume the following
     *         values: region: will return the accelerator type offering at the regional level. availability-zone: will
     *         return the accelerator type offering at the availability zone level. availability-zone-id: will return
     *         the accelerator type offering at the availability zone level returning the availability zone id.
     * @see LocationType
     */
    public String locationTypeAsString() {
        return locationType;
    }

    /**
     * Returns true if the AcceleratorTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAcceleratorTypes() {
        return acceleratorTypes != null && !(acceleratorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of accelerator types to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAcceleratorTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of accelerator types to describe.
     */
    public List<String> acceleratorTypes() {
        return acceleratorTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceleratorTypes() ? acceleratorTypes() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAcceleratorOfferingsRequest)) {
            return false;
        }
        DescribeAcceleratorOfferingsRequest other = (DescribeAcceleratorOfferingsRequest) obj;
        return Objects.equals(locationTypeAsString(), other.locationTypeAsString())
                && hasAcceleratorTypes() == other.hasAcceleratorTypes()
                && Objects.equals(acceleratorTypes(), other.acceleratorTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAcceleratorOfferingsRequest").add("LocationType", locationTypeAsString())
                .add("AcceleratorTypes", hasAcceleratorTypes() ? acceleratorTypes() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "locationType":
            return Optional.ofNullable(clazz.cast(locationTypeAsString()));
        case "acceleratorTypes":
            return Optional.ofNullable(clazz.cast(acceleratorTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAcceleratorOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeAcceleratorOfferingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticInferenceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAcceleratorOfferingsRequest> {
        /**
         * <p>
         * The location type that you want to describe accelerator type offerings for. It can assume the following
         * values: region: will return the accelerator type offering at the regional level. availability-zone: will
         * return the accelerator type offering at the availability zone level. availability-zone-id: will return the
         * accelerator type offering at the availability zone level returning the availability zone id.
         * </p>
         * 
         * @param locationType
         *        The location type that you want to describe accelerator type offerings for. It can assume the
         *        following values: region: will return the accelerator type offering at the regional level.
         *        availability-zone: will return the accelerator type offering at the availability zone level.
         *        availability-zone-id: will return the accelerator type offering at the availability zone level
         *        returning the availability zone id.
         * @see LocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationType
         */
        Builder locationType(String locationType);

        /**
         * <p>
         * The location type that you want to describe accelerator type offerings for. It can assume the following
         * values: region: will return the accelerator type offering at the regional level. availability-zone: will
         * return the accelerator type offering at the availability zone level. availability-zone-id: will return the
         * accelerator type offering at the availability zone level returning the availability zone id.
         * </p>
         * 
         * @param locationType
         *        The location type that you want to describe accelerator type offerings for. It can assume the
         *        following values: region: will return the accelerator type offering at the regional level.
         *        availability-zone: will return the accelerator type offering at the availability zone level.
         *        availability-zone-id: will return the accelerator type offering at the availability zone level
         *        returning the availability zone id.
         * @see LocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationType
         */
        Builder locationType(LocationType locationType);

        /**
         * <p>
         * The list of accelerator types to describe.
         * </p>
         * 
         * @param acceleratorTypes
         *        The list of accelerator types to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(Collection<String> acceleratorTypes);

        /**
         * <p>
         * The list of accelerator types to describe.
         * </p>
         * 
         * @param acceleratorTypes
         *        The list of accelerator types to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(String... acceleratorTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticInferenceRequest.BuilderImpl implements Builder {
        private String locationType;

        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAcceleratorOfferingsRequest model) {
            super(model);
            locationType(model.locationType);
            acceleratorTypes(model.acceleratorTypes);
        }

        public final String getLocationType() {
            return locationType;
        }

        @Override
        public final Builder locationType(String locationType) {
            this.locationType = locationType;
            return this;
        }

        @Override
        public final Builder locationType(LocationType locationType) {
            this.locationType(locationType == null ? null : locationType.toString());
            return this;
        }

        public final void setLocationType(String locationType) {
            this.locationType = locationType;
        }

        public final Collection<String> getAcceleratorTypes() {
            if (acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return acceleratorTypes;
        }

        @Override
        public final Builder acceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypeNameListCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(String... acceleratorTypes) {
            acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypeNameListCopier.copy(acceleratorTypes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAcceleratorOfferingsRequest build() {
            return new DescribeAcceleratorOfferingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
